/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.label.MultiLineLabel;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBasicAuthenticationDialog
extends JDialog {
    private static Logger logger_ = LoggerFactory.getLogger(PanBasicAuthenticationDialog.class);
    private JTextField nameTF_;
    private JPasswordField passwdTF_;
    private boolean success_;

    public PanBasicAuthenticationDialog(JFrame parent, AuthScheme scheme, String host, int port) {
        super(parent, "Authentication", true);
        MultiLineLabel messageLabel = new MultiLineLabel("To access the dataset, you must log in to this area\non " + host + ":" + port + ":", 2);
        JLabel realmLabel = new JLabel("    " + scheme.getRealm());
        JLabel warningLabel = new JLabel("Your password will be sent unencrypted.");
        JLabel nameLabel = new JLabel("Name: ");
        JLabel passwdLabel = new JLabel("Password: ");
        Font lFont = UIManager.getDefaults().getFont("Label.font");
        messageLabel.setFont(lFont);
        realmLabel.setFont(lFont.deriveFont((float)((double)lFont.getSize() - 2.0)));
        warningLabel.setFont(realmLabel.getFont());
        this.nameTF_ = new JTextField("", 20);
        this.passwdTF_ = new JPasswordField("", 20);
        JButton cancelButton = new JButton("Cancel");
        JButton loginButton = new JButton("Load");
        QuickBox buttonBox = PlatformUtilities.isMacintosh() ? QuickBox.createRightBox(cancelButton, loginButton) : QuickBox.createRightBox(loginButton, cancelButton);
        GuiUtilities.padBorder(realmLabel, 0, 0, 6, 0);
        GuiUtilities.padBorder(warningLabel, 0, 0, 6, 0);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(2, 6, 0, 5);
        fgl.setColumnWeight(1, 9999.0f);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(PanGuiConstants.STD_BORDER);
        contentPanel.add((Component)messageLabel, new FGConstraint(0, 0, 2, 1, 0.0, 0.5));
        contentPanel.add((Component)realmLabel, new FGConstraint(0, 1, 2, 1, 0.0, 0.5));
        contentPanel.add((Component)warningLabel, new FGConstraint(0, 2, 2, 1, 0.0, 0.5));
        contentPanel.add((Component)nameLabel, new FGConstraint(0, 3, 0.0, 0.5));
        contentPanel.add((Component)this.nameTF_, new FGConstraint(1, 3, 0.0, 0.5));
        contentPanel.add((Component)passwdLabel, new FGConstraint(0, 4, 0.0, 0.5));
        contentPanel.add((Component)this.passwdTF_, new FGConstraint(1, 4, 0.0, 0.5));
        contentPanel.add((Component)buttonBox, new FGConstraint(0, 5, 2, 1, 1.0, 0.5));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(loginButton);
        loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanBasicAuthenticationDialog.this.success_ = true;
                PanBasicAuthenticationDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanBasicAuthenticationDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setSize(this.getPreferredSize());
        Rectangle rr = parent.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.nameTF_.grabFocus();
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public UsernamePasswordCredentials getCredentials() {
        return new UsernamePasswordCredentials(this.nameTF_.getText(), new String(this.passwdTF_.getPassword()));
    }
}

