/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.panoply.PanBasicAuthenticationDialog;
import gov.nasa.giss.panoply.PanFrame;
import java.awt.EventQueue;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanAuthenticationManager
implements CredentialsProvider {
    private static Logger logger_ = LoggerFactory.getLogger(PanAuthenticationManager.class);

    @Override
    public synchronized Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        boolean onEDT = EventQueue.isDispatchThread();
        if (!onEDT) {
            throw new CredentialsNotAvailableException("Must run PanAuthenticationManager from Event Dispatch Thread");
        }
        try {
            PanFrame aframe = PanFrame.getActiveFrame();
            PanBasicAuthenticationDialog dialog = new PanBasicAuthenticationDialog(aframe, scheme, host, port);
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (dialog.isSuccessful()) {
                return dialog.getCredentials();
            }
        }
        catch (Exception exc) {
            logger_.warn("PanAuthenticationManager getCredentials error: " + exc.toString());
        }
        throw new CredentialsNotAvailableException();
    }
}

