/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.data.DataEvent;
import gov.nasa.giss.data.DataListener;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.label.VerticalLabel;
import gov.nasa.giss.gui.table.TableRowHeader;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.netcdf.array.NcArrayLonLat;
import gov.nasa.giss.netcdf.array.NcArrayLonLatFvcomNodes;
import gov.nasa.giss.netcdf.array.NcArrayLonLatReducedType1;
import gov.nasa.giss.netcdf.array.NcArrayLonLatReducedType2;
import gov.nasa.giss.netcdf.array.NcArrayLonLatScatterNodes;
import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.PanArray2DAverageTableModel;
import gov.nasa.giss.panoply.PanArray2DTableModel;
import gov.nasa.giss.panoply.PanArrayDataTable;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanNumberFormatMenu;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanArrayDataPanel
extends JPanel
implements DataListener {
    private static Logger logger_ = LoggerFactory.getLogger(PanArrayDataPanel.class);
    private PanPlotType plotType_;
    private NcArray array_;
    private NcAxis xAxis_;
    private NcAxis yAxis_;
    private JScrollPane spane1_;
    private JScrollPane spane2_;
    private PanArrayDataTable table1_;
    private PanArrayDataTable table2_;
    private JLabel[] sliceLabels_;
    private JPanel tablePanel_;

    public PanArrayDataPanel(PanPlotType type, PanAbstractData data, int vindex) {
        this.plotType_ = type;
        this.array_ = data.getArray(vindex);
        if (this.array_ == null) {
            throw new IllegalArgumentException("Array " + vindex + " is null");
        }
        int numValues = 0;
        if (this.array_ instanceof NcArray2D) {
            this.xAxis_ = ((NcArray2D)this.array_).getXAxis();
            this.yAxis_ = ((NcArray2D)this.array_).getYAxis();
            numValues = this.yAxis_.getSize() * this.yAxis_.getSize();
        } else if (!(this.array_ instanceof NcArrayLonLatReducedType1 || this.array_ instanceof NcArrayLonLatReducedType2 || this.array_ instanceof NcArrayLonLatFvcomNodes || this.array_ instanceof NcArrayLonLatScatterNodes)) {
            throw new IllegalArgumentException("Not a recognized NcArray");
        }
        data.addDataListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.setOpaque(false);
        JPanel topPanel = this.constructTopPanel();
        this.tablePanel_ = this.constructTablePanel();
        this.add((Component)topPanel, "North");
        this.add((Component)this.tablePanel_, "Center");
    }

    private JPanel constructTopPanel() {
        NcDimension[] freeDims = this.array_.getFreeDimensions();
        int scount = freeDims.length;
        this.sliceLabels_ = new JLabel[scount];
        for (int i = 0; i < scount; ++i) {
            this.sliceLabels_[i] = freeDims[i] == null ? null : new JLabel("");
        }
        this.updateLabels();
        int rows = Math.max(3, scount - 2);
        FlexingGridLayout fglTop = new FlexingGridLayout(2, rows, 2, 1);
        fglTop.setRigidWidth(true);
        fglTop.setRigidHeight(true);
        JPanel panel = new JPanel(fglTop);
        JLabel datasetLabel = new JLabel("Dataset: " + this.array_.getDataset().getName() + " ");
        StringBuilder varName = new StringBuilder("Variable: " + this.array_.getName());
        if (this.array_.getLongName() != null) {
            varName.append(", " + this.array_.getLongName());
        }
        JLabel varLabel = new JLabel(varName.toString() + " ");
        panel.add((Component)datasetLabel, new FGConstraint(0, 0, 0.0, 0.5));
        panel.add((Component)varLabel, new FGConstraint(0, 1, 0.0, 0.5));
        if (this.array_.getUnits() != null) {
            JLabel unitsLabel = new JLabel("Units: " + this.array_.getUnits() + " ");
            panel.add((Component)unitsLabel, new FGConstraint(0, 2, 0.0, 0.5));
        }
        if (this.sliceLabels_ != null) {
            int row = 0;
            for (JLabel label : this.sliceLabels_) {
                if (label == null) continue;
                panel.add((Component)label, new FGConstraint(1, row, 0.0, 0.5));
                ++row;
            }
        }
        panel.setOpaque(false);
        return panel;
    }

    private JPanel constructTablePanel() {
        TableRowHeader rowHeader = null;
        if (this.array_ instanceof NcArray2D) {
            this.table1_ = new PanArrayDataTable(new PanArray2DTableModel((NcArray2D)this.array_));
            if (this.array_ instanceof NcArrayLonLat) {
                this.table2_ = new PanArrayDataTable(new PanArray2DAverageTableModel((NcArray2D)this.array_));
            }
            String[] rowHeaders = new String[this.yAxis_.getSize()];
            for (int j = 0; j < rowHeaders.length; ++j) {
                double val = this.yAxis_.valueAt(j);
                double absval = Math.abs(val);
                rowHeaders[j] = absval > 0.1 && absval < 10000.0 ? PanConstants.PFORMAT_3.sprintf(val) : PanConstants.PFORMAT_3G.sprintf(val);
            }
            rowHeader = new TableRowHeader((JTable)this.table1_, rowHeaders);
        } else if (this.array_ instanceof NcArrayLonLatReducedType1) {
            // empty if block
        }
        this.spane1_ = new JScrollPane(this.table1_);
        if (rowHeader == null) {
            this.spane1_.setVerticalScrollBarPolicy(21);
        } else {
            this.spane1_.setRowHeaderView(rowHeader);
            this.spane1_.setVerticalScrollBarPolicy(22);
        }
        this.spane1_.setHorizontalScrollBarPolicy(30);
        this.spane2_ = null;
        if (this.table2_ != null) {
            this.spane2_ = new JScrollPane(this.table2_);
            this.spane2_.setVerticalScrollBarPolicy(this.spane2_.getVerticalScrollBarPolicy());
            JScrollBar vbar = this.spane1_.getVerticalScrollBar();
            this.spane2_.setVerticalScrollBar(vbar);
            this.spane2_.updateUI();
            this.spane1_.updateUI();
            int xWidth = this.spane2_.getInsets().left + this.table2_.getPreferredSize().width + vbar.getPreferredSize().width + this.spane2_.getInsets().right;
            this.spane2_.setPreferredSize(new Dimension(xWidth, this.spane2_.getPreferredSize().height));
            this.spane2_.setMaximumSize(new Dimension(xWidth, this.spane2_.getMaximumSize().height));
            this.spane2_.setMinimumSize(new Dimension(xWidth, this.spane2_.getMinimumSize().height));
        }
        FlexingGridLayout fglbottom = new FlexingGridLayout(3, 3, 2, 2);
        fglbottom.setColumnWeight(1, 9999.0f);
        fglbottom.setRowWeight(1, 9999.0f);
        JPanel panel = new JPanel(fglbottom);
        panel.setOpaque(false);
        if (this.xAxis_ != null) {
            JLabel xAxisLabel = new JLabel("X-Axis: " + this.xAxis_.getLongName() + " (" + this.xAxis_.getUnits() + ") ");
            panel.add((Component)xAxisLabel, new FGConstraint(0, 0, 3, 1, 0.5, 0.5));
        }
        if (this.yAxis_ != null) {
            VerticalLabel yAxisLabel = new VerticalLabel("Y-Axis: " + this.yAxis_.getLongName() + " (" + this.yAxis_.getUnits() + ")");
            panel.add((Component)yAxisLabel, new FGConstraint(0, 1, 0.5, 0.5));
        }
        if (this.table2_ != null) {
            panel.add((Component)this.spane1_, new FGConstraint(1, 1, 1, 1, true));
            panel.add((Component)this.spane2_, new FGConstraint(2, 1, 1, 1, true));
        } else {
            panel.add((Component)this.spane1_, new FGConstraint(1, 1, 2, 1, 1.0, 1.0, true));
        }
        String pfFormat = PanPreferences.getPrefs().getString("plot:scale.tick.format");
        PrintfFormat formatter = new PrintfFormat(pfFormat);
        if (this.table1_ != null) {
            this.table1_.setFormatter(formatter);
        }
        if (this.table2_ != null) {
            this.table2_.setFormatter(formatter);
        }
        JLabel formatLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Format: ");
        final PanNumberFormatMenu formatMenu = PanWidgetUtils.getNumberFormatMenu(PanWidgetUtils.Size.SMALL, null);
        formatMenu.setSelectedItem(pfFormat);
        formatMenu.setMaximumSize(formatMenu.getPreferredSize());
        QuickBox formatBox = QuickBox.createCenterBox(formatLabel, formatMenu);
        panel.add((Component)formatBox, new FGConstraint(0, 2, 3, 1, 0.5, 0.5));
        formatMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PrintfFormat formatter = new PrintfFormat(formatMenu.getSelectedItem().toString());
                if (PanArrayDataPanel.this.table1_ != null) {
                    PanArrayDataPanel.this.table1_.setFormatter(formatter);
                }
                if (PanArrayDataPanel.this.table2_ != null) {
                    PanArrayDataPanel.this.table2_.setFormatter(formatter);
                }
            }
        });
        return panel;
    }

    public void refresh() {
        if (this.spane2_ != null) {
            if (this.spane1_.getHorizontalScrollBar().isVisible()) {
                this.spane2_.setHorizontalScrollBarPolicy(32);
            } else {
                this.spane2_.setHorizontalScrollBarPolicy(31);
            }
        }
        if (this.table1_ != null) {
            this.table1_.repaint();
        }
        if (this.table2_ != null) {
            this.table2_.repaint();
        }
    }

    public void setSelectedCellNear(double x, double y) {
        if (this.array_ instanceof NcArray2D) {
            NcArray2D array2d = (NcArray2D)this.array_;
            int xx = array2d.getXAxis().findNearestIndex(x);
            int yy = array2d.getYAxis().findNearestIndex(y);
            if (xx > -1 && yy > -1) {
                this.setSelectedCell(new Point(xx, yy));
            }
        }
    }

    public void setSelectedCell(Point cell) {
        if (this.table1_ != null) {
            this.table1_.changeSelection(cell.y, cell.x, false, false);
        }
    }

    public void updateLabels() {
        NcDimension[] freeDims = this.array_.getFreeDimensions();
        for (int i = 0; i < freeDims.length; ++i) {
            if (this.sliceLabels_[i] == null) continue;
            int numIndices = freeDims[i].getLength();
            int index = this.array_.getSliceIndex(i);
            if (index > numIndices) {
                this.sliceLabels_[i].setText("Zonal Average");
            } else {
                StringBuilder sb = new StringBuilder("Slice: ").append(freeDims[i].getLongName()).append(" ");
                if (index < numIndices) {
                    sb.append("[").append(index + 1).append(" of ").append(numIndices).append("]");
                }
                sb.append(" = ");
                if (index == -1) {
                    sb.append("Average over all ").append(numIndices).append(" indices in dimension");
                } else if (index < numIndices) {
                    if (freeDims[i].hasBounds()) {
                        sb.append(freeDims[i].getFormattedBounds()[index]);
                    } else {
                        sb.append(freeDims[i].getFormattedValues()[index]);
                    }
                    String us = freeDims[i].getUnits();
                    if (us != null && us.length() > 0) {
                        sb.append(" ").append(us);
                    }
                } else {
                    logger_.warn("Weird value for 'index'");
                }
                this.sliceLabels_[i].setText(sb.toString() + "  ");
            }
            this.sliceLabels_[i].repaint();
        }
    }

    @Override
    public void dataChanged(DataEvent e) {
        if (e == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanArrayDataPanel.this.updateLabels();
                PanArrayDataPanel.this.refresh();
            }
        });
    }
}

