/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.menu.GissCheckBoxMenuItem;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.panoply.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanPanel;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSlicer;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanArrayControls
extends PanAbstractControlsPanel {
    private static Logger logger_ = LoggerFactory.getLogger(PanArrayControls.class);
    private PanPanel[] slicePanels_ = new PanPanel[2];
    private Box combinationBox_;
    private JComboBox lonlatTypeMenu_;
    private JComboBox combinationMenu_;
    private JCheckBox interpolateCB_;
    private JCheckBox linkCB_;

    public PanArrayControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("array-controls", pmeta);
        this.setLayout(null);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.addCombinationPanel(mbar);
        this.addSlicePanel(0);
    }

    private void addCombinationPanel(PanMenuBar mbar) {
        PanAbstractData data;
        JLabel plotLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Plot ");
        JLabel ofLabel = null;
        if (this.pmeta_.get("plot:type") == PanPlotType.LON_LAT) {
            boolean isMap;
            String m1 = PanProperties.MENUS.getString("plot-type-m1");
            String m2 = PanProperties.MENUS.getString("plot-type-m2");
            String z1 = PanProperties.MENUS.getString("plot-type-z1");
            String z2 = PanProperties.MENUS.getString("plot-type-z2");
            LonLatPlotTypeAction pta = new LonLatPlotTypeAction();
            this.lonlatTypeMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.SMALL, "plot:lonlat.type");
            this.lonlatTypeMenu_.addItem(m1);
            this.lonlatTypeMenu_.addItem(z1);
            this.lonlatTypeMenu_.setAction(pta);
            GuiUtilities.restrictSize(this.lonlatTypeMenu_);
            JMenuItem jmi = mbar.getItemByName("plot-menu", "plot-type");
            jmi.setAction(pta);
            jmi.setEnabled(true);
            String current = this.pmeta_.getString("plot:lonlat.type");
            boolean bl = isMap = current.equalsIgnoreCase(m1) || current.equalsIgnoreCase(m2);
            if (isMap) {
                jmi.setText(z2);
                this.lonlatTypeMenu_.setSelectedItem(m1);
            } else {
                jmi.setText(m2);
                this.lonlatTypeMenu_.setSelectedItem(z1);
            }
            ofLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, " of ");
        }
        if ((data = this.getData()).getArray(0) != null && data.getArray(1) != null) {
            this.combinationMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.SMALL, "plot:combination", PanCombinationType.values());
        } else if (data.getArray(0) != null) {
            this.combinationMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.SMALL, "plot:combination", new PanCombinationType[]{PanCombinationType.ONE_ARRAY_DEFAULT});
        } else if (data.getArray(1) != null) {
            // empty if block
        }
        InterpolateAction interpolateAction = new InterpolateAction();
        this.interpolateCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:scale.interpolate", "Interpolate");
        this.interpolateCB_.setAction(interpolateAction);
        this.interpolateCB_.setSelected(this.pmeta_.getBoolean("plot:scale.interpolate"));
        this.interpolateCB_.setToolTipText("Enable/disable interpolation");
        GissCheckBoxMenuItem cbmi = (GissCheckBoxMenuItem)mbar.getItemByName("plot-menu", "interpolate");
        cbmi.setAction(interpolateAction);
        cbmi.setSelected(this.interpolateCB_.isSelected());
        this.combinationBox_ = Box.createHorizontalBox();
        this.combinationBox_.add(plotLabel);
        if (this.lonlatTypeMenu_ != null) {
            this.combinationBox_.add(this.lonlatTypeMenu_);
            this.combinationBox_.add(ofLabel);
        }
        this.combinationBox_.add(this.combinationMenu_);
        this.combinationBox_.add(Box.createHorizontalStrut(2));
        this.combinationBox_.add(this.interpolateCB_);
        this.add(this.combinationBox_);
        this.combinationMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanCombinationType ctype = (PanCombinationType)PanArrayControls.this.combinationMenu_.getSelectedItem();
                PanArrayControls.this.pmeta_.setDataCombination(ctype, null);
            }
        });
    }

    private void addSlicePanel(final int vnum) {
        NcArray ncarray = this.getData().getArray(vnum);
        if (this.slicePanels_[vnum] != null) {
            this.removeSlicePanel(vnum);
        }
        this.slicePanels_[vnum] = new PanPanel();
        this.slicePanels_[vnum].setLayout(new BoxLayout(this.slicePanels_[vnum], 1));
        this.slicePanels_[vnum].setName("[slice panel " + vnum + "]");
        String btitle = ncarray == null ? "Array " + (vnum + 1) : "Array " + (vnum + 1) + ": " + ncarray.getName();
        TitledBorder border = new TitledBorder(btitle);
        GuiUtilities.setSizeSmall(border);
        this.slicePanels_[vnum].setBorder(border);
        JLabel sliceLabel = null;
        if (ncarray == null) {
            sliceLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "None selected");
        } else if (!ncarray.hasFreeDimensions()) {
            sliceLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "No additional dimensions");
        }
        if (sliceLabel != null) {
            sliceLabel.setAlignmentX(0.0f);
            this.slicePanels_[vnum].add(sliceLabel);
        } else {
            NcDimension[] freeDims = ncarray.getFreeDimensions();
            for (int i = 0; i < freeDims.length; ++i) {
                if (freeDims[i] == null) continue;
                final int ii = i;
                final PanSlicer slicer = new PanSlicer(freeDims[i], ncarray.isAveragingDimension(i));
                slicer.setAlignmentX(0.0f);
                this.slicePanels_[vnum].add(slicer);
                slicer.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int index = slicer.getSelectedIndex();
                        PanPlotFrame pf = PanArrayControls.this.getParentFrame();
                        pf.getMeta().setDataSlice(vnum, ii, index, null);
                    }
                });
            }
        }
        this.add(this.slicePanels_[vnum]);
    }

    public void updateSlicePanel(int vnum) {
        this.addSlicePanel(vnum);
        if (this.combinationMenu_.getItemCount() > 1) {
            return;
        }
        for (PanCombinationType ct : PanCombinationType.values()) {
            if (ct == PanCombinationType.ONE_ARRAY_DEFAULT) continue;
            this.combinationMenu_.addItem(ct);
        }
        this.combinationMenu_.setMaximumSize(this.combinationMenu_.getPreferredSize());
        this.combinationMenu_.setSelectedItem(PanCombinationType.TWO_ARRAYS_DEFAULT);
        this.combinationMenu_.setMaximumRowCount(24);
        this.validate();
    }

    public void setCombinationType(PanCombinationType ctype) {
        logger_.debug("{}", (Object)ctype);
        try {
            this.combinationMenu_.setSelectedItem(ctype);
        }
        catch (Exception exc) {
            logger_.warn("failed - {}", (Object)exc.toString());
        }
    }

    private void removeSlicePanel(int vnum) {
        this.remove(this.slicePanels_[vnum]);
        for (Component child : this.slicePanels_[vnum].getComponents()) {
            ActionListener[] listeners;
            if (child == null || !(child instanceof PanSlicer)) continue;
            PanSlicer slicer = (PanSlicer)child;
            for (ActionListener al : listeners = slicer.getActionListeners()) {
                slicer.removeActionListener(al);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        Dimension d0 = this.slicePanels_[0].getPreferredSize();
        if (this.slicePanels_[1] == null) {
            int w = ins.left + 2 * d0.width + 8 + ins.right;
            int h = ins.top + this.combinationBox_.getPreferredSize().height + 2 + d0.height + ins.bottom;
            Dimension d = new Dimension(w, h);
            return d;
        }
        Dimension d1 = this.slicePanels_[1].getPreferredSize();
        int w = ins.left + 2 * Math.max(d0.width, d1.width) + 8 + ins.right;
        int h = ins.top + this.combinationBox_.getPreferredSize().height + 2 + Math.max(d0.height, d1.height) + ins.bottom;
        Dimension d = new Dimension(w, h);
        return d;
    }

    @Override
    public void doLayout() {
        Insets ins = this.getInsets();
        int w = this.getWidth();
        int tw = this.combinationBox_.getPreferredSize().width;
        int th = this.combinationBox_.getPreferredSize().height;
        int btop = ins.top + th + 2;
        int bw = (w - ins.left - ins.right - 8) / 2;
        this.combinationBox_.setBounds((w - tw) / 2, ins.top, tw, th);
        if (this.slicePanels_[1] == null) {
            int ww = Math.max(bw, Math.min(w - ins.left - ins.right, this.slicePanels_[0].getPreferredSize().width));
            this.slicePanels_[0].setBounds((w - ww) / 2, btop, ww, this.slicePanels_[0].getPreferredSize().height);
        } else {
            this.slicePanels_[0].setBounds(ins.left, btop, bw, this.slicePanels_[0].getPreferredSize().height);
            this.slicePanels_[1].setBounds(ins.left + bw + 2, btop, bw, this.slicePanels_[1].getPreferredSize().height);
        }
    }

    class LonLatPlotTypeAction
    extends AbstractAction {
        private boolean busy_;

        LonLatPlotTypeAction() {
            super("Plot Type");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            Object source = e.getSource();
            PanPlotFrame pf = PanArrayControls.this.getParentFrame();
            if (pf == null) {
                this.busy_ = false;
                return;
            }
            String m1 = PanProperties.MENUS.getString("plot-type-m1");
            String m2 = PanProperties.MENUS.getString("plot-type-m2");
            String z1 = PanProperties.MENUS.getString("plot-type-z1");
            String z2 = PanProperties.MENUS.getString("plot-type-z2");
            String current = pf.getMeta().getString("plot:lonlat.type");
            boolean wasMap = current.equalsIgnoreCase(m1) || current.equalsIgnoreCase(m2);
            PanMenuBar mbar = pf.getPanMenuBar();
            if (wasMap) {
                PanArrayControls.this.lonlatTypeMenu_.setSelectedItem(z1);
                mbar.getItemByName("plot-menu", "plot-type").setText(m2);
            } else {
                PanArrayControls.this.lonlatTypeMenu_.setSelectedItem(m1);
                mbar.getItemByName("plot-menu", "plot-type").setText(z2);
            }
            String becomes = wasMap ? z1 : m1;
            pf.getMeta().setString("plot:lonlat.type", becomes);
            pf.refresh();
            this.busy_ = false;
        }
    }

    class InterpolateAction
    extends AbstractAction {
        private boolean busy_;

        InterpolateAction() {
            super("Interpolate");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            Object source = e.getSource();
            if (source == null) {
                this.busy_ = false;
                return;
            }
            PanPlotFrame pf = PanArrayControls.this.getParentFrame();
            if (pf == null) {
                this.busy_ = false;
                return;
            }
            boolean setOn = false;
            if (source instanceof JCheckBox) {
                setOn = ((JCheckBox)source).isSelected();
                PanMenuBar mbar = pf.getPanMenuBar();
                ((JCheckBoxMenuItem)mbar.getItemByName("plot-menu", "interpolate")).setSelected(setOn);
            } else if (source instanceof JCheckBoxMenuItem) {
                setOn = ((JCheckBoxMenuItem)source).isSelected();
                PanArrayControls.this.interpolateCB_.setSelected(setOn);
            } else {
                this.busy_ = false;
                throw new RuntimeException("Event source is unexpected object " + source.getClass());
            }
            pf.getMeta().setBoolean("plot:scale.interpolate", setOn);
            this.busy_ = false;
        }
    }
}

