/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.array.NcArrayLonLat;
import gov.nasa.giss.panoply.PanArrayTableModel;
import gov.nasa.giss.panoply.PanConstants;

public class PanArray2DTableModel
extends PanArrayTableModel {
    protected NcArray2D array_;

    public PanArray2DTableModel(NcArray2D array) {
        this.array_ = array;
    }

    @Override
    public int getColumnCount() {
        try {
            return this.array_.getXAxis().getSize();
        }
        catch (Exception exc) {
            return 0;
        }
    }

    @Override
    public int getRowCount() {
        try {
            if (this.array_ instanceof NcArray2D) {
                return this.array_.getYAxis().getSize();
            }
            return 1;
        }
        catch (Exception exc) {
            return 0;
        }
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        try {
            double absval;
            double val;
            if (this.array_ instanceof NcArrayLonLat) {
                for (val = this.array_.getXAxis().valueAt(col); val < -180.0; val += 360.0) {
                }
                while (val > 180.0) {
                    val -= 360.0;
                }
            }
            return (absval = Math.abs(val)) > 0.1 && absval < 10000.0 ? PanConstants.PFORMAT_3.sprintf(val) : PanConstants.PFORMAT_3G.sprintf(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            if (this.array_ instanceof NcArray2D) {
                return this.valFormatter_.sprintf(this.array_.valueAt(col, row));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "ERR";
    }
}

