/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.panoply.PanAbstractData2D;
import gov.nasa.giss.panoply.PanAnimationFormat;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanAnimationOptionsDialog
extends JDialog {
    private static final Integer[] FRATE_CHOICES = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private JComboBox formatMenu_;
    private JComboBox frateMenu_;
    private JCheckBox subtitleCB_;
    private PercentSpinner qspinner_;
    private NcDimension[] dimensions_ = new NcDimension[2];
    private boolean success_;

    public PanAnimationOptionsDialog(PanPlotFrame pframe) {
        super(pframe, "Animation Options", true);
        this.setResizable(false);
        JLabel formatLabel = new JLabel("Format: ");
        this.formatMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.NORMAL, null, (Object[])PanAnimationFormat.values());
        PanAnimationFormat format = PanAnimationFormat.QUICKTIME;
        this.formatMenu_.setSelectedItem((Object)format);
        String fext = PREFS.getString("save:animation.extension");
        for (PanAnimationFormat form : PanAnimationFormat.values()) {
            if (!form.getExtension().equals(fext)) continue;
            format = form;
            this.formatMenu_.setSelectedItem((Object)form);
            break;
        }
        QuickBox formatBox = QuickBox.createLeftBox(this.formatMenu_);
        formatLabel.setMaximumSize(formatLabel.getPreferredSize());
        this.formatMenu_.setMaximumSize(this.formatMenu_.getPreferredSize());
        JLabel frateLabel = new JLabel("Frame Rate: ");
        this.frateMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.NORMAL, null, FRATE_CHOICES);
        int frate = Math.max(1, PREFS.getInt("save:animation.frate"));
        frate = Math.min(frate, FRATE_CHOICES[FRATE_CHOICES.length - 1]);
        this.frateMenu_.setSelectedItem(new Integer(frate));
        this.frateMenu_.setEnabled(format.isVideo());
        QuickBox frateBox = QuickBox.createLeftBox(this.frateMenu_, new JLabel("fps"));
        frateLabel.setMaximumSize(frateLabel.getPreferredSize());
        this.frateMenu_.setMaximumSize(this.frateMenu_.getPreferredSize());
        this.qspinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.NORMAL, null);
        int quality = Math.min(100, PREFS.getInt("save:animation.quality"));
        quality = Math.max(quality, 10);
        this.qspinner_.setValue(quality);
        this.qspinner_.setEnabled(format.isCompressible());
        JLabel ttext = new JLabel("Select dimension for animation frames:");
        JPanel spanel0 = null;
        JPanel spanel1 = null;
        PanAbstractData2D data = (PanAbstractData2D)pframe.getData();
        PanCombinationType ctype = data.getCombinationType();
        if (ctype == PanCombinationType.A1_ONLY) {
            spanel0 = this.makeSlicePanel(pframe, 0, false);
        } else if (ctype == PanCombinationType.A2_ONLY) {
            spanel1 = this.makeSlicePanel(pframe, 1, false);
        } else {
            spanel0 = this.makeSlicePanel(pframe, 0, true);
            spanel1 = this.makeSlicePanel(pframe, 1, true);
        }
        boolean dimsub = PREFS.getBoolean("save:animation.subtitles");
        this.subtitleCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Show frame info as sub-title", dimsub);
        QuickBox noteBox = QuickBox.createLeftBox(this.subtitleCB_);
        JButton cancelButton = new JButton("Cancel");
        JButton makeButton = new JButton("Okay");
        QuickBox buttonBox = PlatformUtilities.isMacintosh() ? QuickBox.createRightBox(cancelButton, makeButton) : QuickBox.createRightBox(makeButton, cancelButton);
        int minwidth = frateBox.getMinimumSize().width;
        minwidth = Math.max(formatBox.getMinimumSize().width, minwidth);
        minwidth = Math.max(ttext.getMinimumSize().width, minwidth);
        if (spanel0 != null) {
            minwidth = Math.max(spanel0.getMinimumSize().width, minwidth);
        }
        if (spanel1 != null) {
            minwidth = Math.max(spanel1.getMinimumSize().width, minwidth);
        }
        minwidth = Math.max(noteBox.getMinimumSize().width, minwidth);
        minwidth = Math.max(buttonBox.getMinimumSize().width, minwidth);
        formatBox.setPreferredSize(new Dimension(minwidth, formatBox.getPreferredSize().height));
        frateBox.setPreferredSize(new Dimension(minwidth, frateBox.getPreferredSize().height));
        ttext.setPreferredSize(new Dimension(minwidth, ttext.getPreferredSize().height));
        noteBox.setPreferredSize(new Dimension(minwidth, noteBox.getPreferredSize().height));
        buttonBox.setPreferredSize(new Dimension(minwidth, buttonBox.getPreferredSize().height));
        formatBox.setMinimumSize(formatBox.getPreferredSize());
        frateBox.setMinimumSize(frateBox.getPreferredSize());
        ttext.setMinimumSize(ttext.getPreferredSize());
        noteBox.setMinimumSize(noteBox.getPreferredSize());
        buttonBox.setMinimumSize(buttonBox.getPreferredSize());
        if (spanel0 != null) {
            spanel0.setPreferredSize(new Dimension(minwidth, spanel0.getPreferredSize().height));
            spanel0.setMinimumSize(spanel0.getPreferredSize());
            spanel0.setAlignmentX(0.0f);
        }
        if (spanel1 != null) {
            spanel1.setPreferredSize(new Dimension(minwidth, spanel1.getPreferredSize().height));
            spanel1.setMinimumSize(spanel1.getPreferredSize());
            spanel1.setAlignmentX(0.0f);
        }
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(3, 16, 0, 1);
        fgl.setColumnWeight(2, 9999.0f);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(PanGuiConstants.STD_BORDER);
        contentPanel.add((Component)formatLabel, new FGConstraint(0, 0, 0.0, 0.5));
        contentPanel.add((Component)formatBox, new FGConstraint(1, 0, 0.0, 0.5));
        contentPanel.add(Box.createVerticalStrut(2), new FGConstraint(0, 1, 0.0, 0.5));
        contentPanel.add((Component)frateLabel, new FGConstraint(0, 2, 0.0, 0.5));
        contentPanel.add((Component)frateBox, new FGConstraint(1, 2, 0.0, 0.5));
        contentPanel.add(Box.createVerticalStrut(2), new FGConstraint(0, 3, 0.0, 0.5));
        contentPanel.add((Component)new JLabel("Quality: "), new FGConstraint(0, 4, 0.0, 0.5));
        contentPanel.add((Component)this.qspinner_, new FGConstraint(1, 4, 1, 1, 0.0, 0.5));
        contentPanel.add(Box.createVerticalStrut(2), new FGConstraint(0, 5, 0.0, 0.5));
        contentPanel.add((Component)ttext, new FGConstraint(0, 6, 3, 1, 0.0, 0.5));
        contentPanel.add(Box.createVerticalStrut(2), new FGConstraint(0, 7, 0.0, 0.5));
        if (spanel0 != null) {
            contentPanel.add((Component)spanel0, new FGConstraint(0, 8, 3, 1, 0.0, 0.5));
            contentPanel.add(Box.createVerticalStrut(2), new FGConstraint(0, 9, 0.0, 0.5));
        }
        if (spanel1 != null) {
            contentPanel.add((Component)spanel1, new FGConstraint(0, 10, 3, 1, 0.0, 0.5));
            contentPanel.add(Box.createVerticalStrut(2), new FGConstraint(0, 11, 0.0, 0.5));
        }
        contentPanel.add((Component)noteBox, new FGConstraint(0, 12, 2, 1, 0.0, 0.5));
        contentPanel.add((Component)buttonBox, new FGConstraint(1, 13, 1.0, 0.5));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(makeButton);
        this.formatMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanAnimationFormat af = (PanAnimationFormat)((Object)PanAnimationOptionsDialog.this.formatMenu_.getSelectedItem());
                PanAnimationOptionsDialog.this.frateMenu_.setEnabled(af.isVideo());
                PanAnimationOptionsDialog.this.qspinner_.setEnabled(af.isCompressible());
            }
        });
        makeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanAnimationOptionsDialog.this.success_ = true;
                PREFS.set("save:animation.extension", ((PanAnimationFormat)((Object)PanAnimationOptionsDialog.this.formatMenu_.getSelectedItem())).getExtension());
                PREFS.setInt("save:animation.frate", (Integer)PanAnimationOptionsDialog.this.frateMenu_.getSelectedItem());
                PREFS.setInt("save:animation.quality", PanAnimationOptionsDialog.this.qspinner_.getIntValue());
                PREFS.setBoolean("save:animation.subtitles", PanAnimationOptionsDialog.this.subtitleCB_.isSelected());
                PanAnimationOptionsDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanAnimationOptionsDialog.this.setVisible(false);
            }
        });
        this.pack();
        Rectangle rr = pframe.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public PanAnimationFormat getFormat() {
        return (PanAnimationFormat)((Object)this.formatMenu_.getSelectedItem());
    }

    public NcDimension[] getDimensions() {
        return this.dimensions_;
    }

    public int getQuality() {
        return this.qspinner_.getIntValue();
    }

    public int getFrameRate() {
        return (Integer)this.frateMenu_.getSelectedItem();
    }

    public boolean isDimSubtitled() {
        return this.subtitleCB_.isSelected();
    }

    private JPanel makeSlicePanel(PanPlotFrame pframe, int vnum, boolean showBorder) {
        PanAbstractData2D data = (PanAbstractData2D)pframe.getData();
        NcArray ncarray = data.getArray(vnum);
        if (ncarray == null) {
            return null;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setName("[animation panel " + vnum + "]");
        if (showBorder) {
            StringBuilder title = new StringBuilder("Array ").append("" + (vnum + 1));
            if (ncarray != null) {
                title.append(": ").append(ncarray.getName());
            }
            panel.setBorder(new TitledBorder(title.toString()));
        }
        ButtonGroup bgroup = new ButtonGroup();
        JLabel sliceLabel = null;
        boolean selectedIsSet = false;
        if (ncarray == null) {
            sliceLabel = new JLabel("None selected");
        } else if (ncarray.getDimensions().length == 2) {
            sliceLabel = new JLabel("No additional dimensions");
        }
        if (sliceLabel != null) {
            panel.add(sliceLabel);
        } else {
            for (NcDimension ncdim : ncarray.getDimensions()) {
                if (ncdim == null) continue;
                StringBuilder label = new StringBuilder(ncdim.getLongName()).append(" (").append("" + ncdim.getLength()).append(" frames) ");
                DimensionButton button = new DimensionButton(ncdim, vnum);
                if (!selectedIsSet) {
                    ((AbstractButton)button).setSelected(true);
                    selectedIsSet = true;
                } else {
                    ((AbstractButton)button).setSelected(false);
                }
                panel.add(QuickBox.createLeftBox(button));
                bgroup.add(button);
            }
        }
        DimensionButton button = new DimensionButton(null, vnum);
        panel.add(QuickBox.createLeftBox(button));
        bgroup.add(button);
        return panel;
    }

    class DimensionButton
    extends JRadioButton {
        private NcDimension ncdim_;
        private int vnum_;

        DimensionButton(NcDimension ncdim, int vnum) {
            this.ncdim_ = ncdim;
            this.vnum_ = vnum;
            StringBuilder label = new StringBuilder();
            if (ncdim == null) {
                label.append("None (Leave fixed) ");
            } else {
                label.append(ncdim.getLongName()).append(" (").append("" + ncdim.getLength()).append(" frames) ");
            }
            this.setText(label.toString());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DimensionButton.this.isSelected()) {
                        ((PanAnimationOptionsDialog)PanAnimationOptionsDialog.this).dimensions_[((DimensionButton)DimensionButton.this).vnum_] = DimensionButton.this.ncdim_;
                    }
                }
            });
        }

        NcDimension getDimension() {
            return this.ncdim_;
        }

        @Override
        public void setSelected(boolean selected) {
            if (selected) {
                ((PanAnimationOptionsDialog)PanAnimationOptionsDialog.this).dimensions_[this.vnum_] = this.ncdim_;
            }
            super.setSelected(selected);
        }
    }
}

