/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.panoply.PanSupportEvent;
import gov.nasa.giss.panoply.PanSupportListener;
import gov.nasa.giss.util.FileUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanAbstractSupportList {
    private static Logger logger_ = LoggerFactory.getLogger(PanAbstractSupportList.class);
    private static final Comparator COMPARATOR = new ItemComparator();
    private FilenameFilter ffilter_;
    private ArrayList alist_;
    private EventListenerList listenerList_;

    protected PanAbstractSupportList(FilenameFilter ff) {
        this.ffilter_ = ff;
        this.alist_ = new ArrayList(50);
        this.listenerList_ = new EventListenerList();
    }

    public Object get(int i) {
        return this.alist_.get(i);
    }

    protected void readFavorites(String dirName) {
        String sep = System.getProperty("file.separator");
        File supportDir = null;
        String path = System.getProperty("java.class.path");
        int isep = path.lastIndexOf(sep);
        path = isep > -1 ? path.substring(0, isep) : ".";
        try {
            supportDir = new File(path, dirName);
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (supportDir == null || !supportDir.exists()) {
            path = path + sep + "..";
            try {
                supportDir = new File(path, dirName);
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        if (supportDir == null || !supportDir.exists()) {
            try {
                supportDir = new File(System.getProperty("user.dir"), dirName);
            }
            catch (Exception exc) {
                logger_.error("Could not create File object for {} directory", (Object)dirName);
            }
        }
        if (supportDir == null) {
            return;
        }
        this.scanDirectory(supportDir, this.ffilter_);
        File libraryDir = FileUtilities.getApplicationSupportDir("GISS", ".gissjava", dirName);
        if (libraryDir == null) {
            return;
        }
        if (libraryDir.equals(supportDir)) {
            return;
        }
        this.scanDirectory(libraryDir, this.ffilter_);
    }

    private void scanDirectory(File dir, FilenameFilter filter) {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                for (File file : dir.listFiles(filter)) {
                    if (file.isDirectory() || file.getName().startsWith(".")) continue;
                    try {
                        this.add(file);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            } else {
                logger_.warn("Support dir path blocked for {}", (Object)dir.getName());
            }
        } else {
            try {
                dir.mkdirs();
                dir.mkdir();
            }
            catch (Exception exc) {
                logger_.warn("Could not create support dir for {}", (Object)dir.getName());
                exc.printStackTrace();
            }
        }
    }

    public int size() {
        return this.alist_.size();
    }

    public Object[] toArray() {
        return this.alist_.toArray();
    }

    public Object findByName(String find) {
        if (find == null) {
            throw new IllegalArgumentException("Can't search for null name.");
        }
        for (Object fobj : this.alist_) {
            if (!find.equalsIgnoreCase(fobj.toString())) continue;
            return fobj;
        }
        return null;
    }

    public abstract Object add(File var1) throws FileNotFoundException, InterruptedException, IOException, ParseException;

    public Object add(Object o) {
        if (o == null) {
            return null;
        }
        int isize = this.alist_.size();
        for (int i = 0; i < isize; ++i) {
            int compare = COMPARATOR.compare(o, this.get(i));
            if (compare == 0) {
                return this.get(i);
            }
            if (compare >= 0) continue;
            this.alist_.add(i, o);
            this.fireItemAdded(o);
            return o;
        }
        this.alist_.add(o);
        this.fireItemAdded(o);
        return o;
    }

    public void printList() {
        for (Object o : this.alist_) {
            System.out.println(o.toString());
        }
    }

    public synchronized void addSupportListener(PanSupportListener l) {
        this.listenerList_.add(PanSupportListener.class, l);
    }

    public synchronized void removeSupportListener(PanSupportListener l) {
        this.listenerList_.remove(PanSupportListener.class, l);
    }

    protected void fireItemAdded(Object o) {
        PanSupportEvent e = new PanSupportEvent(this, 0, o);
        for (PanSupportListener listener : (PanSupportListener[])this.listenerList_.getListeners(PanSupportListener.class)) {
            listener.itemAdded(e);
        }
    }

    private static class ItemComparator
    implements Comparator {
        private Collator collator_ = Collator.getInstance();

        private ItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1.toString();
            String s2 = o2.toString();
            CollationKey k1 = this.collator_.getCollationKey(s1);
            CollationKey k2 = this.collator_.getCollationKey(s2);
            return k1.compareTo(k2);
        }
    }
}

