/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.data.DataGrid2D;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.PanCombinationType;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanAbstractData2D
extends PanAbstractData
implements DataGrid2D {
    private static Logger logger_ = LoggerFactory.getLogger(PanAbstractData2D.class);
    protected int gridWidth_;
    protected int gridHeight_;
    protected double[] rowY_;
    protected double[] colX_;
    protected double lBound_;
    protected double rBound_;
    protected double tBound_;
    protected double bBound_;

    protected PanAbstractData2D(NcArray nca, int width, int height) {
        super(nca);
        this.setSize(width, height);
    }

    @Override
    public int getWidth() {
        return this.gridWidth_;
    }

    @Override
    public int getHeight() {
        return this.gridHeight_;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.gridWidth_, this.gridHeight_);
    }

    @Override
    public void setSize(int size) {
        throw new RuntimeException("Use setSize(int,int) for 2D data");
    }

    public void setSize(int w, int h) {
        if (w == this.gridWidth_ && h == this.gridHeight_) {
            return;
        }
        this.gridWidth_ = w;
        this.gridHeight_ = h;
        this.rowY_ = new double[h];
        this.colX_ = new double[w];
        super.setSize(h * w);
    }

    public NcAxis getXAxis() {
        if (this.ncArrays_[1] != null && this.combination_ == PanCombinationType.A2_ONLY) {
            return ((NcArray2D)this.ncArrays_[1]).getXAxis();
        }
        return ((NcArray2D)this.ncArrays_[0]).getXAxis();
    }

    public NcAxis getYAxis() {
        if (this.ncArrays_[1] != null && this.combination_ == PanCombinationType.A2_ONLY) {
            return ((NcArray2D)this.ncArrays_[1]).getYAxis();
        }
        return ((NcArray2D)this.ncArrays_[0]).getYAxis();
    }

    public String getXAxisLabel() {
        StringBuilder xsb = new StringBuilder(this.getXAxisName());
        if (this.getXAxisUnits() != null) {
            xsb.append(" (").append(this.getXAxisUnits()).append(")");
        }
        return xsb.toString();
    }

    public String getYAxisLabel() {
        StringBuilder ysb = new StringBuilder(this.getYAxisName());
        if (this.getYAxisUnits() != null) {
            ysb.append(" (").append(this.getYAxisUnits()).append(")");
        }
        return ysb.toString();
    }

    @Override
    public Point2D.Double getPixelXY(int col, int row) {
        return new Point2D.Double(this.colX_[col], this.rowY_[row]);
    }

    @Override
    public Point2D.Double getXY(double col, double row) {
        double x = this.lBound_ + col / (double)this.gridWidth_ * (this.rBound_ - this.lBound_);
        double y = this.tBound_ + row / (double)this.gridHeight_ * (this.bBound_ - this.tBound_);
        return new Point2D.Double(x, y);
    }

    @Override
    public double getColX(int col) {
        return this.colX_[col];
    }

    @Override
    public double getRowY(int row) {
        return this.rowY_[row];
    }

    @Override
    public double valueAt(int col, int row) {
        return super.valueAt(row * this.gridWidth_ + col);
    }

    public double logOfValueAt(int col, int row) {
        return super.logOfValueAt(row * this.gridWidth_ + col);
    }

    public double angleAt(int col, int row) {
        return super.angleAt(row * this.gridWidth_ + col);
    }

    protected void setValue(double[] array, int col, int row, double value) {
        if (col < 0 || col >= this.gridWidth_) {
            return;
        }
        if (row < 0 || row >= this.gridHeight_) {
            return;
        }
        super.setValue(array, row * this.gridWidth_ + col, value);
    }
}

