/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.data.Data;
import gov.nasa.giss.data.DataEvent;
import gov.nasa.giss.data.DataListener;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.EventQueue;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.ConversionException;
import ucar.units.Converter;
import ucar.units.Unit;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;

public abstract class PanAbstractData
implements Data {
    private static Logger logger_ = LoggerFactory.getLogger(PanAbstractData.class);
    protected static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static final UnitFormat UNIT_FORMAT = UnitFormatManager.instance();
    protected PanCombinationType combination_ = PanCombinationType.ONE_ARRAY_DEFAULT;
    protected NcArray[] ncArrays_ = new NcArray[2];
    protected PrintfFormat scaleFormatter_;
    private boolean interpolated_;
    private boolean needsGridding_ = true;
    private boolean gridding_;
    private boolean needsExtrema_ = true;
    private double dataMin_;
    private double dataMax_;
    private int scalingExponent_;
    private double scalingFactor_ = 1.0;
    private double[] griddedVals_;
    private double[] vectorRads_;
    private Unit[] varUnits_ = new Unit[2];
    private Converter[] varConverters_ = new Converter[2];
    private String targetUnitString_;
    private Unit targetUcarUnit_;
    private Converter targetConverter_;
    private static Unit scalarUnit_;
    private EventListenerList listenerList_ = new EventListenerList();

    protected PanAbstractData(NcArray nca) {
        if (scalarUnit_ == null) {
            try {
                scalarUnit_ = UNIT_FORMAT.parse("1");
            }
            catch (Exception exc) {
                throw new RuntimeException("Could not create scalar unit");
            }
            this.varUnits_[0] = scalarUnit_;
            this.varUnits_[1] = scalarUnit_;
        }
        this.addVariable(0, nca);
        this.setUnits(nca.getUnits());
        this.setInterpolated(PREFS.getBoolean("plot:scale.interpolate"));
        this.setScaleFormat(PREFS.getString("plot:scale.tick.format"));
    }

    public double valueAt(int index) {
        if (this.needsGridding_) {
            this.regrid();
        }
        double result = this.griddedVals_[index];
        if (this.scalingExponent_ != 0) {
            result /= this.scalingFactor_;
        }
        return result;
    }

    public double logOfValueAt(int index) {
        if (this.needsGridding_) {
            this.regrid();
        }
        double result = this.griddedVals_[index];
        if (this.scalingExponent_ != 0) {
            result /= this.scalingFactor_;
        }
        if (result <= 0.0) {
            return Double.NaN;
        }
        return Math.log10(result);
    }

    public double angleAt(int index) {
        if (this.needsGridding_) {
            this.regrid();
        }
        if (this.combination_ == PanCombinationType.VECTOR_A1_A2) {
            return this.vectorRads_[index];
        }
        return 0.0;
    }

    public NcArray[] getArrays() {
        return this.ncArrays_;
    }

    public NcArray getArray(int index) {
        if (index < 0 || index > 1) {
            throw new IllegalArgumentException("ERROR: Bad variable number");
        }
        return this.ncArrays_[index];
    }

    protected void setBoundsChanged() {
        this.needsGridding_ = true;
        this.fireDataChanged("bounds");
    }

    public void setSize(int size) {
        this.griddedVals_ = new double[size];
        this.needsGridding_ = true;
        this.fireDataChanged("size");
    }

    public synchronized void addVariable(int idx, NcArray nca) {
        if (idx < 0 || idx > 1) {
            throw new IllegalArgumentException("Bad index");
        }
        this.ncArrays_[idx] = nca;
        this.varUnits_[idx] = nca.getUcarUnits();
        if (this.varUnits_[idx] == null) {
            this.varUnits_[idx] = scalarUnit_;
        }
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public int getSlice(int varnum, int menuNum) {
        return this.ncArrays_[varnum].getSliceIndex(menuNum);
    }

    public void setSlice(int varnum, int menuNum, int index) {
        this.ncArrays_[varnum].setSliceIndex(menuNum, index);
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public PanCombinationType getCombinationType() {
        return this.combination_;
    }

    public void setCombinationType(PanCombinationType newval) {
        if (this.combination_ == newval) {
            return;
        }
        this.combination_ = newval;
        this.updateUnitConverters();
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public boolean isInterpolated() {
        return this.interpolated_;
    }

    public void setInterpolated(boolean b) {
        if (b == this.interpolated_) {
            return;
        }
        this.interpolated_ = b;
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public int getScalingExponent() {
        return this.scalingExponent_;
    }

    public void setScalingExponent(int newval) {
        if (newval == this.scalingExponent_) {
            return;
        }
        if (newval < -50 || newval > 50) {
            throw new IllegalArgumentException("Scaling exponent out of range.");
        }
        this.scalingExponent_ = newval;
        this.scalingFactor_ = Math.pow(10.0, this.scalingExponent_);
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    @Override
    public String getUnits() {
        return this.targetUnitString_;
    }

    @Override
    public void setUnits(String s) {
        if (s == null || s.equals("<scalar>")) {
            s = "1";
        }
        if (s.startsWith("[")) {
            this.targetUnitString_ = null;
            this.targetUcarUnit_ = null;
        } else {
            try {
                this.targetUnitString_ = s;
                this.targetUcarUnit_ = UNIT_FORMAT.parse(this.targetUnitString_);
            }
            catch (Exception exc) {
                this.targetUnitString_ = null;
                this.targetUcarUnit_ = null;
            }
        }
        this.updateUnitConverters();
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public String[] getUnitsChoices() {
        ArrayList<String> choices = new ArrayList<String>();
        switch (this.combination_) {
            case A1_ONLY: 
            case A2_ONLY: {
                int idx = this.combination_ == PanCombinationType.A1_ONLY ? 0 : 1;
                this.addToUnitsChoices(choices, this.ncArrays_[idx].getUnits());
                if (this.varUnits_[idx] == null) break;
                this.addToUnitsChoices(choices, this.varUnits_[idx].getSymbol());
                if (this.varUnits_[idx].getDerivedUnit() == null) break;
                this.addToUnitsChoices(choices, this.varUnits_[idx].getDerivedUnit().toString());
                this.addToUnitsChoices(choices, this.varUnits_[idx].getDerivedUnit().getSymbol());
                break;
            }
            case A1_PLUS_A2: 
            case A1_MINUS_A2: 
            case A2_MINUS_A1: 
            case AVERAGE_A1_A2: 
            case COMBINE_A1_A2: 
            case VECTOR_A1_A2: {
                if (this.varUnits_[0] == null || this.varUnits_[1] == null) {
                    return new String[]{"[null/unrecognized unit]"};
                }
                if (!this.ncArrays_[0].isCompatible(this.ncArrays_[1])) {
                    return new String[]{"[incompatible units?]"};
                }
                for (int i = 0; i < 2; ++i) {
                    if (this.ncArrays_[i] == null) continue;
                    this.addToUnitsChoices(choices, this.ncArrays_[i].getUnits());
                    if (this.varUnits_[i] == null) continue;
                    this.addToUnitsChoices(choices, this.varUnits_[i].getSymbol());
                    if (this.varUnits_[i].getDerivedUnit() == null) continue;
                    this.addToUnitsChoices(choices, this.varUnits_[i].getDerivedUnit().toString());
                    this.addToUnitsChoices(choices, this.varUnits_[i].getDerivedUnit().getSymbol());
                }
                break;
            }
            case A1_MINUS_A2_OVER_A2: 
            case A2_MINUS_A1_OVER_A1: {
                if (this.varUnits_[0] == null || this.varUnits_[1] == null) {
                    return new String[]{"[null/unrecognized unit]"};
                }
                if (this.ncArrays_[0].isCompatible(this.ncArrays_[1])) break;
                return new String[]{"[incompatible units?]"};
            }
            case A1_TIMES_A2: 
            case A1_OVER_A2: 
            case A2_OVER_A1: {
                if (this.varUnits_[0] == null && this.varUnits_[1] == null) {
                    return new String[]{"[null/unrecognized unit]"};
                }
                try {
                    Unit xx = null;
                    xx = this.combination_ == PanCombinationType.A1_TIMES_A2 ? this.varUnits_[0].multiplyBy(this.varUnits_[1]) : (this.combination_ == PanCombinationType.A1_OVER_A2 ? this.varUnits_[0].divideBy(this.varUnits_[1]) : this.varUnits_[1].divideBy(this.varUnits_[0]));
                    this.addToUnitsChoices(choices, ((Object)xx).toString());
                    this.addToUnitsChoices(choices, xx.getSymbol());
                    this.addToUnitsChoices(choices, xx.getDerivedUnit().toString());
                    this.addToUnitsChoices(choices, xx.getDerivedUnit().getSymbol());
                }
                catch (Exception exception) {}
                break;
            }
        }
        if (choices.size() == 0) {
            return new String[]{"<scalar>"};
        }
        String[] result = choices.toArray(new String[0]);
        return result;
    }

    protected void addToUnitsChoices(ArrayList<String> choices, String s) {
        if (s == null || s.length() < 1) {
            return;
        }
        for (String choice : choices) {
            if (!s.equals(choice)) continue;
            return;
        }
        choices.add(s);
    }

    private void updateUnitConverters() {
        this.varConverters_[0] = null;
        this.varConverters_[1] = null;
        this.targetConverter_ = null;
        if (this.targetUcarUnit_ == null) {
            return;
        }
        switch (this.combination_) {
            case A1_ONLY: 
            case A2_ONLY: {
                int idx;
                int n = idx = this.combination_ == PanCombinationType.A1_ONLY ? 0 : 1;
                if (this.varUnits_[idx] != null) {
                    try {
                        this.varConverters_[idx] = this.varUnits_[idx].getConverterTo(this.targetUcarUnit_);
                    }
                    catch (ConversionException exc) {
                        logger_.warn("Units conversion exception.");
                    }
                }
                if (this.varConverters_[idx] != null) break;
                this.targetUnitString_ = null;
                this.targetUcarUnit_ = null;
                break;
            }
            case A1_PLUS_A2: 
            case A1_MINUS_A2: 
            case A2_MINUS_A1: 
            case AVERAGE_A1_A2: 
            case COMBINE_A1_A2: 
            case VECTOR_A1_A2: {
                for (int i = 0; i < 2; ++i) {
                    if (this.varUnits_[i] == null) continue;
                    try {
                        this.varConverters_[i] = this.varUnits_[i].getConverterTo(this.targetUcarUnit_);
                        continue;
                    }
                    catch (ConversionException exc) {
                        logger_.warn("Units conversion exception.");
                        this.varConverters_[0] = null;
                        this.varConverters_[1] = null;
                        break;
                    }
                }
                if (this.varConverters_[0] == null) {
                    this.targetUnitString_ = null;
                    this.targetUcarUnit_ = null;
                }
                this.targetConverter_ = null;
                break;
            }
            case A1_MINUS_A2_OVER_A2: 
            case A2_MINUS_A1_OVER_A1: {
                try {
                    Converter c = this.varUnits_[1].getConverterTo(this.varUnits_[0]);
                    this.varConverters_[0] = null;
                    this.varConverters_[1] = c;
                }
                catch (ConversionException exc) {
                    logger_.warn("Units conversion exception.");
                    this.varConverters_[0] = null;
                    this.varConverters_[1] = null;
                    break;
                }
                this.makeTargetConverter(scalarUnit_);
                break;
            }
            case A1_TIMES_A2: {
                Unit finalSrcUnit = null;
                if (this.varUnits_[0] == null && this.varUnits_[1] == null) {
                    finalSrcUnit = null;
                } else if (this.varUnits_[0] == null) {
                    finalSrcUnit = this.varUnits_[1];
                } else if (this.varUnits_[1] == null) {
                    finalSrcUnit = this.varUnits_[0];
                } else {
                    try {
                        finalSrcUnit = this.varUnits_[0].multiplyBy(this.varUnits_[1]);
                    }
                    catch (Exception exc) {
                        finalSrcUnit = null;
                    }
                }
                this.makeTargetConverter(finalSrcUnit);
                break;
            }
            case A1_OVER_A2: {
                Unit finalSrcUnit = null;
                if (this.varUnits_[0] == null && this.varUnits_[1] == null) {
                    finalSrcUnit = null;
                } else if (this.varUnits_[0] == null) {
                    try {
                        finalSrcUnit = this.varUnits_[1].raiseTo(-1);
                    }
                    catch (Exception exc) {
                        logger_.warn("Units conversion exception.");
                        finalSrcUnit = null;
                    }
                } else if (this.varUnits_[1] == null) {
                    finalSrcUnit = this.varUnits_[0];
                } else {
                    try {
                        finalSrcUnit = this.varUnits_[0].divideBy(this.varUnits_[1]);
                    }
                    catch (Exception exc) {
                        logger_.warn("Units conversion exception.");
                        finalSrcUnit = null;
                    }
                }
                this.makeTargetConverter(finalSrcUnit);
                break;
            }
            case A2_OVER_A1: {
                Unit finalSrcUnit = null;
                if (this.varUnits_[0] == null && this.varUnits_[1] == null) {
                    finalSrcUnit = null;
                } else if (this.varUnits_[0] == null) {
                    finalSrcUnit = this.varUnits_[1];
                } else if (this.varUnits_[1] == null) {
                    try {
                        finalSrcUnit = this.varUnits_[0].raiseTo(-1);
                    }
                    catch (Exception exc) {
                        finalSrcUnit = null;
                    }
                } else {
                    try {
                        finalSrcUnit = this.varUnits_[1].divideBy(this.varUnits_[0]);
                    }
                    catch (Exception exc) {
                        logger_.warn("Units conversion exception.");
                        finalSrcUnit = null;
                    }
                }
                this.makeTargetConverter(finalSrcUnit);
                break;
            }
        }
    }

    private void makeTargetConverter(Unit unit) {
        this.targetConverter_ = null;
        if (unit != null) {
            try {
                this.targetConverter_ = unit.getConverterTo(this.targetUcarUnit_);
            }
            catch (ConversionException ignore) {
                logger_.warn("Could not create converter from {} to {}", (Object)unit, (Object)this.targetUcarUnit_);
            }
        }
        if (this.targetConverter_ == null) {
            this.targetUnitString_ = null;
            this.targetUcarUnit_ = null;
        }
    }

    public void setScaleFormat(String fmt) {
        if (fmt == null) {
            throw new IllegalArgumentException("Null format string");
        }
        this.scaleFormatter_ = new PrintfFormat(fmt);
    }

    private synchronized void regrid() {
        if (!this.needsGridding_) {
            return;
        }
        if (this.gridding_) {
            return;
        }
        this.gridding_ = true;
        this.vectorRads_ = null;
        this.updateGrid();
        if (this.combination_ == PanCombinationType.A1_ONLY) {
            this.regrid(0, this.griddedVals_);
            this.convertArray(this.griddedVals_, this.varConverters_[0]);
        } else if (this.combination_ == PanCombinationType.A2_ONLY) {
            this.regrid(1, this.griddedVals_);
            this.convertArray(this.griddedVals_, this.varConverters_[1]);
        } else if (this.combination_ == PanCombinationType.A1_MINUS_A2) {
            double[] array2 = new double[this.griddedVals_.length];
            this.regrid(0, this.griddedVals_);
            this.regrid(1, array2);
            this.convertArray(this.griddedVals_, this.varConverters_[0]);
            this.convertArray(array2, this.varConverters_[1]);
            this.mergeArrays(MergeOperation.SUBTRACT, this.griddedVals_, array2, this.griddedVals_, null);
        } else if (this.combination_ == PanCombinationType.A2_MINUS_A1) {
            double[] array2 = new double[this.griddedVals_.length];
            this.regrid(1, this.griddedVals_);
            this.regrid(0, array2);
            this.convertArray(this.griddedVals_, this.varConverters_[1]);
            this.convertArray(array2, this.varConverters_[0]);
            this.mergeArrays(MergeOperation.SUBTRACT, this.griddedVals_, array2, this.griddedVals_, null);
        } else if (this.combination_ == PanCombinationType.A1_PLUS_A2) {
            double[] array2 = new double[this.griddedVals_.length];
            this.regrid(0, this.griddedVals_);
            this.regrid(1, array2);
            this.convertArray(this.griddedVals_, this.varConverters_[0]);
            this.convertArray(array2, this.varConverters_[1]);
            this.mergeArrays(MergeOperation.ADD, this.griddedVals_, array2, this.griddedVals_, null);
        } else if (this.combination_ == PanCombinationType.A1_TIMES_A2) {
            double[] array2 = new double[this.griddedVals_.length];
            this.regrid(0, this.griddedVals_);
            this.regrid(1, array2);
            this.mergeArrays(MergeOperation.MULTIPLY, this.griddedVals_, array2, this.griddedVals_, null);
            this.convertArray(this.griddedVals_, this.targetConverter_);
        } else if (this.combination_ == PanCombinationType.A1_OVER_A2) {
            double[] array2 = new double[this.griddedVals_.length];
            this.regrid(0, this.griddedVals_);
            this.regrid(1, array2);
            this.mergeArrays(MergeOperation.DIVIDE, this.griddedVals_, array2, this.griddedVals_, null);
            this.convertArray(this.griddedVals_, this.targetConverter_);
        } else if (this.combination_ == PanCombinationType.A2_OVER_A1) {
            double[] array2 = new double[this.griddedVals_.length];
            this.regrid(1, this.griddedVals_);
            this.regrid(0, array2);
            this.mergeArrays(MergeOperation.DIVIDE, this.griddedVals_, array2, this.griddedVals_, null);
            this.convertArray(this.griddedVals_, this.targetConverter_);
        } else if (this.combination_ == PanCombinationType.A1_MINUS_A2_OVER_A2) {
            double[] array2 = new double[this.griddedVals_.length];
            this.regrid(0, this.griddedVals_);
            this.regrid(1, array2);
            this.convertArray(this.griddedVals_, this.varConverters_[0]);
            this.convertArray(array2, this.varConverters_[1]);
            this.mergeArrays(MergeOperation.SUBTRACT, this.griddedVals_, array2, this.griddedVals_, null);
            this.mergeArrays(MergeOperation.DIVIDE, this.griddedVals_, array2, this.griddedVals_, null);
            this.convertArray(this.griddedVals_, this.targetConverter_);
        } else if (this.combination_ == PanCombinationType.A2_MINUS_A1_OVER_A1) {
            double[] array2 = new double[this.griddedVals_.length];
            this.regrid(1, this.griddedVals_);
            this.regrid(0, array2);
            this.convertArray(this.griddedVals_, this.varConverters_[1]);
            this.convertArray(array2, this.varConverters_[0]);
            this.mergeArrays(MergeOperation.SUBTRACT, this.griddedVals_, array2, this.griddedVals_, null);
            this.mergeArrays(MergeOperation.DIVIDE, this.griddedVals_, array2, this.griddedVals_, null);
            this.convertArray(this.griddedVals_, this.targetConverter_);
        } else if (this.combination_ == PanCombinationType.AVERAGE_A1_A2) {
            double[] array2 = new double[this.griddedVals_.length];
            this.regrid(0, this.griddedVals_);
            this.regrid(1, array2);
            this.convertArray(this.griddedVals_, this.varConverters_[0]);
            this.convertArray(array2, this.varConverters_[1]);
            this.mergeArrays(MergeOperation.ADD, this.griddedVals_, array2, this.griddedVals_, null);
            this.multiplyArray(this.griddedVals_, 0.5);
        } else if (this.combination_ == PanCombinationType.COMBINE_A1_A2) {
            double[] array2 = new double[this.griddedVals_.length];
            this.regrid(0, this.griddedVals_);
            this.regrid(1, array2);
            this.convertArray(this.griddedVals_, this.varConverters_[0]);
            this.convertArray(array2, this.varConverters_[1]);
            this.mergeArrays(MergeOperation.COMBINE, this.griddedVals_, array2, this.griddedVals_, null);
        } else if (this.combination_ == PanCombinationType.VECTOR_A1_A2) {
            double[] array2 = new double[this.griddedVals_.length];
            this.regrid(0, this.griddedVals_);
            this.regrid(1, array2);
            this.convertArray(this.griddedVals_, this.varConverters_[0]);
            this.convertArray(array2, this.varConverters_[1]);
            this.vectorRads_ = array2;
            this.mergeArrays(MergeOperation.MAGNITUDE, this.griddedVals_, array2, this.griddedVals_, this.vectorRads_);
        }
        this.dataMin_ = Double.NaN;
        this.dataMax_ = Double.NaN;
        this.needsGridding_ = false;
        this.needsExtrema_ = true;
        this.gridding_ = false;
    }

    protected abstract void updateGrid();

    protected void regrid(int idx, double[] target) {
        if (this.ncArrays_[idx] == null) {
            throw new IllegalArgumentException("Bad Variable index.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target array is null.");
        }
        this.fillArrayNaN(target);
        if (this.interpolated_) {
            this.regridInterpolate(this.ncArrays_[idx], target);
        } else {
            this.regridNoInterpolate(this.ncArrays_[idx], target);
        }
    }

    protected abstract void regridNoInterpolate(NcArray var1, double[] var2);

    protected abstract void regridInterpolate(NcArray var1, double[] var2);

    private void fillArrayNaN(double[] array) {
        int isize = array.length;
        for (int i = 0; i < isize; ++i) {
            array[i] = Double.NaN;
        }
    }

    private void mergeArrays(MergeOperation how, double[] array1, double[] array2, double[] target, double[] angles) {
        int isize = array1.length;
        if (array2.length != isize) {
            throw new IllegalArgumentException("Arrays are different lengths");
        }
        if (target.length != isize) {
            throw new IllegalArgumentException("Arrays are different lengths");
        }
        switch (how) {
            case ADD: {
                for (int i = 0; i < isize; ++i) {
                    target[i] = Double.isNaN(array1[i]) || Double.isNaN(array2[i]) ? Double.NaN : array1[i] + array2[i];
                }
                break;
            }
            case COMBINE: {
                for (int i = 0; i < isize; ++i) {
                    target[i] = !Double.isNaN(array1[i]) && !Double.isNaN(array2[i]) ? 0.5 * (array1[i] + array2[i]) : (!Double.isNaN(array1[i]) ? array1[i] : (!Double.isNaN(array2[i]) ? array2[i] : Double.NaN));
                }
                break;
            }
            case SUBTRACT: {
                for (int i = 0; i < isize; ++i) {
                    target[i] = Double.isNaN(array1[i]) || Double.isNaN(array2[i]) ? Double.NaN : array1[i] - array2[i];
                }
                break;
            }
            case MULTIPLY: {
                for (int i = 0; i < isize; ++i) {
                    target[i] = Double.isNaN(array1[i]) || Double.isNaN(array2[i]) ? Double.NaN : array1[i] * array2[i];
                }
                break;
            }
            case DIVIDE: {
                for (int i = 0; i < isize; ++i) {
                    target[i] = array2[i] == 0.0 || Double.isNaN(array1[i]) || Double.isNaN(array2[i]) ? Double.NaN : array1[i] / array2[i];
                }
                break;
            }
            case MAGNITUDE: {
                if (angles.length != isize) {
                    throw new IllegalArgumentException("Angle array is wrong length");
                }
                for (int i = 0; i < isize; ++i) {
                    double v1 = array1[i];
                    double v2 = array2[i];
                    if (Double.isNaN(v1) || Double.isNaN(v2)) {
                        target[i] = Double.NaN;
                        angles[i] = 0.0;
                        continue;
                    }
                    target[i] = Math.hypot(v1, v2);
                    angles[i] = Math.atan2(v1, v2);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown merge method.");
            }
        }
    }

    private void convertArray(double[] array, Converter converter) {
        if (converter == null) {
            return;
        }
        int isize = array.length;
        for (int i = 0; i < isize; ++i) {
            if (Double.isNaN(array[i])) continue;
            array[i] = converter.convert(array[i]);
        }
    }

    private void multiplyArray(double[] array, double constant) {
        int isize = array.length;
        for (int i = 0; i < isize; ++i) {
            if (Double.isNaN(array[i]) || Double.isInfinite(array[i])) continue;
            int n = i;
            array[n] = array[n] * constant;
        }
    }

    protected void setValue(double[] array, int index, double value) {
        if (index < 0 || index >= array.length) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        array[index] = value;
    }

    private synchronized void findExtrema() {
        if (!this.needsExtrema_) {
            return;
        }
        this.dataMin_ = Double.NaN;
        this.dataMax_ = Double.NaN;
        if (this.combination_ == PanCombinationType.A1_ONLY) {
            this.dataMin_ = this.ncArrays_[0].minimumValue();
            this.dataMax_ = this.ncArrays_[0].maximumValue();
            if (this.varConverters_[0] != null) {
                this.dataMin_ = this.varConverters_[0].convert(this.dataMin_);
                this.dataMax_ = this.varConverters_[0].convert(this.dataMax_);
            }
        } else if (this.combination_ == PanCombinationType.A2_ONLY) {
            this.dataMin_ = this.ncArrays_[1].minimumValue();
            this.dataMax_ = this.ncArrays_[1].maximumValue();
            if (this.varConverters_[1] != null) {
                this.dataMin_ = this.varConverters_[1].convert(this.dataMin_);
                this.dataMax_ = this.varConverters_[1].convert(this.dataMax_);
            }
        } else {
            if (this.needsGridding_) {
                this.regrid();
            }
            boolean onefound = false;
            for (double dval : this.griddedVals_) {
                if (Double.isNaN(dval) || Double.isInfinite(dval)) continue;
                if (onefound) {
                    if (dval < this.dataMin_) {
                        this.dataMin_ = dval;
                        continue;
                    }
                    if (!(dval > this.dataMax_)) continue;
                    this.dataMax_ = dval;
                    continue;
                }
                this.dataMin_ = dval;
                this.dataMax_ = dval;
                onefound = true;
            }
        }
        if (this.scalingExponent_ != 0) {
            this.dataMin_ /= this.scalingFactor_;
            this.dataMax_ /= this.scalingFactor_;
        }
        if (this.dataMax_ <= this.dataMin_) {
            this.dataMax_ = this.dataMin_ + 1.0E-25;
        }
        this.needsExtrema_ = false;
    }

    @Override
    public double getMinimumValue() {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.dataMin_;
    }

    @Override
    public double getMaximumValue() {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.dataMax_;
    }

    public String getDescription() {
        StringBuilder caption = new StringBuilder("");
        if (this.combination_ == PanCombinationType.A1_ONLY || this.combination_ == PanCombinationType.A2_ONLY) {
            int idx;
            int n = idx = this.combination_ == PanCombinationType.A1_ONLY ? 0 : 1;
            if (this.ncArrays_[idx].getLongName() != null) {
                caption.append(this.ncArrays_[idx].getLongName());
            } else {
                caption.append(this.ncArrays_[idx].getName());
            }
            caption.append(" (");
            if (this.scalingExponent_ != 0) {
                caption.append("10^").append(this.scalingExponent_).append(" ");
            }
            if (this.varConverters_[idx] != null) {
                caption.append(this.targetUnitString_);
            } else if (this.ncArrays_[idx].getUnits() != null) {
                caption.append(this.ncArrays_[idx].getUnits());
            }
            caption.append(")");
            return caption.toString();
        }
        String first = this.ncArrays_[0].getLongName();
        String second = this.ncArrays_[1].getLongName();
        if (first == null) {
            first = "null";
        }
        if (second == null) {
            second = "null";
        }
        if (first.equalsIgnoreCase(second)) {
            second = first;
        }
        switch (this.combination_) {
            case A1_MINUS_A2: {
                caption.append(first).append(" - ").append(second);
                break;
            }
            case A2_MINUS_A1: {
                caption.append(second).append(" - ").append(first);
                break;
            }
            case A1_PLUS_A2: {
                caption.append(first).append(" + ").append(second);
                break;
            }
            case A1_TIMES_A2: {
                caption.append(first).append(" \u00d7 ").append(second);
                break;
            }
            case A1_OVER_A2: {
                caption.append(first).append(" / ").append(second);
                break;
            }
            case A2_OVER_A1: {
                caption.append(second).append(" / ").append(first);
                break;
            }
            case A1_MINUS_A2_OVER_A2: {
                caption.append("(").append(first).append(" - ").append(second).append(") / ").append(second);
                break;
            }
            case A2_MINUS_A1_OVER_A1: {
                caption.append("(").append(second).append(" - ").append(first).append(") / ").append(first);
                break;
            }
            case AVERAGE_A1_A2: {
                caption.append("0.5 \u00d7 ");
                caption.append("(").append(first).append(" + ").append(second).append(")");
                break;
            }
            case COMBINE_A1_A2: {
                caption.append("Combine ");
                caption.append("(").append(first).append(", ").append(second).append(")");
                break;
            }
            case VECTOR_A1_A2: {
                caption.append("Sqrt");
                caption.append("[").append("(").append(first).append(")\u00b2 + ").append("(").append(second).append(")\u00b2").append("]");
            }
        }
        if (this.targetUnitString_ != null && !this.targetUnitString_.equals("1")) {
            caption.append("  (");
            if (this.scalingExponent_ != 0) {
                caption.append("10^").append(this.scalingExponent_).append(" ");
            }
            if (this.targetUcarUnit_ != null) {
                caption.append(this.targetUnitString_);
            } else {
                caption.append("Bad Units?");
            }
            caption.append(")");
        }
        return caption.toString();
    }

    public synchronized void addDataListener(DataListener l) {
        this.listenerList_.add(DataListener.class, l);
    }

    public synchronized void removeDataListener(DataListener l) {
        if (this.listenerList_ == null) {
            return;
        }
        this.listenerList_.remove(DataListener.class, l);
    }

    public synchronized void removeDataListeners() {
        if (this.listenerList_ == null) {
            return;
        }
        for (DataListener listener : (DataListener[])this.listenerList_.getListeners(DataListener.class)) {
            this.removeDataListener(listener);
        }
    }

    public synchronized void fireDataChanged(final String msg) {
        if (this.listenerList_ == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataEvent e = new DataEvent(this, msg);
                for (DataListener listener : (DataListener[])PanAbstractData.this.listenerList_.getListeners(DataListener.class)) {
                    listener.dataChanged(e);
                }
            }
        });
    }

    private static enum MergeOperation {
        SET,
        ADD,
        COMBINE,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MAGNITUDE;

    }
}

