/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.PanPanel;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.plot.PanAbstractPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import java.awt.Component;
import java.awt.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanAbstractControlsPanel
extends PanPanel {
    private static Logger logger_ = LoggerFactory.getLogger(PanAbstractControlsPanel.class);
    protected static final PanPreferences PREFS = PanPreferences.getPrefs();
    protected PanPlotMeta pmeta_;

    public PanAbstractControlsPanel(String name, PanPlotMeta pmeta) {
        this.setName(name);
        this.setOpaque(false);
        this.pmeta_ = pmeta;
    }

    protected PanPlotFrame getParentFrame() {
        Container tla = this.getTopLevelAncestor();
        if (tla == null || !(tla instanceof PanPlotFrame)) {
            return null;
        }
        return (PanPlotFrame)tla;
    }

    protected PanAbstractData getData() {
        return this.pmeta_.getData();
    }

    protected PanAbstractPlot getPlot() {
        return this.pmeta_.getPlot();
    }

    public void refresh() {
    }

    public synchronized void flush() {
        for (Component child : this.getComponents()) {
            if (child == null || !(child instanceof PanAbstractControlsPanel)) continue;
            ((PanAbstractControlsPanel)child).flush();
        }
        this.removeAll();
        if (this.pmeta_ != null) {
            this.pmeta_.flush();
            this.pmeta_ = null;
        }
    }
}

