/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.panoply.PanBookmark;
import gov.nasa.giss.panoply.PanBookmarksFolder;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanMenu;
import gov.nasa.giss.panoply.PanPreferences;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class PanAbstractBookmarksMenu
extends PanMenu {
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static String homeDir_ = System.getProperty("user.home");
    private JMenuItem clearRecentItem_;

    public PanAbstractBookmarksMenu(PanFrame parent, String mname) {
        super(parent, mname);
    }

    public PanAbstractBookmarksMenu(PanFrame parent) {
        super(parent);
    }

    protected void addBookmarkNodes(PanMenu bmenu, Object[] bobs) {
        for (Object bob : bobs) {
            this.addBookmarkNode(bmenu, bob);
        }
    }

    protected void addBookmarkNode(PanMenu bmenu, Object bob) {
        if (bob instanceof PanBookmarksFolder) {
            this.addSubmenu(bmenu, (PanBookmarksFolder)bob);
            return;
        }
        final PanBookmark b = (PanBookmark)bob;
        String prefix = "";
        switch (b.getAccessType()) {
            case LOCAL_DATASET: {
                prefix = "Local Dataset: ";
                break;
            }
            case REMOTE_DATASET: {
                prefix = "Remote Dataset: ";
                break;
            }
            case CATALOG: {
                prefix = "Catalog: ";
            }
        }
        String name = b.getSetName();
        String s = null;
        if (name != null) {
            s = prefix + name;
        } else {
            String surl = b.getAddress();
            switch (b.getAccessType()) {
                case LOCAL_DATASET: {
                    break;
                }
                case REMOTE_DATASET: {
                    if (surl.length() <= 60) break;
                    surl = PanAbstractBookmarksMenu.shortenURL(surl, 0);
                    break;
                }
                case CATALOG: {
                    surl = surl.replaceAll("catalog\\.xml$", "");
                }
            }
            s = prefix + surl;
        }
        AbstractAction a = new AbstractAction(s){

            @Override
            public void actionPerformed(ActionEvent e) {
                b.open(PanAbstractBookmarksMenu.this.pframe_);
            }
        };
        bmenu.add(new JMenuItem(a));
    }

    private static String shortenURL(String s, int depth) {
        int ll;
        if (depth > 4) {
            return s;
        }
        int ii = s.lastIndexOf("/");
        String fname = s.substring(ii);
        int jj = s.lastIndexOf("/\u2026/");
        String s1 = jj > -1 ? s.substring(0, jj) : s.substring(0, ii);
        int kk = s1.lastIndexOf("/");
        if (kk == (ll = s1.lastIndexOf("//")) + 1) {
            return s;
        }
        s = s1.substring(0, kk + 1) + "\u2026" + fname;
        if (s.length() > 60) {
            s = PanAbstractBookmarksMenu.shortenURL(s, depth + 1);
        }
        return s;
    }

    protected void addSubmenu(PanMenu bmenu, PanBookmarksFolder folder) {
        PanMenu submenu = new PanMenu(this.pframe_);
        submenu.setText(folder.getName());
        Object[] bobs = folder.getChildren();
        this.addBookmarkNodes(submenu, bobs);
        bmenu.add(submenu);
    }
}

