/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import com.centerkey.utils.BareBonesBrowserLaunch;
import com.explodingpixels.macwidgets.plaf.EmphasizedLabelUI;
import gov.nasa.giss.gui.BrushMetalBox;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.label.MultiLineLabel;
import gov.nasa.giss.gui.plaf.EmphasizedMultiLineLabelUI;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanHelpFrame;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;

public class PanAboutFrame
extends PanFrame {
    private static PanAboutFrame aboutFrame_;
    private boolean launched_;

    public static PanAboutFrame findFrame(boolean create) {
        if (aboutFrame_ == null && create) {
            aboutFrame_ = new PanAboutFrame();
        }
        return aboutFrame_;
    }

    private PanAboutFrame() {
        Font plain10;
        Font plain9;
        Font bold18;
        Font bold16;
        Font plain12;
        this.setUndecorated(true);
        this.setResizable(false);
        this.setTitle(PanProperties.ABOUT.getString("about-title"));
        this.setName(this.getTitle());
        GuiUtilities.applyBrushMetalLook(this);
        Font lFont = UIManager.getDefaults().getFont("Label.font");
        if (lFont != null) {
            int adjust = 12 - lFont.getSize();
            plain12 = lFont.deriveFont((float)(lFont.getSize() + adjust));
            Font bold14 = plain12.deriveFont(1, (float)((double)plain12.getSize() + 2.0));
            bold16 = plain12.deriveFont(1, (float)((double)plain12.getSize() + 4.0));
            bold18 = plain12.deriveFont(1, (float)((double)plain12.getSize() + 6.0));
            Font plain8 = plain12.deriveFont((float)((double)plain12.getSize() - 4.0));
            plain9 = plain12.deriveFont((float)((double)plain12.getSize() - 3.0));
            plain10 = plain12.deriveFont((float)((double)plain12.getSize() - 2.0));
        } else {
            Font bold14 = new Font("SansSerif", 1, 14);
            bold16 = new Font("SansSerif", 1, 16);
            bold18 = new Font("SansSerif", 1, 18);
            Font plain8 = new Font("SansSerif", 0, 8);
            plain9 = new Font("SansSerif", 0, 9);
            plain10 = new Font("SansSerif", 0, 10);
            plain12 = new Font("SansSerif", 0, 12);
        }
        JLabel iconLabel = null;
        try {
            iconLabel = new JLabel(new ImageIcon(Panoply.class.getResource("resources/panoply.png")));
            iconLabel.setAlignmentX(0.5f);
        }
        catch (Exception exc) {
            // empty catch block
        }
        JLabel titleLabel = new JLabel(PanProperties.VERSION.getString("application-name"), 0);
        JLabel versionLabel = new JLabel(PanProperties.VERSION.getString("version-word") + " " + PanProperties.VERSION.getString("version"), 0);
        JLabel buildLabel = new JLabel("(" + PanProperties.VERSION.getString("build-word") + " " + PanProperties.VERSION.getString("build") + ")", 0);
        MultiLineLabel authorLabel = new MultiLineLabel(PanProperties.ABOUT.getString("author"), 0);
        MultiLineLabel creditsLabel = new MultiLineLabel(PanProperties.ABOUT.getString("credits"), 0);
        JLabel gissLabel = new JLabel("NASA/GISS", 0);
        JLabel javaLabel = new JLabel(System.getProperty("os.name") + " " + System.getProperty("os.version") + " - Java " + System.getProperty("java.version"), 0);
        if (iconLabel != null) {
            iconLabel.setOpaque(false);
        }
        if (PlatformUtilities.isMacLeopardPlus()) {
            titleLabel.setUI(new EmphasizedLabelUI());
            versionLabel.setUI(new EmphasizedLabelUI());
            buildLabel.setUI(new EmphasizedLabelUI());
            authorLabel.setUI(new EmphasizedMultiLineLabelUI());
            creditsLabel.setUI(new EmphasizedMultiLineLabelUI());
            gissLabel.setUI(new EmphasizedLabelUI());
            javaLabel.setUI(new EmphasizedLabelUI());
        } else {
            titleLabel.setOpaque(false);
            versionLabel.setOpaque(false);
            authorLabel.setOpaque(false);
            creditsLabel.setOpaque(false);
            gissLabel.setOpaque(false);
            javaLabel.setOpaque(false);
        }
        titleLabel.setFont(bold18);
        versionLabel.setFont(plain12);
        buildLabel.setFont(plain10);
        authorLabel.setFont(plain10);
        creditsLabel.setFont(plain10);
        gissLabel.setFont(bold16);
        javaLabel.setFont(plain9);
        titleLabel.setAlignmentX(0.5f);
        versionLabel.setAlignmentX(0.5f);
        buildLabel.setAlignmentX(0.5f);
        authorLabel.setAlignmentX(0.5f);
        creditsLabel.setAlignmentX(0.5f);
        gissLabel.setAlignmentX(0.5f);
        javaLabel.setAlignmentX(0.5f);
        BrushMetalBox contentBox = new BrushMetalBox();
        if (PlatformUtilities.isMacLeopardPlus()) {
            contentBox.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        } else {
            contentBox.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(19, 19, 19, 19)));
        }
        if (iconLabel != null) {
            contentBox.add(iconLabel);
            contentBox.add(Box.createVerticalStrut(8));
        }
        contentBox.add(titleLabel);
        contentBox.add(Box.createVerticalStrut(6));
        contentBox.add(versionLabel);
        contentBox.add(buildLabel);
        contentBox.add(Box.createVerticalStrut(6));
        contentBox.add(authorLabel);
        contentBox.add(Box.createVerticalStrut(6));
        contentBox.add(creditsLabel);
        contentBox.add(Box.createVerticalStrut(6));
        contentBox.add(gissLabel);
        contentBox.add(Box.createVerticalStrut(6));
        contentBox.add(javaLabel);
        this.getContentPane().add(contentBox);
        this.pack();
        Rectangle rr = GuiUtilities.getMainScreenBounds();
        if (rr == null) {
            this.setLocation(25, 25);
        } else {
            Dimension psize = this.getContentPane().getPreferredSize();
            int x = (rr.width - psize.width) / 2;
            int y = (rr.height - psize.height) * 4 / 10;
            this.setLocation(rr.x + x, rr.y + y);
        }
        gissLabel.addMouseListener(new LabelMouseListener(PanProperties.ABOUT.getString("giss-url")));
        creditsLabel.addMouseListener(new LabelMouseListener(PanProperties.ABOUT.getString("credits-url")));
    }

    public void setLaunched(boolean launched) {
        this.launched_ = launched;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.launched_ && this.getPanMenuBar() == null) {
            this.setPanMenuBar(new PanMenuBar(this));
            this.pack();
        }
        super.setVisible(visible);
    }

    class LabelMouseListener
    implements MouseListener {
        private String target_;

        LabelMouseListener(String target) {
            this.target_ = target;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            try {
                if (this.target_.startsWith("http://")) {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().browse(new URI(this.target_));
                    } else {
                        BareBonesBrowserLaunch.openURL(this.target_);
                    }
                } else {
                    PanHelpFrame.findFrame(this.target_).reveal();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

