/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.time;

import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVarUtilities;
import gov.nasa.giss.netcdf.time.NcCalendarType;
import gov.nasa.giss.netcdf.time.NcClimateModelCalendar;
import gov.nasa.giss.netcdf.time.NcDataTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.nc2.Variable;

public class NcRelativeTime
implements NcDataTime {
    private static Logger logger_ = LoggerFactory.getLogger(NcRelativeTime.class);
    private static final String MSECOND_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String SECOND_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    private static final String HOUR_PATTERN = "yyyy-MM-dd HH:mm";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String MONTH_PATTERN = "yyyy-MM";
    private static final String YEAR_PATTERN = "yyyy";
    public static final String[] PATTERNS = new String[]{"yyyy", "yyyy-MM", "yyyy-MM-dd", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm ZZZZ", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss ZZZZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.SSS ZZZZ"};
    public static final String GREGORIAN = "gregorian";
    public static final String GREGORIAN_A = "standard";
    public static final String GREGORIAN_B = "mixed";
    public static final String PRO_GREG = "proleptic_gregorian";
    public static final String JULIAN = "julian";
    public static final String NO_LEAP = "noleap";
    public static final String NO_LEAP_A = "no_leap";
    public static final String NO_LEAP_B = "common_year";
    public static final String NO_LEAP_C = "365_day";
    public static final String ALL_LEAP = "all_leap";
    public static final String ALL_LEAP_A = "366_day";
    public static final String TWELVE_30 = "360_day";
    public static final String TWELVE_30_A = "360";
    private static final String[] ISO_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ssZZZZ", "yyyy-MM-dd'T'HH:mm:ss Z", "yyyy-MM-dd'T'HH:mm:ss ZZZZ", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ss zzz", "yyyy-MM-dd'T'HH:mm:ss zzzz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd HH:mm:ss'Z'", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ssZZZZ", "yyyy-MM-dd HH:mm:ss Z", "yyyy-MM-dd HH:mm:ss ZZZZ", "yyyy-MM-dd HH:mm:ssz", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ss zzz", "yyyy-MM-dd HH:mm:ss zzzz", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy"};
    private int incrementField_;
    private boolean decimalIncrements_;
    private String matchedPattern_;
    private SimpleDateFormat dtFormat_;
    private Date origin_;
    private Calendar calendar_;
    private boolean zeroBasedYear_;

    public NcRelativeTime(String units) throws ParseException {
        this(units, GREGORIAN);
    }

    public NcRelativeTime(String units, String calendarName) throws ParseException {
        this.init(units, calendarName);
    }

    public NcRelativeTime(NcDataset dataset, Variable dimVar) throws NcException, ParseException {
        String units = NcVarUtilities.getUnits(dimVar);
        if (units.length() == 0) {
            throw new NcException("Variable has no units!");
        }
        String calendarName = dimVar.findAttribute("calendar") != null ? dimVar.findAttribute("calendar").getStringValue().toLowerCase() : (dataset != null && dataset.findGlobalAttribute("calendar") != null ? dataset.findGlobalAttribute("calendar").getStringValue().toLowerCase() : GREGORIAN);
        this.decimalIncrements_ = dimVar.getDataType() == DataType.DOUBLE || dimVar.getDataType() == DataType.FLOAT;
        this.init(units, calendarName);
    }

    private void init(String units, String calendarName) throws ParseException {
        int firstDash;
        String lcunits = units.toLowerCase();
        int sinceIndex = lcunits.indexOf(" since ");
        if (sinceIndex < 1) {
            throw new ParseException("Not relative time units", -1);
        }
        this.initIncrementUnits(units);
        this.initCalendar(calendarName);
        String originString = units.substring(sinceIndex + 7);
        if (this.calendar_ instanceof NcClimateModelCalendar && (firstDash = originString.indexOf("-")) > 0) {
            String ystr = originString.substring(0, firstDash);
            try {
                ystr = ystr.replaceAll("\\D", "");
                int year = Integer.parseInt(ystr);
                if (year == 0) {
                    this.zeroBasedYear_ = true;
                    originString = "0001" + originString.substring(firstDash);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (originString.matches(".* \\+\\d\\d:.*")) {
            originString = originString.replaceAll(" \\+", " GMT+");
        } else if (originString.matches(".* \\-\\d\\d:.*")) {
            originString = originString.replaceAll(" \\-", "GMT-");
        }
        this.initPattern(originString);
    }

    private void initIncrementUnits(String units) throws ParseException {
        String lcunits = units.toLowerCase();
        if (lcunits.startsWith("year")) {
            this.incrementField_ = 1;
        } else if (lcunits.startsWith("month")) {
            this.incrementField_ = 2;
        } else if (lcunits.startsWith("day")) {
            this.incrementField_ = 5;
        } else if (lcunits.startsWith("hour")) {
            this.incrementField_ = 10;
        } else if (lcunits.startsWith("minute")) {
            this.incrementField_ = 12;
        } else if (lcunits.startsWith("sec")) {
            this.incrementField_ = 13;
        } else if (lcunits.startsWith("msec") || lcunits.startsWith("millisec")) {
            this.incrementField_ = 14;
        } else {
            throw new ParseException("I don't know how to handle units '" + units + "'", -1);
        }
    }

    private void initCalendar(String calendarName) throws ParseException {
        if ((calendarName = calendarName.toLowerCase()).equals(GREGORIAN) || calendarName.equals(GREGORIAN_A) || calendarName.equals(GREGORIAN_B) || calendarName.equals(PRO_GREG) || calendarName.equals(JULIAN)) {
            TimeZone gmt = TimeZone.getTimeZone("GMT");
            gmt.setRawOffset(0);
            this.calendar_ = new GregorianCalendar();
            if (calendarName.equals(PRO_GREG)) {
                ((GregorianCalendar)this.calendar_).setGregorianChange(new Date(Long.MIN_VALUE));
            } else if (calendarName.equals(JULIAN)) {
                ((GregorianCalendar)this.calendar_).setGregorianChange(new Date(Long.MAX_VALUE));
            }
            this.calendar_.setTimeZone(gmt);
        } else if (calendarName.equals(NO_LEAP) || calendarName.equals(NO_LEAP_A) || calendarName.equals(NO_LEAP_B) || calendarName.equals(NO_LEAP_C)) {
            this.calendar_ = new NcClimateModelCalendar(NcCalendarType.NO_LEAP);
        } else if (calendarName.equals(ALL_LEAP) || calendarName.equals(ALL_LEAP_A)) {
            this.calendar_ = new NcClimateModelCalendar(NcCalendarType.ALL_LEAP);
        } else if (calendarName.equals(TWELVE_30) || calendarName.equals(TWELVE_30_A)) {
            this.calendar_ = new NcClimateModelCalendar(NcCalendarType.TWELVE_30);
        } else {
            throw new ParseException("Calendar name '" + calendarName + "' is a mystery to me.", -1);
        }
    }

    private void initPattern(String originString) throws ParseException {
        this.dtFormat_ = new SimpleDateFormat();
        this.dtFormat_.setLenient(true);
        this.dtFormat_.setCalendar(this.calendar_);
        String tryPattern = null;
        boolean hasTimeZone = false;
        for (String pattern : ISO_PATTERNS) {
            try {
                this.dtFormat_.applyPattern(pattern);
                this.origin_ = this.dtFormat_.parse(originString);
                this.matchedPattern_ = pattern;
                hasTimeZone = this.matchedPattern_.toLowerCase().indexOf("z") > -1;
                this.dtFormat_.applyPattern(MSECOND_PATTERN);
                if (this.incrementField_ == 14) {
                    tryPattern = MSECOND_PATTERN;
                    break;
                }
                this.calendar_.setTime(this.origin_);
                if (this.calendar_.get(14) != 0) {
                    tryPattern = MSECOND_PATTERN;
                    break;
                }
                this.dtFormat_.applyPattern(SECOND_PATTERN);
                if (this.incrementField_ == 14 || this.incrementField_ == 13) {
                    tryPattern = SECOND_PATTERN;
                    break;
                }
                this.calendar_.setTime(this.origin_);
                if (this.calendar_.get(13) != 0) {
                    tryPattern = SECOND_PATTERN;
                    break;
                }
                this.dtFormat_.applyPattern("yyyy-MM-dd HH:mm");
                if (this.calendar_.get(12) != 0 || this.incrementField_ == 12) {
                    tryPattern = "yyyy-MM-dd HH:mm";
                    break;
                }
                if (this.incrementField_ == 5 && pattern.indexOf("mm") > -1) {
                    tryPattern = "yyyy-MM-dd HH:mm";
                    break;
                }
                this.dtFormat_.applyPattern("yyyy-MM-dd HH:mm");
                if (this.calendar_.get(10) != 0 || this.incrementField_ == 10) {
                    tryPattern = "yyyy-MM-dd HH:mm";
                    break;
                }
                this.dtFormat_.applyPattern(DATE_PATTERN);
                if (this.calendar_.get(5) != 1 || this.incrementField_ == 5) {
                    tryPattern = DATE_PATTERN;
                    break;
                }
                this.dtFormat_.applyPattern(MONTH_PATTERN);
                tryPattern = MONTH_PATTERN;
                break;
            }
            catch (Exception exc) {
            }
        }
        if (this.matchedPattern_ == null) {
            throw new ParseException("Cannot parse '" + originString + "'", -1);
        }
        if (this.decimalIncrements_) {
            if (tryPattern.startsWith("yyyy-MM-dd HH:mm") || tryPattern.startsWith("yyyy-MM-dd HH:mm")) {
                tryPattern = SECOND_PATTERN;
            } else if (tryPattern.startsWith(DATE_PATTERN)) {
                tryPattern = "yyyy-MM-dd HH:mm";
            } else if (tryPattern.startsWith(MONTH_PATTERN)) {
                logger_.warn("Relative time units with fractional months are a bad idea.");
            }
        }
        if (hasTimeZone) {
            tryPattern = tryPattern + " Z";
        }
        this.dtFormat_.applyPattern(tryPattern);
    }

    public String getPattern() {
        return this.dtFormat_.toPattern();
    }

    public void applyPattern(String pattern) {
        this.dtFormat_.applyPattern(pattern);
    }

    @Override
    public String format(double delta) {
        if (delta == Double.NaN) {
            throw new IllegalArgumentException("Cannot add NaN double value.");
        }
        if (Double.isInfinite(delta)) {
            throw new IllegalArgumentException("Cannot add infinite double value.");
        }
        double whole = Math.floor(delta);
        if (delta == whole) {
            return this.format((long)delta);
        }
        this.applyOffset(this.incrementField_, (long)whole);
        double fraction = delta - whole;
        double seconds = 0.0;
        if (this.incrementField_ == 1) {
            seconds = fraction * 12.0 * 30.0 * 24.0 * 60.0 * 60.0;
        } else if (this.incrementField_ == 2) {
            seconds = fraction * 30.0 * 24.0 * 60.0 * 60.0;
        } else if (this.incrementField_ == 5) {
            seconds = fraction * 24.0 * 60.0 * 60.0;
        } else if (this.incrementField_ == 10) {
            seconds = fraction * 60.0 * 60.0;
        } else if (this.incrementField_ == 12) {
            seconds = fraction * 60.0;
        }
        NcRelativeTime.applyOffset(13, (long)seconds, this.calendar_);
        return this.formatDate();
    }

    @Override
    public String format(int delta) {
        return this.format((long)delta);
    }

    public String format(long delta) {
        this.applyOffset(this.incrementField_, delta);
        return this.formatDate();
    }

    private void applyOffset(int field, long delta) {
        this.calendar_.setTime(this.origin_);
        NcRelativeTime.applyOffset(field, delta, this.calendar_);
    }

    private static void applyOffset(int field, long delta, Calendar cal) {
        if (delta == 0L) {
            return;
        }
        if (delta < Integer.MAX_VALUE) {
            cal.add(field, (int)delta);
        } else {
            long d;
            for (d = delta; d > 2147483000L; d -= 2147483000L) {
                cal.add(field, 2147483000);
            }
            cal.add(field, (int)d);
        }
    }

    private String formatDate() {
        if (!this.zeroBasedYear_) {
            return this.dtFormat_.format(this.calendar_.getTime());
        }
        int year = this.calendar_.get(1);
        if (year == 1) {
            Date d = this.calendar_.getTime();
            String result = this.dtFormat_.format(d);
            result = result.replaceFirst("1", "0");
            return result;
        }
        this.calendar_.set(1, year - 1);
        return this.dtFormat_.format(this.calendar_.getTime());
    }
}

