/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.time;

import gov.nasa.giss.netcdf.time.NcDataTime;
import gov.nasa.giss.time.JDCalendar;
import gov.nasa.giss.time.JulianType;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class NcJulianTime
implements NcDataTime {
    private static final String SECOND_PATTERN_STRING = "yyyy-MM-dd HH:mm:ss";
    private static final String MINUTE_PATTERN_STRING = "yyyy-MM-dd HH:mm";
    private static final String HOUR_PATTERN_STRING = "yyyy-MM-dd HH:mm";
    private static final String DATE_PATTERN_STRING = "yyyy-MM-dd";
    private static final String MONTH_PATTERN_STRING = "yyyy-MM";
    private static final String YEAR_PATTERN_STRING = "yyyy";
    public static final String[] PATTERNS = new String[]{"yyyy", "yyyy-MM", "yyyy-MM-dd", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss"};
    private JulianType epoch_ = JulianType.SIMPLE;
    private SimpleDateFormat dtFormat_;
    private JDCalendar calendar_ = new JDCalendar();

    public NcJulianTime() throws ParseException {
        this(JulianType.SIMPLE);
    }

    public NcJulianTime(JulianType epoch) throws ParseException {
        this.dtFormat_ = new SimpleDateFormat();
        this.dtFormat_.setCalendar(this.calendar_);
        this.dtFormat_.applyPattern("yyyy-MM-dd HH:mm");
        this.setEpoch(epoch);
    }

    public void setEpoch(JulianType epoch) {
        this.epoch_ = epoch;
    }

    public String getPattern() {
        return this.dtFormat_.toPattern();
    }

    public void applyPattern(String pattern) {
        this.dtFormat_.applyPattern(pattern);
    }

    @Override
    public String format(double jd) {
        if (jd == Double.NaN) {
            throw new IllegalArgumentException("Cannot use NaN double value.");
        }
        if (Double.isInfinite(jd)) {
            throw new IllegalArgumentException("Cannot use infinite double value.");
        }
        this.calendar_.setJulianDate(this.epoch_, jd);
        return this.dtFormat_.format(this.calendar_.getTime());
    }

    @Override
    public String format(int delta) {
        return this.format((double)delta);
    }
}

