/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gui;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.gui.treetable.TreeTablePanel;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcDatasetList;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.netcdf.gui.NcTreeTableDragGestureListener;
import gov.nasa.giss.netcdf.gui.NcTreeTableModel;
import java.awt.EventQueue;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.io.IOException;

public class NcTreeTablePanel
extends TreeTablePanel {
    private boolean expandNewNodes_ = true;

    public NcTreeTablePanel() {
        super(new NcTreeTableModel());
        NcTreeTableDragGestureListener dsa = new NcTreeTableDragGestureListener(this.getTreeTable());
        DragGestureRecognizer dgr = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getTreeTable(), 1, dsa);
    }

    public void setExpandNewNodes(boolean expand) {
        this.expandNewNodes_ = expand;
    }

    public void setShowOnlyPlottables(boolean onlyPlottables) {
        ((NcTreeTableModel)this.getModel()).setShowOnlyPlottables(onlyPlottables);
    }

    public Object[] getDatasets() {
        NcTreeTableModel model = (NcTreeTableModel)this.getModel();
        return ((NcDatasetList)model.getRoot()).getChildren();
    }

    public int getDatasetCount() {
        return this.getDatasets().length;
    }

    @Override
    public void removeAll() {
        Object[] datasets = this.getDatasets();
        for (Object dataset : this.getDatasets()) {
            this.removeDataset((NcNode)dataset);
        }
    }

    public void removeDataset(NcNode node) {
        ((NcTreeTableModel)this.getModel()).removeDataset(node);
        this.fireItemRemoved(node);
    }

    public NcDataset addDataset(final NcDataset ncd) throws IOException {
        if (ncd == null) {
            return null;
        }
        NcTreeTableModel model = (NcTreeTableModel)this.getModel();
        model.addDataset(ncd);
        if (this.expandNewNodes_) {
            TreeTableNode[] nodes;
            this.getTreeTable().expandNode(ncd);
            for (TreeTableNode node : nodes = ncd.getChildren()) {
                this.getTreeTable().expandNode(node);
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NcTreeTablePanel.this.getTreeTable().setSelectedNode(ncd);
                NcTreeTablePanel.this.getTreeTable().makeNodeVisible(ncd);
                NcTreeTablePanel.this.fireItemAdded(ncd);
            }
        });
        return ncd;
    }
}

