/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gui;

import gov.nasa.giss.gui.treetable.TreeTableModel;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcDatasetException;
import gov.nasa.giss.netcdf.NcDatasetList;
import gov.nasa.giss.netcdf.NcNode;
import java.io.IOException;
import java.net.URL;
import javax.swing.SwingConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcTreeTableModel
extends TreeTableModel
implements SwingConstants {
    private static Logger logger_ = LoggerFactory.getLogger(NcTreeTableModel.class);
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Long Name", "Type"};
    private static final Class[] COLUMN_CLASSES = new Class[]{TreeTableModel.class, String.class, String.class};
    private static final int[] COLUMN_ALIGNMENTS = new int[]{2, 2, 0};

    public NcTreeTableModel() {
        super(new NcDatasetList());
        this.setShowOnlyPlottables(false);
    }

    @Override
    public int getColumnAlignment(int col) {
        return COLUMN_ALIGNMENTS[col];
    }

    public Class getColumnClass(int col) {
        return COLUMN_CLASSES[col];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public Object getValueAt(TreeTableNode node, int col) {
        NcNode ncn = (NcNode)node;
        try {
            switch (col) {
                case 0: {
                    return ncn.getName();
                }
                case 1: {
                    return ncn.getLongName();
                }
                case 2: {
                    return ncn.getNcType();
                }
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, TreeTableNode node, int col) {
    }

    public NcDataset addDataset(NcDataset ncd) throws IOException {
        if (this.containsDatasetWithURL(ncd.getURL())) {
            throw new NcDatasetException("Dataset is already open");
        }
        NcDatasetList root = (NcDatasetList)this.getRoot();
        int index = root.addAlphabetically(ncd);
        this.nodeInserted(root, index, ncd);
        return ncd;
    }

    public void removeDataset(NcNode child) {
        if (!(child instanceof NcDataset)) {
            return;
        }
        NcNode root = (NcNode)this.getRoot();
        int index = root.getIndexOfChild(child);
        if (index < 0) {
            logger_.warn("Apparently trying to remove NcNode which is not child dataset list.");
            return;
        }
        try {
            root.remove(index);
            this.nodeRemoved(root, index, child);
        }
        catch (Exception exc) {
            logger_.error(exc.toString());
            exc.printStackTrace();
        }
    }

    public void setShowOnlyPlottables(boolean onlyPlottables) {
        NcDatasetList root = (NcDatasetList)this.getRoot();
        root.setShowOnlyPlottables(this, onlyPlottables);
    }

    public boolean containsDatasetWithURL(URL url) {
        NcDatasetList root = (NcDatasetList)this.getRoot();
        String us = url.toString();
        for (TreeTableNode child : root.getChildren()) {
            NcDataset dataset = (NcDataset)child;
            String ds = dataset.getURL().toString();
            if (us.compareTo(ds) != 0) continue;
            return true;
        }
        return false;
    }
}

