/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gui;

import gov.nasa.giss.gui.DragGhost;
import gov.nasa.giss.gui.treetable.TreeTable;
import gov.nasa.giss.gui.treetable.TreeTableCellRenderer;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.netcdf.NcTransferableVariable;
import gov.nasa.giss.netcdf.NcVariable;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import javax.swing.BorderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcTreeTableDragGestureListener
extends DragSourceAdapter
implements DragGestureListener {
    private static Logger logger_ = LoggerFactory.getLogger(NcTreeTableDragGestureListener.class);
    private TreeTable jtt_;

    public NcTreeTableDragGestureListener(TreeTable jtt) {
        this.jtt_ = jtt;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        NcNode node = (NcNode)this.jtt_.getSelectedNode();
        if (!(node instanceof NcVariable)) {
            return;
        }
        NcVariable ncvar = (NcVariable)node;
        if (!ncvar.isPlottable()) {
            return;
        }
        int row = this.jtt_.getRowForNode(node);
        TreeTableCellRenderer ttcr = (TreeTableCellRenderer)this.jtt_.getCellRenderer(row, 0).getTableCellRendererComponent(this.jtt_, node, false, false, row, 0);
        int iconX = ttcr.getIconX(this.jtt_, node, null);
        ttcr.setBorder(BorderFactory.createEmptyBorder());
        ttcr.setSize(ttcr.getPreferredSize());
        ttcr.setLeftShift(ttcr.getIconX(this.jtt_, node, null));
        dge.startDrag(DragSource.DefaultCopyDrop, new DragGhost(ttcr), new Point(5, 5), new NcTransferableVariable(ncvar), this);
    }
}

