/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gui;

import gov.nasa.giss.gui.treetable.TreeTablePanel;
import gov.nasa.giss.netcdf.NcCatalog;
import gov.nasa.giss.netcdf.NcCatalogList;
import gov.nasa.giss.netcdf.NcCatalogNode;
import gov.nasa.giss.netcdf.gui.NcCatalogTreeTableModel;
import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.border.CompoundBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcCatalogTreeTablePanel
extends TreeTablePanel {
    private static Logger logger_ = LoggerFactory.getLogger(NcCatalogTreeTablePanel.class);
    private boolean expandNewNodes_ = true;

    public NcCatalogTreeTablePanel() {
        super(new NcCatalogTreeTableModel());
        this.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), this.getBorder()));
    }

    public void setExpandNewNodes(boolean expand) {
        this.expandNewNodes_ = expand;
    }

    public Object[] getCatalogs() {
        NcCatalogTreeTableModel model = (NcCatalogTreeTableModel)this.getModel();
        NcCatalogList clist = (NcCatalogList)model.getRoot();
        return clist.getChildren();
    }

    public int getCatalogCount() {
        return this.getCatalogs().length;
    }

    @Override
    public void removeAll() {
        for (Object catalog : this.getCatalogs()) {
            this.removeCatalog((NcCatalog)catalog);
        }
    }

    public void removeCatalog(NcCatalog node) {
        NcCatalogTreeTableModel model = (NcCatalogTreeTableModel)this.getModel();
        model.removeCatalog(node);
        this.fireItemRemoved(node);
    }

    public synchronized NcCatalogNode addCatalog(URL url) throws MalformedURLException, URISyntaxException {
        if (url == null) {
            return null;
        }
        NcCatalogTreeTableModel model = (NcCatalogTreeTableModel)this.getModel();
        final NcCatalogNode node = model.addCatalog(url);
        if (this.expandNewNodes_) {
            this.getTreeTable().expandNode(node);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NcCatalogTreeTablePanel.this.getTreeTable().setSelectedNode(node);
                NcCatalogTreeTablePanel.this.getTreeTable().makeNodeVisible(node);
                NcCatalogTreeTablePanel.this.fireItemAdded(node);
            }
        });
        return node;
    }
}

