/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gui;

import gov.nasa.giss.gui.treetable.TreeTableModel;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcCatalog;
import gov.nasa.giss.netcdf.NcCatalogList;
import gov.nasa.giss.netcdf.NcCatalogNode;
import gov.nasa.giss.netcdf.NcException;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.SwingConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogFactory;

public class NcCatalogTreeTableModel
extends TreeTableModel
implements SwingConstants {
    private static Logger logger_ = LoggerFactory.getLogger(NcCatalogTreeTableModel.class);
    private static final String[] COLUMN_NAMES = new String[]{"Name"};
    private static final Class[] COLUMN_CLASSES = new Class[]{TreeTableModel.class};
    private static InvCatalogFactory factory_;

    public NcCatalogTreeTableModel() {
        super(new NcCatalogList());
        factory_ = InvCatalogFactory.getDefaultFactory(true);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    public Class getColumnClass(int col) {
        return COLUMN_CLASSES[col];
    }

    @Override
    public int getColumnAlignment(int col) {
        return 2;
    }

    @Override
    public Object getValueAt(TreeTableNode node, int col) {
        if (node == null) {
            return "";
        }
        NcCatalogNode o = (NcCatalogNode)node;
        try {
            switch (col) {
                case 0: {
                    return o.getName();
                }
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, TreeTableNode node, int col) {
    }

    public NcCatalogNode addCatalog(URL url) throws MalformedURLException, URISyntaxException {
        URL url2;
        String urlString = url.toString();
        if (urlString.endsWith("catalog.html")) {
            int index = urlString.lastIndexOf("catalog.html");
            urlString = urlString.substring(0, index) + "catalog.xml";
            url2 = new URL(urlString);
        } else if (urlString.endsWith("/")) {
            urlString = urlString + "catalog.xml";
            url2 = new URL(urlString);
        } else {
            url2 = url;
        }
        NcCatalog child = null;
        try {
            child = this.tryCatalogURL(url2);
        }
        catch (NcException nce) {
            throw nce;
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (child == null && !urlString.endsWith("/catalog.xml")) {
            urlString = urlString + "/catalog.xml";
            url2 = new URL(urlString);
            try {
                child = this.tryCatalogURL(url2);
            }
            catch (NcException nce) {
                throw nce;
            }
            catch (FileNotFoundException fnfe) {
                throw new NcException("No file at that URL.");
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new NcException(exc.toString());
            }
        }
        if (child == null) {
            throw new NcException("No catalog found.");
        }
        NcCatalogList root = (NcCatalogList)this.getRoot();
        root.add(child);
        int isize = root.getChildCount();
        this.nodeInserted(root, isize - 1, child);
        return child;
    }

    public NcCatalog tryCatalogURL(URL url) throws FileNotFoundException, URISyntaxException {
        URI uri = url.toURI();
        if (this.containsCatalogWithURI(uri)) {
            throw new NcException("Catalog is already open.");
        }
        return new NcCatalog(null, uri);
    }

    public void removeCatalog(NcCatalogNode child) {
        if (!(child instanceof NcCatalog)) {
            return;
        }
        NcCatalogList root = (NcCatalogList)this.getRoot();
        int index = root.getIndexOfChild(child);
        if (index < 0) {
            logger_.warn("Apparently trying to remove NcCatalogNode which is not child catalog list.");
            return;
        }
        try {
            root.remove(index);
            this.nodeRemoved(root, index, child);
        }
        catch (Exception exc) {
            logger_.error("{}", (Object)exc.toString());
            exc.printStackTrace();
        }
    }

    public boolean containsCatalogWithURI(URI uri) {
        NcCatalogList root = (NcCatalogList)this.getRoot();
        for (TreeTableNode child : root.getChildren()) {
            NcCatalog catalog = (NcCatalog)child;
            if (!uri.equals(catalog.getURI())) continue;
            return true;
        }
        return false;
    }
}

