/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gridder;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.netcdf.gridder.NcGridderUtils;
import java.awt.Dimension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcTimeLatGridder
extends NcGridder {
    private static Logger logger_ = LoggerFactory.getLogger(NcTimeLatGridder.class);
    protected double xUnitPerPxl_;
    protected double yDegPerPxl_;
    protected double xPxlPerDeg_;
    protected double yPxlPerUnit_;

    public NcTimeLatGridder() {
        this(100, 50);
    }

    public NcTimeLatGridder(Dimension size) {
        this(size.width, size.height);
    }

    public NcTimeLatGridder(int w, int h) {
        this.setSize(w, h);
        this.setBounds(0.0, 0.0, 1.0, 1.0);
    }

    @Override
    public void setSize(int w, int h) {
        this.gridWidth_ = w;
        this.gridHeight_ = h;
    }

    @Override
    public boolean setBounds(double[] bounds) {
        return this.setBounds(bounds[0], bounds[1], bounds[2], bounds[3]);
    }

    @Override
    public boolean setBounds(double l, double t, double r, double b) {
        this.lBound_ = l;
        this.tBound_ = t;
        this.rBound_ = r;
        this.bBound_ = b;
        return true;
    }

    protected void prepareOutputGrid() {
        this.xUnitPerPxl_ = (this.rBound_ - this.lBound_) / (double)this.gridWidth_;
        this.yDegPerPxl_ = (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
        this.xPxlPerDeg_ = 1.0 / this.xUnitPerPxl_;
        this.yPxlPerUnit_ = 1.0 / this.yDegPerPxl_;
        this.colXX_ = new double[this.gridWidth_];
        this.rowYY_ = new double[this.gridHeight_];
        for (int i = 0; i < this.gridWidth_; ++i) {
            this.colXX_[i] = this.lBound_ + ((double)i + 0.5) * this.xUnitPerPxl_;
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            this.rowYY_[j] = this.tBound_ + ((double)j + 0.5) * this.yDegPerPxl_;
        }
    }

    @Override
    public void regridNoInterpolate(NcArray nca, double[] target) {
        int j;
        this.prepareOutputGrid();
        NcArray2D nca2D = (NcArray2D)nca;
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        int numXs = nca2D.getWidth();
        int numYs = nca2D.getHeight();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block0: for (j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < numYs; ++jj) {
                if (!(this.rowYY_[j] < yBounds[jj][0]) || !(this.rowYY_[j] >= yBounds[jj][1])) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            for (int ii = 0; ii < numXs; ++ii) {
                if (!(this.colXX_[i] > (double)ii - 0.5) || !(this.colXX_[i] <= (double)ii + 0.5)) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (j = 0; j < this.gridHeight_; ++j) {
            if (srcRow[j] < 0) continue;
            for (int i = 0; i < this.gridWidth_; ++i) {
                if (srcCol[i] < 0) continue;
                double value = nca2D.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca2D.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                this.setValue(target, i, j, value);
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray nca, double[] target) {
        this.prepareOutputGrid();
        NcArray2D nca2D = (NcArray2D)nca;
        int numXs = nca2D.getWidth();
        int numYs = nca2D.getHeight();
        if (numXs > this.gridWidth_ * 4 / 10 || numYs > this.gridHeight_ * 4 / 10) {
            this.regridInterpolateFine((NcArray2D)nca, target);
        } else {
            this.regridInterpolateCoarse((NcArray2D)nca, target);
        }
    }

    protected void regridInterpolateFine(NcArray2D nca2D, double[] target) {
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        double[] xValues = xAxis.getValues();
        double[] yValues = yAxis.getValues();
        double[][] yBounds = yAxis.getBounds();
        int numYs = yValues.length;
        int numXs = xValues.length;
        int lastY = numYs - 1;
        int lastX = numXs - 1;
        double lBoundVal2 = xAxis.boundsAt(0)[0];
        double rBoundVal2 = xAxis.boundsAt(xAxis.getSize() - 1)[1];
        double xPxlPerDeg_2 = (double)this.gridWidth_ / (rBoundVal2 - lBoundVal2);
        double[] colX2 = new double[this.gridWidth_];
        for (int i = 0; i < this.gridWidth_; ++i) {
            colX2[i] = lBoundVal2 + ((double)i + 0.5) / xPxlPerDeg_2;
        }
        boolean npAveraged = false;
        boolean spAveraged = false;
        if (nca2D.hasAveragingDimension() && 90.0 - yValues[0] < (yBounds[0][0] - yValues[0]) * 1.75) {
            npAveraged = true;
        }
        if (nca2D.hasAveragingDimension() && yValues[lastY] - -90.0 < (yValues[lastY] - yBounds[lastY][1]) * 1.75) {
            spAveraged = true;
        }
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block5: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            if (npAveraged && this.rowYY_[j] > yValues[0] && this.rowYY_[j] <= 90.0) {
                srcRow[j] = -99;
                continue;
            }
            if (spAveraged && this.rowYY_[j] < yValues[lastY] && this.rowYY_[j] >= -90.0) {
                srcRow[j] = -98;
                continue;
            }
            for (int jj = 0; jj < lastY; ++jj) {
                if (!(this.rowYY_[j] <= yValues[jj]) || !(this.rowYY_[j] > yValues[jj + 1])) continue;
                srcRow[j] = jj;
                continue block5;
            }
        }
        block7: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            for (int ii = 0; ii < numXs - 1; ++ii) {
                if (!(colX2[i] >= xValues[ii]) || !(colX2[i] < xValues[ii + 1])) continue;
                srcCol[i] = ii;
                continue block7;
            }
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            double yPct;
            if (srcRow[j] == -1) continue;
            if (srcRow[j] == -99) {
                if (!npAveraged) continue;
                yPct = (this.rowYY_[j] - this.tBound_) / (yValues[0] - this.tBound_);
            } else if (srcRow[j] == -98) {
                if (!spAveraged) continue;
                yPct = (this.rowYY_[j] - yValues[lastY]) / (this.bBound_ - yValues[lastY]);
            } else {
                yPct = (this.rowYY_[j] - yValues[srcRow[j]]) / (yValues[srcRow[j] + 1] - yValues[srcRow[j]]);
            }
            for (int i = 0; i < this.gridWidth_; ++i) {
                double valBR;
                double valBL;
                double valTR;
                double valTL;
                int leftCol = srcCol[i];
                int rightCol = srcCol[i] + 1;
                if (leftCol < 0 || rightCol < 0 || rightCol >= numXs) continue;
                if (srcRow[j] == -99) {
                    try {
                        valTL = nca2D.dimensionAverageAt(leftCol, 0);
                        valTR = nca2D.dimensionAverageAt(rightCol, 0);
                    }
                    catch (Exception exc) {
                        valTL = Double.NaN;
                        valTR = Double.NaN;
                    }
                    valBL = nca2D.valueAt(leftCol, 0);
                    valBR = nca2D.valueAt(rightCol, 0);
                } else if (srcRow[j] == -98) {
                    valTL = nca2D.valueAt(leftCol, lastY);
                    valTR = nca2D.valueAt(rightCol, lastY);
                    try {
                        valBL = nca2D.dimensionAverageAt(leftCol, lastY);
                        valBR = nca2D.dimensionAverageAt(rightCol, lastY);
                    }
                    catch (Exception exc) {
                        valBL = Double.NaN;
                        valBR = Double.NaN;
                    }
                } else {
                    valTL = nca2D.valueAt(leftCol, srcRow[j]);
                    valTR = nca2D.valueAt(rightCol, srcRow[j]);
                    valBL = nca2D.valueAt(leftCol, srcRow[j] + 1);
                    valBR = nca2D.valueAt(rightCol, srcRow[j] + 1);
                }
                double xPct = (colX2[i] - xValues[leftCol]) / (xValues[rightCol] - xValues[leftCol]);
                if (hasBad) {
                    if (nca2D.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                this.setValue(target, i, j, value);
            }
        }
    }

    protected void regridInterpolateCoarse(NcArray2D nca2D, double[] target) {
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        double[] xValues = xAxis.getValues();
        double[] yValues = yAxis.getValues();
        double[][] yBounds = yAxis.getBounds();
        int numXs = xValues.length;
        int numYs = yValues.length;
        int lastX = numXs - 1;
        int lastY = numYs - 1;
        boolean npAveraged = false;
        boolean spAveraged = false;
        if (nca2D.hasAveragingDimension() && 90.0 - yValues[0] < (yBounds[0][0] - yValues[0]) * 1.75) {
            npAveraged = true;
        }
        if (nca2D.hasAveragingDimension() && yValues[lastY] - -90.0 < (yValues[lastY] - yBounds[lastY][1]) * 1.75) {
            spAveraged = true;
        }
        for (int j = -1; j < numYs; ++j) {
            double bottomLat;
            double topLat;
            int jP1 = j + 1;
            if (j == -1) {
                topLat = npAveraged ? 90.0 : yBounds[0][0];
                bottomLat = yValues[0];
            } else if (jP1 == numYs) {
                topLat = yValues[j];
                bottomLat = spAveraged ? -90.0 : yBounds[lastY][1];
            } else {
                topLat = yValues[j];
                bottomLat = yValues[jP1];
            }
            double topY = (topLat - this.tBound_) * this.yPxlPerUnit_;
            double bottomY = (bottomLat - this.tBound_) * this.yPxlPerUnit_;
            if (bottomY < 0.0 || topY >= (double)this.gridHeight_) continue;
            for (int i = 0; i < lastX; ++i) {
                double valTR;
                double valTL;
                double valBR;
                double valBL;
                int iP1 = i + 1;
                double leftT = i;
                double rightT = (double)i + 1.0;
                double leftX = (leftT - this.lBound_) * this.xPxlPerDeg_;
                double rightX = (rightT - this.lBound_) * this.xPxlPerDeg_;
                if (leftT == rightT) continue;
                if (j == -1) {
                    valBL = nca2D.valueAt(i, 0);
                    valBR = nca2D.valueAt(iP1, 0);
                    if (npAveraged) {
                        try {
                            valTL = nca2D.dimensionAverageAt(i, 0);
                            valTR = nca2D.dimensionAverageAt(iP1, 0);
                        }
                        catch (Exception exc) {
                            valTL = Double.NaN;
                            valTR = Double.NaN;
                        }
                    } else {
                        valTL = valBL;
                        valTR = valBR;
                    }
                } else if (jP1 == numYs) {
                    valTL = nca2D.valueAt(i, j);
                    valTR = nca2D.valueAt(iP1, j);
                    if (spAveraged) {
                        try {
                            valBL = nca2D.dimensionAverageAt(i, j);
                            valBR = nca2D.dimensionAverageAt(iP1, j);
                        }
                        catch (Exception exc) {
                            valBL = Double.NaN;
                            valBR = Double.NaN;
                        }
                    } else {
                        valBL = valTL;
                        valBR = valTR;
                    }
                } else {
                    valTL = nca2D.valueAt(i, j);
                    valTR = nca2D.valueAt(iP1, j);
                    valBL = nca2D.valueAt(i, jP1);
                    valBR = nca2D.valueAt(iP1, jP1);
                }
                if (hasBad) {
                    if (nca2D.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                NcGridderUtils.bilinearInterpolateFill(leftX, topY, rightX, bottomY, valTL, valTR, valBL, valBR, target, this.gridWidth_, this.gridHeight_);
            }
        }
    }

    protected void setValue(double[] array, int col, int row, double value) {
        if (col < 0 || col >= this.gridWidth_) {
            return;
        }
        if (row < 0 || row >= this.gridHeight_) {
            return;
        }
        int index = row * this.gridWidth_ + col;
        if (index < 0 || index >= array.length) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        array[index] = value;
    }
}

