/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gridder;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.array.NcArrayLonLatScatterNodes;
import gov.nasa.giss.netcdf.gridder.NcLonLatAbstractGridder;
import java.awt.Dimension;

public class NcLonLatScatterGridder
extends NcLonLatAbstractGridder {
    public NcLonLatScatterGridder() {
        this(100, 50);
    }

    public NcLonLatScatterGridder(Dimension size) {
        this(size.width, size.height);
    }

    public NcLonLatScatterGridder(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        NcArrayLonLatScatterNodes nca = (NcArrayLonLatScatterNodes)a;
        boolean hasBad = nca.hasBadValues();
        int isize = nca.getNodeCount();
        float[][] points = new float[isize][2];
        for (int i = 0; i < isize; ++i) {
            double x = (nca.getLongitudeAt(i) - this.lBound_) * this.xPxlPerDeg_;
            double y = (nca.getLatitudeAt(i) - this.tBound_) * this.yPxlPerDeg_;
            points[i][0] = (float)x;
            points[i][1] = (float)y;
        }
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        this.regridNoInterpolate(a, target);
    }
}

