/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gridder;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.gridder.NcGridderUtils;
import gov.nasa.giss.netcdf.gridder.NcLonLatAbstractGridder;
import java.awt.Dimension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcLonLatRegularGridder
extends NcLonLatAbstractGridder {
    private static Logger logger_ = LoggerFactory.getLogger(NcLonLatRegularGridder.class);

    public NcLonLatRegularGridder() {
        this(100, 50);
    }

    public NcLonLatRegularGridder(Dimension size) {
        this(size.width, size.height);
    }

    public NcLonLatRegularGridder(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        int j;
        this.prepareOutputGrid();
        NcArray2D nca = (NcArray2D)a;
        boolean hasBad = nca.hasBadValues();
        NcAxis xAxis = nca.getXAxis();
        NcAxis yAxis = nca.getYAxis();
        int numXs = xAxis.getSize();
        int numYs = yAxis.getSize();
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block0: for (j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < numYs; ++jj) {
                if (!(this.rowYY_[j] <= yBounds[jj][0]) || !(this.rowYY_[j] > yBounds[jj][1])) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            double lon = this.colXX_[i];
            for (int ii = 0; ii < numXs; ++ii) {
                double leftII = xBounds[ii][0];
                double rightII = xBounds[ii][1];
                while (lon < leftII) {
                    lon += 360.0;
                }
                while (lon > rightII) {
                    lon -= 360.0;
                }
                if (!(lon >= leftII) || !(lon < rightII)) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (j = 0; j < this.gridHeight_; ++j) {
            if (srcRow[j] < 0) continue;
            for (int i = 0; i < this.gridWidth_; ++i) {
                if (srcCol[i] < 0) continue;
                double value = nca.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                NcGridderUtils.setValue(target, i, j, value, this.gridWidth_, this.gridHeight_);
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        this.prepareOutputGrid();
        NcArray2D nca2D = (NcArray2D)a;
        int numXs = nca2D.getWidth();
        int numYs = nca2D.getHeight();
        if (numXs > this.gridWidth_ * 4 / 10 || numYs > this.gridHeight_ * 4 / 10) {
            this.regridInterpolateFine(nca2D, target);
        } else {
            this.regridInterpolateCoarse(nca2D, target);
        }
    }

    public void regridInterpolateFine(NcArray2D nca, double[] target) {
        boolean hasBad = nca.hasBadValues();
        NcAxis xAxis = nca.getXAxis();
        NcAxis yAxis = nca.getYAxis();
        double[] xValues = xAxis.getValues();
        double[] yValues = yAxis.getValues();
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int numYs = yValues.length;
        int numXs = xValues.length;
        int lastY = numYs - 1;
        int lastX = xAxis.isWraparound() ? numXs : numXs - 1;
        double npValue = Double.NaN;
        double spValue = Double.NaN;
        boolean npAveraged = false;
        boolean spAveraged = false;
        if (nca.hasAveragingDimension() && 90.0 - yValues[0] < (yBounds[0][0] - yValues[0]) * 1.75) {
            try {
                npValue = nca.rowAverageOf(0);
                npAveraged = true;
            }
            catch (Exception e) {
                npValue = Double.NaN;
            }
        }
        if (nca.hasAveragingDimension() && yValues[lastY] - -90.0 < (yValues[lastY] - yBounds[lastY][1]) * 1.75) {
            try {
                spValue = nca.rowAverageOf(lastY);
                spAveraged = true;
            }
            catch (Exception e) {
                spValue = Double.NaN;
            }
        }
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block4: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            if (npAveraged && this.rowYY_[j] > yValues[0] && this.rowYY_[j] <= 90.0) {
                srcRow[j] = -99;
                continue;
            }
            if (spAveraged && this.rowYY_[j] < yValues[lastY] && this.rowYY_[j] >= -90.0) {
                srcRow[j] = -98;
                continue;
            }
            for (int jj = 0; jj < lastY; ++jj) {
                if (!(this.rowYY_[j] <= yValues[jj]) || !(this.rowYY_[j] > yValues[jj + 1])) continue;
                srcRow[j] = jj;
                continue block4;
            }
        }
        block6: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            double lon = this.colXX_[i];
            for (int ii = 0; ii < lastX; ++ii) {
                double rightII;
                double leftII = xValues[ii];
                double d = rightII = ii == numXs - 1 ? xValues[0] + 360.0 : xValues[ii + 1];
                while (lon < leftII) {
                    lon += 360.0;
                }
                while (lon > rightII) {
                    lon -= 360.0;
                }
                if (!(lon >= leftII) || !(lon < rightII)) continue;
                srcCol[i] = ii;
                continue block6;
            }
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            double yPct;
            if (srcRow[j] == -1) continue;
            if (srcRow[j] == -99) {
                if (!npAveraged) continue;
                yPct = (this.rowYY_[j] - 90.0) / (yValues[0] - 90.0);
            } else if (srcRow[j] == -98) {
                if (!spAveraged) continue;
                yPct = (this.rowYY_[j] - yValues[lastY]) / (-90.0 - yValues[lastY]);
            } else {
                yPct = (this.rowYY_[j] - yValues[srcRow[j]]) / (yValues[srcRow[j] + 1] - yValues[srcRow[j]]);
            }
            for (int i = 0; i < this.gridWidth_; ++i) {
                double valBR;
                double valBL;
                double valTR;
                double valTL;
                double rightLon;
                int leftCol = srcCol[i];
                if (leftCol == -1) continue;
                int rightCol = leftCol + 1 < numXs ? leftCol + 1 : 0;
                double leftLon = xValues[leftCol];
                for (rightLon = xValues[rightCol]; rightLon < leftLon; rightLon += 360.0) {
                }
                while (this.colXX_[i] < leftLon) {
                    int n = i;
                    this.colXX_[n] = this.colXX_[n] + 360.0;
                }
                while (this.colXX_[i] > rightLon) {
                    int n = i;
                    this.colXX_[n] = this.colXX_[n] - 360.0;
                }
                double xPct = (this.colXX_[i] - leftLon) / (rightLon - leftLon);
                if (srcRow[j] == -99) {
                    valTL = npValue;
                    valTR = npValue;
                    valBL = nca.valueAt(leftCol, 0);
                    valBR = nca.valueAt(rightCol, 0);
                } else if (srcRow[j] == -98) {
                    valTL = nca.valueAt(leftCol, lastY);
                    valTR = nca.valueAt(rightCol, lastY);
                    valBL = spValue;
                    valBR = spValue;
                } else {
                    valTL = nca.valueAt(leftCol, srcRow[j]);
                    valTR = nca.valueAt(rightCol, srcRow[j]);
                    valBL = nca.valueAt(leftCol, srcRow[j] + 1);
                    valBR = nca.valueAt(rightCol, srcRow[j] + 1);
                }
                if (hasBad) {
                    if (nca.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                NcGridderUtils.setValue(target, i, j, value, this.gridWidth_, this.gridHeight_);
            }
        }
    }

    private void regridInterpolateCoarse(NcArray2D nca, double[] target) {
        boolean hasBad = nca.hasBadValues();
        NcAxis xAxis = nca.getXAxis();
        NcAxis yAxis = nca.getYAxis();
        double[] xValues = xAxis.getValues();
        double[] yValues = yAxis.getValues();
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int numYs = yValues.length;
        int numXs = xValues.length;
        int lastX = xAxis.isWraparound() ? numXs : numXs - 1;
        int lastY = numYs - 1;
        double npValue = Double.NaN;
        double spValue = Double.NaN;
        boolean npAveraged = false;
        boolean spAveraged = false;
        if (nca.hasAveragingDimension() && 90.0 - yValues[0] < (yBounds[0][0] - yValues[0]) * 1.75) {
            try {
                npValue = nca.rowAverageOf(0);
            }
            catch (Exception e) {
                npValue = Double.NaN;
            }
            npAveraged = true;
        }
        if (nca.hasAveragingDimension() && yValues[lastY] - -90.0 < (yValues[lastY] - yBounds[lastY][1]) * 1.75) {
            try {
                spValue = nca.rowAverageOf(lastY);
            }
            catch (Exception e) {
                spValue = Double.NaN;
            }
            spAveraged = true;
        }
        for (int j = -1; j < numYs; ++j) {
            double bottomLat;
            double topLat;
            int jP1 = j + 1;
            if (j == -1) {
                topLat = npAveraged ? 90.0 : yBounds[0][0];
                bottomLat = yValues[0];
            } else if (jP1 == numYs) {
                topLat = yValues[j];
                bottomLat = spAveraged ? -90.0 : yBounds[lastY][1];
            } else {
                topLat = yValues[j];
                bottomLat = yValues[jP1];
            }
            double topY = (topLat - this.tBound_) * this.yPxlPerDeg_;
            double bottomY = (bottomLat - this.tBound_) * this.yPxlPerDeg_;
            if (bottomY < 0.0 || topY >= (double)this.gridHeight_) continue;
            for (int i = 0; i < lastX; ++i) {
                double valTR;
                double valTL;
                double valBR;
                double valBL;
                double leftLon;
                int iP1 = i < numXs - 1 ? i + 1 : 0;
                double rightLon = xValues[iP1];
                for (leftLon = xValues[i]; leftLon < this.lBound_; leftLon += 360.0) {
                }
                while (leftLon >= this.lBound_ + 360.0) {
                    leftLon -= 360.0;
                }
                while (rightLon <= leftLon) {
                    rightLon += 360.0;
                }
                while (rightLon > leftLon + 360.0) {
                    rightLon -= 360.0;
                }
                if (leftLon >= this.rBound_) {
                    leftLon -= 360.0;
                    rightLon -= 360.0;
                }
                if (rightLon <= this.lBound_) continue;
                boolean overFlows = leftLon < this.lBound_ || rightLon > this.rBound_;
                double leftX = (leftLon - this.lBound_) * this.xPxlPerDeg_;
                double rightX = (rightLon - this.lBound_) * this.xPxlPerDeg_;
                if (j == -1) {
                    valBL = nca.valueAt(i, 0);
                    valBR = nca.valueAt(iP1, 0);
                    if (npAveraged) {
                        valTL = npValue;
                        valTR = npValue;
                    } else {
                        valTL = valBL;
                        valTR = valBR;
                    }
                } else if (jP1 == numYs) {
                    valTL = nca.valueAt(i, j);
                    valTR = nca.valueAt(iP1, j);
                    if (spAveraged) {
                        valBL = spValue;
                        valBR = spValue;
                    } else {
                        valBL = valTL;
                        valBR = valTR;
                    }
                } else {
                    valTL = nca.valueAt(i, j);
                    valTR = nca.valueAt(iP1, j);
                    valBL = nca.valueAt(i, jP1);
                    valBR = nca.valueAt(iP1, jP1);
                }
                if (hasBad) {
                    if (nca.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                NcGridderUtils.bilinearInterpolateFill(leftX, topY, rightX, bottomY, valTL, valTR, valBL, valBR, target, this.gridWidth_, this.gridHeight_);
                if (!overFlows || !(rightLon >= this.rBound_)) continue;
                leftX = (leftLon - 360.0 - this.lBound_) * this.xPxlPerDeg_;
                rightX = (rightLon - 360.0 - this.lBound_) * this.xPxlPerDeg_;
                NcGridderUtils.bilinearInterpolateFill(leftX, topY, rightX, bottomY, valTL, valTR, valBL, valBR, target, this.gridWidth_, this.gridHeight_);
            }
        }
    }
}

