/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gridder;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.array.NcArrayLonLatReducedType2;
import gov.nasa.giss.netcdf.gridder.NcLonLatAbstractGridder;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Dimension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcLonLatReducedType2Gridder
extends NcLonLatAbstractGridder {
    private static Logger logger_ = LoggerFactory.getLogger(NcLonLatReducedType2Gridder.class);
    private static final PrintfFormat PFORMAT_F3 = new PrintfFormat("%.3f");

    public NcLonLatReducedType2Gridder() {
        this(100, 50);
    }

    public NcLonLatReducedType2Gridder(Dimension size) {
        this(size.width, size.height);
    }

    public NcLonLatReducedType2Gridder(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        this.prepareOutputGrid();
        NcArrayLonLatReducedType2 nca = (NcArrayLonLatReducedType2)a;
        int numXs = nca.getXAxis().getSize();
        int numYs = nca.getYAxis().getSize();
        boolean hasBad = nca.hasBadValues();
        for (int i = 0; i < numXs; ++i) {
            for (int j = 0; j < numYs; ++j) {
                double[][] corners;
                double value = nca.valueAt(i, j);
                if (hasBad && nca.isMissingOrInvalid(value) || (corners = nca.getCellCornerLonLats(i, j)) == null) continue;
                double lon0 = nca.getLongitudeAt(i, j);
                double lat0 = nca.getLatitudeAt(i, j);
                double lon1 = corners[0][0];
                double lon2 = corners[1][0];
                double lon3 = corners[2][0];
                double lon4 = corners[3][0];
                double lat1 = corners[0][1];
                double lat2 = corners[1][1];
                double lat3 = corners[2][1];
                double lat4 = corners[3][1];
                this.quadSolidFillLL(lon1, lat1, lon2, lat2, lon3, lat3, lon4, lat4, value, target);
                if (lon1 > this.rBound_ || lon2 > this.rBound_ || lon3 > this.rBound_ || lon4 > this.rBound_) {
                    this.quadSolidFillLL(lon1 -= 360.0, lat1, lon2 -= 360.0, lat2, lon3 -= 360.0, lat3, lon4 -= 360.0, lat4, value, target);
                    continue;
                }
                if (!(lon1 < this.lBound_ || lon2 < this.lBound_ || lon3 < this.lBound_) && !(lon4 < this.lBound_)) continue;
                this.quadSolidFillLL(lon1 += 360.0, lat1, lon2 += 360.0, lat2, lon3 += 360.0, lat3, lon4 += 360.0, lat4, value, target);
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        this.prepareOutputGrid();
        NcArrayLonLatReducedType2 nca = (NcArrayLonLatReducedType2)a;
        int numXs = nca.getXAxis().getSize();
        int numYs = nca.getYAxis().getSize();
        boolean hasBad = nca.hasBadValues();
        boolean wrapsOnX = this.doesGridWrap(nca, true);
        boolean wrapsOnY = this.doesGridWrap(nca, false);
        int lastX = wrapsOnX ? numXs : numXs - 1;
        int lastY = wrapsOnY ? numYs : numYs - 1;
        for (int i = 0; i < lastX; ++i) {
            int ip1 = i < numXs - 1 ? i + 1 : 0;
            for (int j = 0; j < lastY; ++j) {
                double lon2;
                int jp1 = j < numYs - 1 ? j + 1 : 0;
                double lat1 = nca.getLatitudeAt(i, j);
                double lat2 = nca.getLatitudeAt(ip1, j);
                double lat3 = nca.getLatitudeAt(ip1, jp1);
                double lat4 = nca.getLatitudeAt(i, jp1);
                double lon1 = nca.getLongitudeAt(i, j);
                double lon3 = nca.getLongitudeAt(ip1, jp1);
                double lon4 = nca.getLongitudeAt(i, jp1);
                for (lon2 = nca.getLongitudeAt(ip1, j); lon1 - 90.0 > lon2; lon2 += 360.0) {
                }
                while (lon1 - 90.0 > lon3) {
                    lon3 += 360.0;
                }
                while (lon1 - 90.0 > lon4) {
                    lon4 += 360.0;
                }
                while (lon2 - 90.0 > lon1) {
                    lon2 -= 360.0;
                }
                while (lon3 - 90.0 > lon1) {
                    lon3 -= 360.0;
                }
                while (lon4 - 90.0 > lon1) {
                    lon4 -= 360.0;
                }
                double value1 = nca.valueAt(i, j);
                double value2 = nca.valueAt(ip1, j);
                double value3 = nca.valueAt(ip1, jp1);
                double value4 = nca.valueAt(i, jp1);
                if (!nca.doCellShareCorner(i, j, ip1, j)) {
                    value2 = Double.NaN;
                }
                if (!nca.doCellShareCorner(i, j, ip1, jp1)) {
                    value3 = Double.NaN;
                }
                if (!nca.doCellShareCorner(i, j, i, jp1)) {
                    value4 = Double.NaN;
                }
                if (Double.isNaN(value2) && Double.isNaN(value3) || Double.isNaN(value3) && Double.isNaN(value4)) continue;
                this.quadInterpolateFillLL(lon1, lat1, value1, lon2, lat2, value2, lon3, lat3, value3, lon4, lat4, value4, target);
                if (lon1 > this.rBound_ || lon2 > this.rBound_ || lon3 > this.rBound_ || lon4 > this.rBound_) {
                    this.quadInterpolateFillLL(lon1 -= 360.0, lat1, value1, lon2 -= 360.0, lat2, value2, lon3 -= 360.0, lat3, value3, lon4 -= 360.0, lat4, value4, target);
                    continue;
                }
                if (!(lon1 < this.lBound_ || lon2 < this.lBound_ || lon3 < this.lBound_) && !(lon4 < this.lBound_)) continue;
                this.quadInterpolateFillLL(lon1 += 360.0, lat1, value1, lon2 += 360.0, lat2, value2, lon3 += 360.0, lat3, value3, lon4 += 360.0, lat4, value4, target);
            }
        }
    }

    private boolean doesGridWrap(NcArrayLonLatReducedType2 nca, boolean onX) {
        int numXs = nca.getXAxis().getSize();
        int numYs = nca.getYAxis().getSize();
        int lastX = numXs - 1;
        int lastY = numYs - 1;
        if (onX) {
            for (int j = 0; j < lastY; ++j) {
                boolean abutting = nca.doCellsShareSide(lastX, j, 0, j);
                if (abutting) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < lastX; ++i) {
            boolean abutting = nca.doCellsShareSide(i, lastY, i, 0);
            if (abutting) continue;
            return false;
        }
        return true;
    }
}

