/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gridder;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.array.NcArrayLonLatReducedType1;
import gov.nasa.giss.netcdf.gridder.NcGridderUtils;
import gov.nasa.giss.netcdf.gridder.NcLonLatAbstractGridder;
import java.awt.Dimension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcLonLatReducedType1Gridder
extends NcLonLatAbstractGridder {
    private static Logger logger_ = LoggerFactory.getLogger(NcLonLatReducedType1Gridder.class);

    public NcLonLatReducedType1Gridder() {
        this(100, 50);
    }

    public NcLonLatReducedType1Gridder(Dimension size) {
        this(size.width, size.height);
    }

    public NcLonLatReducedType1Gridder(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        this.prepareOutputGrid();
        NcArrayLonLatReducedType1 nca = (NcArrayLonLatReducedType1)a;
        boolean hasBad = nca.hasBadValues();
        NcAxis yAxis = nca.getYAxis();
        int numYs = yAxis.getSize();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block0: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < numYs; ++jj) {
                if (!(this.rowYY_[j] <= yBounds[jj][0] && this.rowYY_[j] > yBounds[jj][1]) && (!(this.rowYY_[j] > yBounds[jj][0]) || !(this.rowYY_[j] <= yBounds[jj][1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        int prevSRow = -9999;
        for (int j = 0; j < this.gridHeight_; ++j) {
            if (srcRow[j] < 0) continue;
            if (srcRow[j] != prevSRow) {
                NcAxis xAxis = nca.getXAxis(srcRow[j]);
                int numXs = xAxis.getSize();
                double[][] xBounds = xAxis.getBounds();
                block3: for (int i = 0; i < this.gridWidth_; ++i) {
                    srcCol[i] = -1;
                    double lon = this.colXX_[i];
                    for (int ii = 0; ii < numXs; ++ii) {
                        double leftII = xBounds[ii][0];
                        double rightII = xBounds[ii][1];
                        while (lon < leftII) {
                            lon += 360.0;
                        }
                        while (lon > rightII) {
                            lon -= 360.0;
                        }
                        if (!(lon >= leftII) || !(lon < rightII)) continue;
                        srcCol[i] = ii;
                        continue block3;
                    }
                }
                prevSRow = srcRow[j];
            }
            for (int i = 0; i < this.gridWidth_; ++i) {
                if (srcCol[i] < 0) continue;
                double value = nca.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                NcGridderUtils.setValue(target, i, j, value, this.gridWidth_, this.gridHeight_);
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        int j;
        this.prepareOutputGrid();
        NcArrayLonLatReducedType1 nca = (NcArrayLonLatReducedType1)a;
        boolean hasBad = nca.hasBadValues();
        NcAxis yAxis = nca.getYAxis();
        int numYs = yAxis.getSize();
        int lastY = numYs - 1;
        double[] yValues = yAxis.getValues();
        int[] srcRow = new int[this.gridHeight_];
        block0: for (j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < lastY; ++jj) {
                if (!(this.rowYY_[j] >= yValues[jj] && this.rowYY_[j] <= yValues[jj + 1]) && (!(this.rowYY_[j] <= yValues[jj]) || !(this.rowYY_[j] >= yValues[jj + 1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        for (j = 0; j < this.gridHeight_; ++j) {
            if (srcRow[j] == -1) continue;
            double lat1 = yValues[srcRow[j]];
            double lat2 = yValues[srcRow[j] + 1];
            double yPct = (this.rowYY_[j] - lat1) / (lat2 - lat1);
            NcAxis xAxis1 = nca.getXAxis(srcRow[j]);
            int numXs1 = xAxis1.getSize();
            int lastCol1 = numXs1 - 1;
            double[] xValues1 = xAxis1.getValues();
            NcAxis xAxis2 = nca.getXAxis(srcRow[j] + 1);
            int numXs2 = xAxis2.getSize();
            int lastCol2 = numXs2 - 1;
            double[] xValues2 = xAxis2.getValues();
            for (int i = 0; i < this.gridWidth_; ++i) {
                int ii;
                double lon = this.colXX_[i];
                int srcCol1 = -1;
                int srcCol2 = -1;
                for (ii = 0; ii < lastCol1; ++ii) {
                    if (!this.isLonInRange(lon, xValues1[ii], xValues1[ii + 1])) continue;
                    srcCol1 = ii;
                    break;
                }
                for (ii = 0; ii < lastCol2; ++ii) {
                    if (!this.isLonInRange(lon, xValues2[ii], xValues2[ii + 1])) continue;
                    srcCol2 = ii;
                    break;
                }
                if (srcCol1 < 0 || srcCol2 < 0) continue;
                double lon1L = xValues1[srcCol1];
                double lon1R = xValues1[srcCol1 + 1];
                double lon2L = xValues2[srcCol2];
                double lon2R = xValues2[srcCol2 + 1];
                while (lon < lon1L) {
                    lon += 360.0;
                }
                while (lon > lon1R) {
                    lon -= 360.0;
                }
                double xPct1 = (lon - lon1L) / (lon1R - lon1L);
                double xPct2 = (lon - lon2L) / (lon1R - lon2L);
                double xPct = 0.5 * (xPct1 + xPct2);
                double valTL = nca.valueAt(srcCol1, srcRow[j]);
                double valTR = nca.valueAt(srcCol1 + 1, srcRow[j]);
                double valBL = nca.valueAt(srcCol2, srcRow[j] + 1);
                double valBR = nca.valueAt(srcCol2 + 1, srcRow[j] + 1);
                if (hasBad) {
                    if (nca.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                NcGridderUtils.setValue(target, i, j, value, this.gridWidth_, this.gridHeight_);
            }
        }
    }

    private boolean isLonInRange(double lon, double left, double right) {
        double lonx;
        if (lon >= left && lon <= right) {
            return true;
        }
        for (lonx = lon; lonx < left; lonx += 360.0) {
        }
        while (lonx > right) {
            lonx -= 360.0;
        }
        return lonx >= left && lonx <= right;
    }
}

