/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gridder;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.array.NcArrayLonLatProjectedGrid;
import gov.nasa.giss.netcdf.gridder.NcGridderUtils;
import gov.nasa.giss.netcdf.gridder.NcLonLatAbstractGridder;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcLonLatProjectedGridder
extends NcLonLatAbstractGridder {
    private static Logger logger_ = LoggerFactory.getLogger(NcLonLatProjectedGridder.class);
    private double lProjBound_;
    private double tProjBound_;
    private double rProjBound_;
    private double bProjBound_;
    private double projPerXPxl_;
    private double projPerYPxl_;
    private double xPxlPerProj_;
    private double yPxlPerProj_;
    private double[] projColXX_;
    private double[] projRowYY_;

    public NcLonLatProjectedGridder() {
        this(100, 50);
    }

    public NcLonLatProjectedGridder(Dimension size) {
        this(size.width, size.height);
    }

    public NcLonLatProjectedGridder(int w, int h) {
        super(w, h);
    }

    private double[] makeIntermediateGrid(NcArray nca, int isize) {
        double[] bgrid = new double[isize];
        for (int i = 0; i < isize; ++i) {
            bgrid[i] = Double.NaN;
        }
        double[] bounds = ((NcArrayLonLatProjectedGrid)nca).getBounds();
        this.lProjBound_ = bounds[0];
        this.tProjBound_ = bounds[1];
        this.rProjBound_ = bounds[2];
        this.bProjBound_ = bounds[3];
        this.projColXX_ = new double[this.gridWidth_];
        this.projRowYY_ = new double[this.gridHeight_];
        this.projPerXPxl_ = (this.rProjBound_ - this.lProjBound_) / (double)this.gridWidth_;
        this.projPerYPxl_ = (this.bProjBound_ - this.tProjBound_) / (double)this.gridHeight_;
        for (int i = 0; i < this.gridWidth_; ++i) {
            this.projColXX_[i] = this.lProjBound_ + ((double)i + 0.5) * this.projPerXPxl_;
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            this.projRowYY_[j] = this.tProjBound_ + ((double)j + 0.5) * this.projPerYPxl_;
        }
        this.xPxlPerProj_ = (double)this.gridWidth_ / (this.rProjBound_ - this.lProjBound_);
        this.yPxlPerProj_ = (double)this.gridHeight_ / (this.bProjBound_ - this.tProjBound_);
        return bgrid;
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        int j;
        this.prepareOutputGrid();
        NcArray2D nca = (NcArray2D)a;
        double[] bgrid = this.makeIntermediateGrid(nca, target.length);
        boolean hasBad = nca.hasBadValues();
        NcAxis xAxis = nca.getXAxis();
        NcAxis yAxis = nca.getYAxis();
        int numXs = xAxis.getSize();
        int numYs = yAxis.getSize();
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block0: for (j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < numYs; ++jj) {
                if (!(this.projRowYY_[j] <= yBounds[jj][0]) || !(this.projRowYY_[j] > yBounds[jj][1])) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            double lon = this.projColXX_[i];
            for (int ii = 0; ii < numXs; ++ii) {
                double leftII = xBounds[ii][0];
                double rightII = xBounds[ii][1];
                if (!(lon >= leftII) || !(lon < rightII)) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (j = 0; j < this.gridHeight_; ++j) {
            if (srcRow[j] < 0) continue;
            for (int i = 0; i < this.gridWidth_; ++i) {
                if (srcCol[i] < 0) continue;
                double value = nca.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                NcGridderUtils.setValue(bgrid, i, j, value, this.gridWidth_, this.gridHeight_);
            }
        }
        this.transformProjectedGrid((NcArrayLonLatProjectedGrid)nca, bgrid, target);
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        this.prepareOutputGrid();
        NcArray2D nca = (NcArray2D)a;
        double[] bgrid = this.makeIntermediateGrid(nca, target.length);
        boolean hasBad = nca.hasBadValues();
        NcAxis xAxis = nca.getXAxis();
        NcAxis yAxis = nca.getYAxis();
        double[] xValues = xAxis.getValues();
        double[] yValues = yAxis.getValues();
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int numYs = yValues.length;
        int numXs = xValues.length;
        int lastY = numYs - 1;
        int lastX = numXs - 1;
        int[] srcRow = new int[this.gridHeight_];
        block0: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < lastY; ++jj) {
                if (!(this.projRowYY_[j] <= yValues[jj]) || !(this.projRowYY_[j] > yValues[jj + 1])) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        int[] srcCol = new int[this.gridWidth_];
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            for (int ii = 0; ii < lastX; ++ii) {
                double leftII = xValues[ii];
                double rightII = xValues[ii + 1];
                if (!(this.projColXX_[i] >= leftII) || !(this.projColXX_[i] < rightII)) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            if (srcRow[j] == -1) continue;
            double yPct = (this.projRowYY_[j] - yValues[srcRow[j]]) / (yValues[srcRow[j] + 1] - yValues[srcRow[j]]);
            for (int i = 0; i < this.gridWidth_; ++i) {
                int leftCol = srcCol[i];
                if (leftCol == -1) continue;
                int rightCol = leftCol + 1 < numXs ? leftCol + 1 : 0;
                double leftLon = xValues[leftCol];
                double rightLon = xValues[rightCol];
                double xPct = (this.projColXX_[i] - leftLon) / (rightLon - leftLon);
                double valTL = nca.valueAt(leftCol, srcRow[j]);
                double valTR = nca.valueAt(rightCol, srcRow[j]);
                double valBL = nca.valueAt(leftCol, srcRow[j] + 1);
                double valBR = nca.valueAt(rightCol, srcRow[j] + 1);
                if (hasBad) {
                    if (nca.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                NcGridderUtils.setValue(bgrid, i, j, value, this.gridWidth_, this.gridHeight_);
            }
        }
        this.transformProjectedGrid((NcArrayLonLatProjectedGrid)nca, bgrid, target);
    }

    private void transformProjectedGrid(NcArrayLonLatProjectedGrid anca, double[] fromArray, double[] toArray) {
        for (int row = 0; row < this.gridHeight_; ++row) {
            double rowLat = this.tBound_ + ((double)row + 0.5) * this.yDegPerPxl_;
            for (int col = 0; col < this.gridWidth_; ++col) {
                double colLon = this.lBound_ + ((double)col + 0.5) * this.xDegPerPxl_;
                Point2D.Double fromXY = anca.transformLL2XY(colLon, rowLat);
                if (fromXY == null) continue;
                int altCol = (int)((fromXY.x - this.lProjBound_) * this.xPxlPerProj_ + 0.5);
                int altRow = (int)((fromXY.y - this.tProjBound_) * this.yPxlPerProj_ + 0.5);
                if (altCol < 0 || altCol >= this.gridWidth_ || altRow < 0 || altRow >= this.gridHeight_) continue;
                int fromIndex = altRow * this.gridWidth_ + altCol;
                int toIndex = row * this.gridWidth_ + col;
                toArray[toIndex] = fromArray[fromIndex];
            }
        }
    }
}

