/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gridder;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.array.NcArrayLonLatFvcomNodes;
import gov.nasa.giss.netcdf.gridder.NcGridderUtils;
import gov.nasa.giss.netcdf.gridder.NcLonLatAbstractGridder;
import java.awt.Dimension;

public class NcLonLatFvcomGridder
extends NcLonLatAbstractGridder {
    public NcLonLatFvcomGridder() {
        this(100, 50);
    }

    public NcLonLatFvcomGridder(Dimension size) {
        this(size.width, size.height);
    }

    public NcLonLatFvcomGridder(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        NcArrayLonLatFvcomNodes nca = (NcArrayLonLatFvcomNodes)a;
        this.regrid(nca, target, false);
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        NcArrayLonLatFvcomNodes nca = (NcArrayLonLatFvcomNodes)a;
        this.regrid(nca, target, true);
    }

    private void regrid(NcArrayLonLatFvcomNodes nca, double[] target, boolean interpolate) {
        this.prepareOutputGrid();
        boolean hasBad = nca.hasBadValues();
        int isize = nca.getElementCount();
        for (int i = 0; i < isize; ++i) {
            int[] nodes = nca.getElementNodes(i);
            double z1 = nca.valueAt(nodes[0]);
            double z2 = nca.valueAt(nodes[1]);
            double z3 = nca.valueAt(nodes[2]);
            if (Double.isNaN(z1) || Double.isNaN(z2) || Double.isNaN(z3)) continue;
            double x1 = (nca.getLongitudeAt(nodes[0]) - this.lBound_) * this.xPxlPerDeg_;
            double y1 = (nca.getLatitudeAt(nodes[0]) - this.tBound_) * this.yPxlPerDeg_;
            double x2 = (nca.getLongitudeAt(nodes[1]) - this.lBound_) * this.xPxlPerDeg_;
            double y2 = (nca.getLatitudeAt(nodes[1]) - this.tBound_) * this.yPxlPerDeg_;
            double x3 = (nca.getLongitudeAt(nodes[2]) - this.lBound_) * this.xPxlPerDeg_;
            double y3 = (nca.getLatitudeAt(nodes[2]) - this.tBound_) * this.yPxlPerDeg_;
            if (x1 < 0.0 && x2 < 0.0 && x3 < 0.0 || y1 < 0.0 && y2 < 0.0 && y3 < 0.0) continue;
            if (interpolate) {
                NcGridderUtils.triInterpolateFill(x1, y1, z1, x2, y2, z2, x3, y3, z3, target, this.gridWidth_, this.gridHeight_);
                continue;
            }
            double z = (z1 + z2 + z3) / 3.0;
            NcGridderUtils.triSolidFill(x1, y1, x2, y2, x3, y3, z, target, this.gridWidth_, this.gridHeight_);
        }
    }
}

