/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gridder;

import gov.nasa.giss.math.Geometry2D;

public class NcGridderUtils {
    private NcGridderUtils() {
    }

    public static void bilinearInterpolateFill(double xLeft, double yTop, double xRight, double yBottom, double valTL, double valTR, double valBL, double valBR, double[] target, int width, int height) {
        int xmin = (int)(xLeft - 0.75);
        int xmax = (int)(xRight + 1.25);
        int ymin = (int)(yTop - 0.75);
        int ymax = (int)(yBottom + 1.25);
        boolean badCorners = false;
        block0: for (int i = xmin; i <= xmax; ++i) {
            if (i < 0) continue;
            if (i >= width) break;
            double x = 0.5 + (double)i;
            if (x < xLeft) continue;
            if (x > xRight) break;
            double xPct = (x - xLeft) / (xRight - xLeft);
            for (int j = ymin; j <= ymax; ++j) {
                if (j < 0) continue;
                if (j >= height) continue block0;
                double y = 0.5 + (double)j;
                if (y < yTop) continue;
                if (y > yBottom) continue block0;
                double yPct = (y - yTop) / (yBottom - yTop);
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                NcGridderUtils.setValue(target, i, j, value, width, height);
            }
        }
    }

    public static double bilinearInterpolate(double xLeft, double yTop, double xRight, double yBottom, double valTL, double valTR, double valBL, double valBR, double x, double y) {
        double xPct = (x - xLeft) / (xRight - xLeft);
        double yPct = (y - yTop) / (yBottom - yTop);
        return NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
    }

    public static double bilinearInterpolate(double xPct, double yPct, double valTL, double valTR, double valBL, double valBR) {
        int badCorners = 0;
        if (Double.isNaN(valTL)) {
            ++badCorners;
        }
        if (Double.isNaN(valTR)) {
            ++badCorners;
        }
        if (Double.isNaN(valBL)) {
            ++badCorners;
        }
        if (Double.isNaN(valBR)) {
            ++badCorners;
        }
        if (badCorners == 0) {
            return NcGridderUtils.fourPoints(valTL, valTR, valBL, valBR, xPct, yPct);
        }
        if (badCorners == 4) {
            return Double.NaN;
        }
        if (badCorners == 3) {
            if (xPct < 0.5 && yPct < 0.5) {
                return valTL;
            }
            if (yPct < 0.5) {
                return valTR;
            }
            if (xPct < 0.5) {
                return valBL;
            }
            return valBR;
        }
        if (badCorners == 2) {
            if (Double.isNaN(valTL) && Double.isNaN(valTR)) {
                if (yPct < 0.5) {
                    return Double.NaN;
                }
                return NcGridderUtils.twoPoints(valBL, valBR, xPct);
            }
            if (Double.isNaN(valBL) && Double.isNaN(valBR)) {
                if (yPct < 0.5) {
                    return NcGridderUtils.twoPoints(valTL, valTR, xPct);
                }
                return Double.NaN;
            }
            if (Double.isNaN(valTL) && Double.isNaN(valBL)) {
                if (xPct < 0.5) {
                    return Double.NaN;
                }
                return NcGridderUtils.twoPoints(valTR, valBR, yPct);
            }
            if (Double.isNaN(valTR) && Double.isNaN(valBR)) {
                if (xPct < 0.5) {
                    return NcGridderUtils.twoPoints(valTL, valBL, yPct);
                }
                return Double.NaN;
            }
            if (xPct < 0.5 && yPct < 0.5) {
                return valTL;
            }
            if (yPct < 0.5) {
                return valTR;
            }
            if (xPct < 0.5) {
                return valBL;
            }
            return valBR;
        }
        if (Double.isNaN(valTL)) {
            if (xPct < 0.5 && yPct < 0.5) {
                return Double.NaN;
            }
            return NcGridderUtils.threePoints(valBR, valBL, valTR, 1.0 - xPct, 1.0 - yPct);
        }
        if (Double.isNaN(valTR)) {
            if (xPct >= 0.5 && yPct < 0.5) {
                return Double.NaN;
            }
            return NcGridderUtils.threePoints(valBL, valTL, valBR, 1.0 - yPct, xPct);
        }
        if (Double.isNaN(valBL)) {
            if (xPct < 0.5 && yPct >= 0.5) {
                return Double.NaN;
            }
            return NcGridderUtils.threePoints(valTR, valBR, valTL, yPct, 1.0 - xPct);
        }
        if (xPct < 0.5 || yPct < 0.5) {
            return NcGridderUtils.threePoints(valTL, valTR, valBL, xPct, yPct);
        }
        return Double.NaN;
    }

    private static double twoPoints(double value1, double value2, double percent) {
        return value1 * (1.0 - percent) + value2 * percent;
    }

    private static double threePoints(double value1, double value2, double value3, double percentA, double percentB) {
        double value4 = (value1 + value2 + value3) / 3.0;
        return value1 * (1.0 - percentB) * (1.0 - percentA) + value2 * (1.0 - percentB) * percentA + value3 * percentB * (1.0 - percentA) + value4 * percentB * percentA;
    }

    private static double fourPoints(double valueTL, double valueTR, double valueBL, double valueBR, double percentLR, double percentTB) {
        return valueTL * (1.0 - percentTB) * (1.0 - percentLR) + valueTR * (1.0 - percentTB) * percentLR + valueBL * percentTB * (1.0 - percentLR) + valueBR * percentTB * percentLR;
    }

    protected static void quadSolidFill(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double value, double[] target, int width, int height) {
        int xmin = (int)(Math.min(Math.min(x1, x2), Math.min(x3, x4)) - 0.75);
        int xmax = (int)(Math.max(Math.max(x1, x2), Math.max(x3, x4)) + 1.25);
        int ymin = (int)(Math.min(Math.min(y1, y2), Math.min(y3, y4)) - 0.75);
        int ymax = (int)(Math.max(Math.max(y1, y2), Math.max(y3, y4)) + 1.25);
        block0: for (int i = xmin; i <= xmax; ++i) {
            if (i < 0) continue;
            if (i >= width) break;
            double x = 0.5 + (double)i;
            for (int j = ymin; j <= ymax; ++j) {
                if (j < 0) continue;
                if (j >= height) continue block0;
                double y = 0.5 + (double)j;
                if (!Geometry2D.isPointInQuadrilateral(x, y, x1, y1, x2, y2, x3, y3, x4, y4)) continue;
                NcGridderUtils.setValue(target, i, j, value, width, height);
            }
        }
    }

    protected static void quadInterpolateFill(double x1, double y1, double val1, double x2, double y2, double val2, double x3, double y3, double val3, double x4, double y4, double val4, double[] target, int width, int height) {
        if (Double.isNaN(val1)) {
            if (Double.isNaN(val2) || Double.isNaN(val3) || Double.isNaN(val4)) {
                return;
            }
            NcGridderUtils.triInterpolateFill(x2, y2, val2, x3, y3, val3, x4, y4, val4, target, width, height);
        } else if (Double.isNaN(val2)) {
            if (Double.isNaN(val3) || Double.isNaN(val4)) {
                return;
            }
            NcGridderUtils.triInterpolateFill(x1, y1, val1, x3, y3, val3, x4, y4, val4, target, width, height);
        } else if (Double.isNaN(val3)) {
            if (Double.isNaN(val4)) {
                return;
            }
            NcGridderUtils.triInterpolateFill(x1, y1, val1, x2, y2, val2, x4, y4, val4, target, width, height);
        } else if (Double.isNaN(val4)) {
            NcGridderUtils.triInterpolateFill(x1, y1, val1, x2, y2, val2, x3, y3, val3, target, width, height);
        } else {
            NcGridderUtils.triInterpolateFill(x1, y1, val1, x2, y2, val2, x3, y3, val3, target, width, height);
            NcGridderUtils.triInterpolateFill(x1, y1, val1, x3, y3, val3, x4, y4, val4, target, width, height);
        }
    }

    protected static void triSolidFill(double x1, double y1, double x2, double y2, double x3, double y3, double val, double[] target, int width, int height) {
        int xmin = (int)(Math.min(x1, Math.min(x2, x3)) - 0.5);
        int xmax = (int)(Math.max(x1, Math.max(x2, x3)) + 1.0);
        int ymin = (int)(Math.min(y1, Math.min(y2, y3)) - 0.5);
        int ymax = (int)(Math.max(y1, Math.max(y2, y3)) + 1.0);
        block0: for (int i = xmin; i <= xmax; ++i) {
            if (i < 0) continue;
            if (i >= width) break;
            double x = 0.5 + (double)i;
            for (int j = ymin; j <= ymax; ++j) {
                if (j < 0) continue;
                if (j >= height) continue block0;
                double y = 0.5 + (double)j;
                if (!Geometry2D.isPointInTriangle(x, y, x1, y1, x2, y2, x3, y3)) continue;
                NcGridderUtils.setValue(target, i, j, val, width, height);
            }
        }
    }

    protected static void triInterpolateFill(double x1, double y1, double val1, double x2, double y2, double val2, double x3, double y3, double val3, double[] target, int width, int height) {
        double a = y1 * (val2 - val3) + y2 * (val3 - val1) + y3 * (val1 - val2);
        double b = val1 * (x2 - x3) + val2 * (x3 - x1) + val3 * (x1 - x2);
        double c = x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2);
        double d = -(x1 * (y2 * val3 - y3 * val2) + x2 * (y3 * val1 - y1 * val3) + x3 * (y1 * val2 - y2 * val1));
        if (c == 0.0) {
            return;
        }
        int xmin = (int)Math.min(x1, Math.min(x2, x3));
        int xmax = (int)(Math.max(x1, Math.max(x2, x3)) + 0.5);
        int ymin = (int)Math.min(y1, Math.min(y2, y3));
        int ymax = (int)(Math.max(y1, Math.max(y2, y3)) + 0.5);
        block0: for (int i = xmin; i <= xmax; ++i) {
            if (i < 0) continue;
            if (i >= width) break;
            double x = 0.5 + (double)i;
            for (int j = ymin; j <= ymax; ++j) {
                if (j < 0) continue;
                if (j >= height) continue block0;
                double y = 0.5 + (double)j;
                if (!Geometry2D.isPointInTriangle(x, y, x1, y1, x2, y2, x3, y3)) continue;
                double val = -(a * x + b * y + d) / c;
                NcGridderUtils.setValue(target, i, j, val, width, height);
            }
        }
    }

    protected static void setValue(double[] array, int col, int row, double value, int width, int height) {
        if (col < 0 || col >= width) {
            return;
        }
        if (row < 0 || row >= height) {
            return;
        }
        int index = row * width + col;
        array[index] = value;
    }
}

