/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.gridder;

import gov.nasa.giss.netcdf.NcArray;
import java.awt.Dimension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NcGridder {
    private static Logger logger_ = LoggerFactory.getLogger(NcGridder.class);
    protected int gridWidth_;
    protected int gridHeight_;
    protected double lBound_;
    protected double rBound_;
    protected double tBound_;
    protected double bBound_;
    protected double[] colXX_;
    protected double[] rowYY_;

    public NcGridder() {
        this(100, 50);
    }

    public NcGridder(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridder(int w, int h) {
        this.setSize(w, h);
        this.setBounds(0.0, 0.0, 1.0, 1.0);
    }

    public void setSize(int w, int h) {
        this.gridWidth_ = w;
        this.gridHeight_ = h;
    }

    public boolean setBounds(double[] bounds) {
        return this.setBounds(bounds[0], bounds[1], bounds[2], bounds[3]);
    }

    public boolean setBounds(double l, double t, double r, double b) {
        this.lBound_ = l;
        this.tBound_ = t;
        this.rBound_ = r;
        this.bBound_ = b;
        return true;
    }

    public abstract void regridNoInterpolate(NcArray var1, double[] var2);

    public abstract void regridInterpolate(NcArray var1, double[] var2);
}

