/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array.projected;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.netcdf.NcArrayGridException;
import gov.nasa.giss.netcdf.NcArrayType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVarType;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.array.NcArrayLonLatProjectedGrid;
import java.awt.geom.Point2D;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.TransverseMercator;

public class NcArrayTransverseMercator
extends NcArrayLonLatProjectedGrid {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayTransverseMercator.class);
    private TransverseMercator unidataProj_;

    public NcArrayTransverseMercator(NcDataset dataset, String varname) throws NcException {
        super(NcArrayType.LL_TRANSVERSE_MERCATOR, dataset, varname);
        this.initMe();
    }

    public NcArrayTransverseMercator(NcVariable ncvar) throws NcException {
        super(NcArrayType.LL_TRANSVERSE_MERCATOR, ncvar);
        this.initMe();
    }

    private void initMe() {
        if (this.ncvar_.getVarType() != NcVarType.LL_TRANSVERSE_MERCATOR) {
            throw new NcArrayGridException("Variable is not transverse Mercator vartype.");
        }
        VariableDS vds = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = vds.getCoordinateSystems();
        if (csList.size() < 1) {
            throw new NcArrayGridException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (!(pj instanceof TransverseMercator)) {
            throw new NcArrayGridException("CoordinateSystem returned " + pj.getClass() + " instead of TransverseMercator");
        }
        this.unidataProj_ = (TransverseMercator)pj;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        ProjectionPointImpl xy = this.unidataProj_.latLonToProj(lat, lon);
        return new Point2D.Double(xy.x, xy.y);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        LatLonPointImpl ll = this.unidataProj_.projToLatLon(x, y);
        if (ll == null) {
            return null;
        }
        return new PointLL(ll.getLongitude(), ll.getLatitude());
    }
}

