/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array.projected;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.netcdf.NcArrayGridException;
import gov.nasa.giss.netcdf.NcArrayType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVarType;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.array.NcArrayLonLatProjectedGrid;
import java.awt.geom.Point2D;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.projection.Stereographic;

public class NcArrayStereographic
extends NcArrayLonLatProjectedGrid {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayStereographic.class);
    private static final boolean USE_UNIDATA_PROJ = false;
    private Stereographic unidataProj_;
    private double cosPhiC_ = 0.0;
    private double sinPhiC_ = 0.0;

    public NcArrayStereographic(NcDataset dataset, String varname) throws NcException {
        super(NcArrayType.LL_STEREOGRAPHIC, dataset, varname);
        this.initMe();
    }

    public NcArrayStereographic(NcVariable ncvar) throws NcException {
        super(NcArrayType.LL_STEREOGRAPHIC, ncvar);
        this.initMe();
    }

    private void initMe() {
        if (this.ncvar_.getVarType() != NcVarType.LL_STEREOGRAPHIC) {
            throw new NcArrayGridException("Variable is not stereographic vartype.");
        }
        VariableDS vds = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = vds.getCoordinateSystems();
        if (csList.size() < 1) {
            throw new NcArrayGridException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        this.initCoordinateTransform(cs);
        if (!this.mappingName_.equalsIgnoreCase("stereographic") && !this.mappingName_.equalsIgnoreCase("polar_stereographic")) {
            throw new NcArrayGridException("Mapping name is not stereographic.");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        this.cosPhiC_ = Math.cos(Math.toRadians(this.phiC_));
        this.sinPhiC_ = Math.sin(Math.toRadians(this.phiC_));
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = Math.toRadians(lon - this.lambdaC_);
        double phiRad = Math.toRadians(lat);
        double cosLambda = Math.cos(lambdaRad);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double k = 2.0 / (1.0 + this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda);
        if (k > 2.0) {
            return null;
        }
        double x = k * cosPhi * Math.sin(lambdaRad);
        double y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        return new Point2D.Double(x * this.radius_ + this.falseEasting_, y * this.radius_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        if (xx == 0.0 && yy == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double rho = Math.hypot(xx, yy);
        double z = 2.0 * Math.atan(rho * 0.5 * this.oneOverR_);
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
        double lambdaRad = Math.atan2(xx * sinZ, rho * this.cosPhiC_ * cosZ - yy * this.sinPhiC_ * sinZ);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }
}

