/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array.projected;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.netcdf.NcArrayGridException;
import gov.nasa.giss.netcdf.NcArrayType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVarType;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.array.NcArrayLonLatProjectedGrid;
import java.awt.geom.Point2D;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcArraySinusoidal
extends NcArrayLonLatProjectedGrid {
    private static Logger logger_ = LoggerFactory.getLogger(NcArraySinusoidal.class);

    public NcArraySinusoidal(NcDataset dataset, String varname) throws NcException {
        super(NcArrayType.LL_SINUSOIDAL, dataset, varname);
        this.initMe();
    }

    public NcArraySinusoidal(NcVariable ncvar) throws NcException {
        super(NcArrayType.LL_SINUSOIDAL, ncvar);
        this.initMe();
    }

    private void initMe() {
        if (this.ncvar_.getVarType() != NcVarType.LL_SINUSOIDAL) {
            throw new NcArrayGridException("Variable is not sinusoidal vartype.");
        }
        VariableDS vds = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = vds.getCoordinateSystems();
        if (csList.size() < 1) {
            throw new NcArrayGridException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        this.initCoordinateTransform(cs);
        if (!this.mappingName_.equalsIgnoreCase("sinusoidal")) {
            throw new NcArrayGridException("Mapping name is not sinusoidal.");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = Math.toRadians(lon - this.lambdaC_);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double y = phiRad;
        double x = Math.toRadians(lon) * cosPhi;
        return new Point2D.Double(x * this.radius_ + this.falseEasting_, y * this.radius_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double lambdaRad;
        double phiRad = (y - this.falseNorthing_) * this.oneOverR_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double cosPhi = Math.cos(phiRad);
        double d = lambdaRad = cosPhi == 0.0 ? 0.0 : (x - this.falseEasting_) * this.oneOverR_ / cosPhi;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

