/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array.projected;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.netcdf.NcArrayGridException;
import gov.nasa.giss.netcdf.NcArrayType;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcAxisException;
import gov.nasa.giss.netcdf.NcAxisType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVarType;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.array.NcArrayLonLatProjectedGrid;
import java.awt.geom.Point2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.VariableDS;

public class NcArrayRotatedPole
extends NcArrayLonLatProjectedGrid {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayRotatedPole.class);
    private static final double RAD_PER_DEG = Math.PI / 180;
    private static final double DEG_PER_RAD = 57.29577951308232;
    private PointLL northPole_;
    private double[][] rotY_ = new double[3][3];
    private double[][] rotZ_ = new double[3][3];

    public NcArrayRotatedPole(NcDataset dataset, String varname) throws NcException {
        super(NcArrayType.LL_ROTATED_POLE, dataset, varname);
        this.initMe();
    }

    public NcArrayRotatedPole(NcVariable ncvar) throws NcException {
        super(NcArrayType.LL_ROTATED_POLE, ncvar);
        this.initMe();
    }

    @Override
    protected void setAxes() {
        CoordinateAxis x = this.getCoordinateAxis(NcAxisType.GEOX);
        CoordinateAxis y = this.getCoordinateAxis(NcAxisType.GEOY);
        if (x == null || y == null) {
            for (int i = 0; i < this.rank_; ++i) {
                String lcname;
                Dimension d = this.varDS_.getDimension(i);
                String dname = d.getShortName();
                if (dname == null || (lcname = dname.toLowerCase()).indexOf("lon") < 0 && lcname.indexOf("lat") < 0) continue;
                VariableDS dimvar = this.getDataset().findVariable(dname);
                if (lcname.indexOf("lon") > -1) {
                    x = new CoordinateAxis1D(this.getDataset().getDataset(), dimvar);
                    x.setAxisType(AxisType.Lon);
                    continue;
                }
                y = new CoordinateAxis1D(this.getDataset().getDataset(), dimvar);
                y.setAxisType(AxisType.Lat);
            }
        }
        if (x == null) {
            throw new NcAxisException("Got null for x-axis coordinate variable");
        }
        if (y == null) {
            throw new NcAxisException("Got null for y-axis coordinate variable");
        }
        this.xAxis_ = new NcAxis(this.getDataset(), x);
        this.yAxis_ = new NcAxis(this.getDataset(), y);
        this.xDimIndex_ = this.findDimensionIndex(x);
        this.yDimIndex_ = this.findDimensionIndex(y);
        if (this.xDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of x axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of y axis");
        }
    }

    private void initMe() {
        if (this.ncvar_.getVarType() != NcVarType.LL_ROTATED_POLE) {
            throw new NcArrayGridException("Variable is not a rotated pole variable");
        }
        Attribute gm = this.varDS_.findAttributeIgnoreCase("grid_mapping");
        if (gm != null) {
            this.examineRPVariable(gm.getStringValue());
        } else {
            boolean inDims;
            boolean hasPA = this.examineAxesPoleAttributes();
            if (!hasPA && !(inDims = this.examineDimensions())) {
                throw new NcArrayGridException("Could not find pole definition");
            }
        }
        this.buildRotationMatrices();
    }

    private void examineRPVariable(String vname) {
        VariableDS rpvar = this.ncvar_.getDataset().findVariable(vname);
        if (rpvar == null) {
            throw new NcArrayGridException("Grid mapping variable is missing");
        }
        Attribute gatt = rpvar.findAttributeIgnoreCase("grid_mapping_name");
        String gname = gatt.getStringValue();
        if (!gname.equalsIgnoreCase("rotated_latitude_longitude") && !gname.equalsIgnoreCase("rotated_pole")) {
            throw new NcArrayGridException("Grid mapping variable is not rotated pole");
        }
        Attribute lon = rpvar.findAttribute("grid_north_pole_longitude");
        Attribute lat = rpvar.findAttribute("grid_north_pole_latitude");
        Attribute npo = rpvar.findAttribute("north_pole_grid_longitude");
        if (lat != null && lon != null) {
            Number lonNum = lon.getNumericValue();
            Number latNum = lat.getNumericValue();
            if (latNum == null || lonNum == null) {
                throw new NcArrayGridException("Rotated pole not defined with numerics (N)");
            }
            this.northPole_ = new PointLL(lonNum.doubleValue(), latNum.doubleValue());
        } else {
            if (lat != null || lon != null) {
                throw new NcArrayGridException("Rotated pole is ill defined (N)");
            }
            lon = rpvar.findAttribute("grid_south_pole_longitude");
            lat = rpvar.findAttribute("grid_south_pole_latitude");
            if (lat != null && lon != null) {
                Number lonNum = lon.getNumericValue();
                Number latNum = lat.getNumericValue();
                if (latNum == null || lonNum == null) {
                    throw new NcArrayGridException("Rotated pole not defined with numerics (S)");
                }
                double sPoleLon = lonNum.doubleValue();
                double sPoleLat = latNum.doubleValue();
                this.northPole_ = new PointLL(sPoleLon + 180.0, -sPoleLat);
            } else if (lat != null || lon != null) {
                throw new NcArrayGridException("Rotated pole is ill defined (S)");
            }
        }
    }

    private boolean examineAxesPoleAttributes() {
        Attribute lon = this.getXAxis().getAxis().findAttribute("grid_north_pole_longitude");
        Attribute lat = this.getYAxis().getAxis().findAttribute("grid_north_pole_latitude");
        if (lon == null) {
            lon = this.getXAxis().getAxis().findAttribute("north_pole");
        }
        if (lat == null) {
            lat = this.getYAxis().getAxis().findAttribute("north_pole");
        }
        if (lat == null || lon == null) {
            return false;
        }
        Number lonNum = lon.getNumericValue();
        Number latNum = lat.getNumericValue();
        if (latNum == null || lonNum == null) {
            throw new NcArrayGridException("Rotated pole not defined with numerics (PA)");
        }
        this.northPole_ = new PointLL(lonNum.doubleValue(), latNum.doubleValue());
        return true;
    }

    private boolean examineDimensions() {
        int rank = this.varDS_.getRank();
        String lonName = null;
        String latName = null;
        for (int i = 0; i < rank; ++i) {
            Dimension d = this.varDS_.getDimension(i);
            String dname = d.getShortName();
            if (dname == null) continue;
            String lcname = dname.toLowerCase();
            if (lcname.indexOf("lon") >= 0) {
                lonName = dname;
                continue;
            }
            if (lcname.indexOf("lat") < 0) continue;
            latName = dname;
        }
        if (lonName == null || latName == null) {
            return false;
        }
        Attribute lonA = this.getDataset().findVariable(lonName).findAttribute("long_name");
        Attribute latA = this.getDataset().findVariable(latName).findAttribute("long_name");
        if (lonA == null || latA == null) {
            return false;
        }
        if (lonA.getStringValue().indexOf("rotated") < 0 || latA.getStringValue().indexOf("rotated") < 0) {
            return false;
        }
        this.examineRPVariable("rotated_pole");
        return true;
    }

    private void buildRotationMatrices() {
        double lat = this.northPole_.getLat();
        double lon = this.northPole_.getLon();
        double betaRad = 0.0;
        double gammaRad = 0.0;
        if (lat == 90.0) {
            betaRad = 0.0;
            gammaRad = Math.toRadians(lon);
        } else {
            betaRad = -Math.toRadians(90.0 - lat);
            gammaRad = Math.toRadians(lon + 180.0);
        }
        double cosBeta = Math.cos(betaRad);
        double sinBeta = Math.sin(betaRad);
        double cosGamma = Math.cos(gammaRad);
        double sinGamma = Math.sin(gammaRad);
        this.rotY_[0][0] = cosBeta;
        this.rotY_[0][1] = 0.0;
        this.rotY_[0][2] = -sinBeta;
        this.rotY_[1][0] = 0.0;
        this.rotY_[1][1] = 1.0;
        this.rotY_[1][2] = 0.0;
        this.rotY_[2][0] = sinBeta;
        this.rotY_[2][1] = 0.0;
        this.rotY_[2][2] = cosBeta;
        this.rotZ_[0][0] = cosGamma;
        this.rotZ_[0][1] = sinGamma;
        this.rotZ_[0][2] = 0.0;
        this.rotZ_[1][0] = -sinGamma;
        this.rotZ_[1][1] = cosGamma;
        this.rotZ_[1][2] = 0.0;
        this.rotZ_[2][0] = 0.0;
        this.rotZ_[2][1] = 0.0;
        this.rotZ_[2][2] = 1.0;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        double lonRad = Math.toRadians(lon);
        double latRad = Math.toRadians(lat);
        double[] p0 = new double[]{Math.cos(latRad) * Math.cos(lonRad), Math.cos(latRad) * Math.sin(lonRad), Math.sin(latRad)};
        double[] p1 = new double[]{this.rotZ_[0][0] * p0[0] + this.rotZ_[0][1] * p0[1], this.rotZ_[1][0] * p0[0] + this.rotZ_[1][1] * p0[1], p0[2]};
        double[] p2 = new double[]{this.rotY_[0][0] * p1[0] + this.rotY_[0][2] * p1[2], p1[1], this.rotY_[2][0] * p1[0] + this.rotY_[2][2] * p1[2]};
        double lonR = NcArrayRotatedPole.normalizeLon(Math.toDegrees(Math.atan2(p2[1], p2[0])));
        double latR = Math.toDegrees(Math.asin(p2[2]));
        return new Point2D.Double(lonR, latR);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double lonR = x;
        double latR = y;
        double lonRRad = Math.toRadians(lonR);
        double latRRad = Math.toRadians(latR);
        double[] p0 = new double[]{Math.cos(latRRad) * Math.cos(lonRRad), Math.cos(latRRad) * Math.sin(lonRRad), Math.sin(latRRad)};
        double[] p1 = new double[]{this.rotY_[0][0] * p0[0] + this.rotY_[2][0] * p0[2], p0[1], this.rotY_[0][2] * p0[0] + this.rotY_[2][2] * p0[2]};
        double[] p2 = new double[]{this.rotZ_[0][0] * p1[0] + this.rotZ_[1][0] * p1[1], this.rotZ_[0][1] * p1[0] + this.rotZ_[1][1] * p1[1], p1[2]};
        double lon = Math.toDegrees(Math.atan2(p2[1], p2[0]));
        double lat = Math.toDegrees(Math.asin(p2[2]));
        return new PointLL(lon, lat);
    }
}

