/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array.projected;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.netcdf.NcArrayGridException;
import gov.nasa.giss.netcdf.NcArrayType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVarType;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.array.NcArrayLonLatProjectedGrid;
import java.awt.geom.Point2D;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.projection.Mercator;

public class NcArrayMercator
extends NcArrayLonLatProjectedGrid {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayMercator.class);
    private static final boolean USE_UNIDATA_PROJ = false;
    private static final double TINY_VALUE = 0.001;
    public static final double HALF_PI = 1.5707963267948966;
    private Mercator unidataProj_;
    private double phi1_;
    private double rS_;
    private double oneOverRS_;
    private double left_;
    private double top_;
    private double right_;
    private double bottom_;

    public NcArrayMercator(NcDataset dataset, String varname) throws NcException {
        super(NcArrayType.LL_MERCATOR, dataset, varname);
        this.initMe();
    }

    public NcArrayMercator(NcVariable ncvar) throws NcException {
        super(NcArrayType.LL_MERCATOR, ncvar);
        this.initMe();
    }

    private void initMe() {
        if (this.ncvar_.getVarType() != NcVarType.LL_MERCATOR) {
            throw new NcArrayGridException("Variable is not Mercator vartype.");
        }
        VariableDS vds = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = vds.getCoordinateSystems();
        if (csList.size() < 1) {
            throw new NcArrayGridException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        this.initCoordinateTransform(cs);
        if (!this.mappingName_.equalsIgnoreCase("mercator")) {
            throw new NcArrayGridException("Mapping name is not Mercator.");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        Attribute parallelA = this.mappingVarDS_.findAttribute("standard_parallel");
        if (parallelA == null) {
            this.phi1_ = 0.0;
            this.rS_ = this.radius_;
        } else {
            this.phi1_ = parallelA.getNumericValue().doubleValue();
            double phi1Rad = Math.toRadians(this.phi1_);
            this.rS_ = this.radius_ * Math.cos(phi1Rad);
        }
        this.oneOverRS_ = 1.0 / this.rS_;
        double[][] xBounds = this.getXAxis().getBounds();
        double[][] yBounds = this.getYAxis().getBounds();
        this.left_ = xBounds[0][0];
        this.top_ = yBounds[0][0];
        this.right_ = xBounds[xBounds.length - 1][1];
        this.bottom_ = yBounds[yBounds.length - 1][1];
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (90.0 - Math.abs(lat) < 0.001) {
            return new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        double dlon = NcArrayMercator.normalizeLon(lon - this.lambdaC_);
        double lambdaRad = Math.toRadians(dlon);
        double phiRad = Math.toRadians(lat);
        double x = lambdaRad;
        double y = Math.log(Math.tan(0.5 * (1.5707963267948966 + phiRad)));
        x = x * this.rS_ + this.falseEasting_;
        y = y * this.rS_ + this.falseNorthing_;
        if (x < this.left_) {
            x += Math.PI * 2 * this.rS_;
        }
        if (x > this.right_) {
            x -= Math.PI * 2 * this.rS_;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        double phiRad = 2.0 * Math.atan(Math.exp(yy * this.oneOverRS_)) - 1.5707963267948966;
        double lambdaRad = xx * this.oneOverRS_;
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }

    @Override
    public double[] getBounds() {
        return new double[]{this.left_, this.top_, this.right_, this.bottom_};
    }
}

