/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array.projected;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.netcdf.NcArrayGridException;
import gov.nasa.giss.netcdf.NcArrayType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVarType;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.array.NcArrayLonLatProjectedGrid;
import java.awt.geom.Point2D;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.projection.LambertConformal;

public class NcArrayLambertConformalConic
extends NcArrayLonLatProjectedGrid {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayLambertConformalConic.class);
    private static final boolean USE_UNIDATA_PROJ = false;
    private static final double PI_OVER_4 = 0.7853981633974483;
    private double phi1_ = 30.0;
    private double phi2_ = -30.0;
    private double termF_;
    private double termN_;
    private double oneOverN_;
    private double rho0_;
    private LambertConformal unidataProj_;

    public NcArrayLambertConformalConic(NcDataset dataset, String varname) throws NcException {
        super(NcArrayType.LL_LAMBERT_CONFORMAL, dataset, varname);
        this.initMe();
    }

    public NcArrayLambertConformalConic(NcVariable ncvar) throws NcException {
        super(NcArrayType.LL_LAMBERT_CONFORMAL, ncvar);
        this.initMe();
    }

    private void initMe() {
        logger_.info("");
        if (this.ncvar_.getVarType() != NcVarType.LL_LAMBERT_CONFORMAL) {
            throw new NcArrayGridException("Variable is not Lambert conformal conic vartype.");
        }
        VariableDS vds = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = vds.getCoordinateSystems();
        if (csList.size() < 1) {
            throw new NcArrayGridException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        this.initCoordinateTransform(cs);
        if (!this.mappingName_.equalsIgnoreCase("lambert_conformal_conic")) {
            throw new NcArrayGridException("Mapping name is not Lambert conformal conic.");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        Attribute parallelsA = this.mappingVarDS_.findAttribute("standard_parallel");
        if (parallelsA == null) {
            throw new NcArrayGridException("Coordinate transform variable standard parallel(s)");
        }
        if (parallelsA.isArray()) {
            Array pararray = parallelsA.getValues();
            double[] parvalues = (double[])pararray.get1DJavaArray(Double.class);
            this.phi1_ = parvalues[0];
            this.phi2_ = parvalues[1];
        } else {
            this.phi2_ = this.phi1_ = parallelsA.getNumericValue().doubleValue();
        }
        double phiCRad = Math.toRadians(this.phiC_);
        double phi1Rad = Math.toRadians(this.phi1_);
        double phi2Rad = Math.toRadians(this.phi2_);
        double cosPhi1 = Math.cos(phi1Rad);
        double cosPhi2 = Math.cos(phi2Rad);
        double tanTermC = Math.tan(0.7853981633974483 + 0.5 * phiCRad);
        double tanTerm1 = Math.tan(0.7853981633974483 + 0.5 * phi1Rad);
        double tanTerm2 = Math.tan(0.7853981633974483 + 0.5 * phi2Rad);
        this.termN_ = this.phi1_ == this.phi2_ ? Math.sin(phi1Rad) : Math.log(cosPhi1 / cosPhi2) / Math.log(tanTerm2 / tanTerm1);
        this.oneOverN_ = 1.0 / this.termN_;
        this.termF_ = cosPhi1 * Math.pow(tanTerm1, this.termN_) * this.oneOverN_;
        this.rho0_ = this.termF_ / Math.pow(tanTermC, this.termN_);
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat < 90.0 && lat > -90.0) {
            double dlon = lon - this.lambdaC_;
            if (dlon > 180.0) {
                dlon -= 360.0;
            }
            if (dlon < -180.0) {
                dlon += 360.0;
            }
            double lambdaRad = Math.toRadians(dlon);
            double phiRad = Math.toRadians(lat);
            double rho = this.termF_ / Math.pow(Math.tan(0.7853981633974483 + 0.5 * phiRad), this.termN_);
            double thetaRad = this.termN_ * lambdaRad;
            double x = rho * Math.sin(thetaRad);
            double y = this.rho0_ - rho * Math.cos(thetaRad);
            return new Point2D.Double(x * this.radius_ + this.falseEasting_, y * this.radius_ + this.falseNorthing_);
        }
        if (lat == 90.0) {
            if (this.termN_ < 0.0) {
                return null;
            }
            return new Point2D.Double(0.0, this.rho0_ * this.radius_ + this.falseNorthing_);
        }
        if (this.termN_ > 0.0) {
            return null;
        }
        return new Point2D.Double(0.0, this.rho0_ * this.radius_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double phiRad;
        double xOverR = (x - this.falseEasting_) * this.oneOverR_;
        double yOverR = (y - this.falseNorthing_) * this.oneOverR_;
        double rho0MinusYOverR = this.rho0_ - yOverR;
        double rho = Math.hypot(xOverR, rho0MinusYOverR);
        if (this.termN_ < 0.0) {
            rho = -rho;
        }
        if (Math.abs(phiRad = 2.0 * (Math.atan(Math.pow(this.termF_ / rho, this.oneOverN_)) - 0.7853981633974483)) > 1.5707963267948966) {
            return null;
        }
        double thetaRad = this.termN_ < 0.0 ? Math.atan2(-xOverR, -rho0MinusYOverR) : Math.atan2(xOverR, rho0MinusYOverR);
        double lambdaRad = thetaRad * this.oneOverN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

