/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array.projected;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.netcdf.NcArrayGridException;
import gov.nasa.giss.netcdf.NcArrayType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVarType;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.array.NcArrayLonLatProjectedGrid;
import java.awt.geom.Point2D;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.projection.AlbersEqualArea;

public class NcArrayAlbersEqualAreaConic
extends NcArrayLonLatProjectedGrid {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayAlbersEqualAreaConic.class);
    private static final boolean USE_UNIDATA_PROJ = false;
    private double phi1_ = 30.0;
    private double phi2_ = -30.0;
    private double termC_;
    private double termN_;
    private double twoN_;
    private double oneOverN_;
    private double rho0_;
    private AlbersEqualArea unidataProj_;

    public NcArrayAlbersEqualAreaConic(NcDataset dataset, String varname) throws NcException {
        super(NcArrayType.LL_ALBERS_CONIC, dataset, varname);
        this.initMe();
    }

    public NcArrayAlbersEqualAreaConic(NcVariable ncvar) throws NcException {
        super(NcArrayType.LL_ALBERS_CONIC, ncvar);
        this.initMe();
    }

    private void initMe() {
        if (this.ncvar_.getVarType() != NcVarType.LL_ALBERS_CONIC) {
            throw new NcArrayGridException("Variable is not Albers equal-area conic vartype.");
        }
        VariableDS vds = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = vds.getCoordinateSystems();
        if (csList.size() < 1) {
            throw new NcArrayGridException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        this.initCoordinateTransform(cs);
        if (!this.mappingName_.equalsIgnoreCase("albers_equal_area_conic") && !this.mappingName_.equalsIgnoreCase("albers_conical_equal_area")) {
            throw new NcArrayGridException("Mapping name is not Albers equal-area conic.");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        Attribute parallelsA = this.mappingVarDS_.findAttribute("standard_parallel");
        if (parallelsA == null) {
            throw new NcArrayGridException("Coordinate transform variable standard parallel(s)");
        }
        if (parallelsA.isArray()) {
            Array pararray = parallelsA.getValues();
            double[] parvalues = (double[])pararray.get1DJavaArray(Double.class);
            this.phi1_ = parvalues[0];
            this.phi2_ = parvalues[1];
        } else {
            this.phi2_ = this.phi1_ = parallelsA.getNumericValue().doubleValue();
        }
        double phi1Rad = Math.toRadians(this.phi1_);
        double phi2Rad = Math.toRadians(this.phi2_);
        double cosPhi1 = Math.cos(phi1Rad);
        double sinPhiC = Math.sin(Math.toRadians(this.phiC_));
        double sinPhi1 = Math.sin(phi1Rad);
        double sinPhi2 = Math.sin(phi2Rad);
        this.termN_ = 0.5 * (sinPhi1 + sinPhi2);
        this.twoN_ = 2.0 * this.termN_;
        this.oneOverN_ = 1.0 / this.termN_;
        this.termC_ = cosPhi1 * cosPhi1 + this.twoN_ * sinPhi1;
        this.rho0_ = Math.sqrt(this.termC_ - this.twoN_ * sinPhiC) * this.oneOverN_;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double dlon = lon - this.lambdaC_;
        if (dlon > 180.0) {
            dlon -= 360.0;
        }
        if (dlon < -180.0) {
            dlon += 360.0;
        }
        double lambdaRad = Math.toRadians(dlon);
        double phiRad = Math.toRadians(lat);
        double rho = Math.sqrt(this.termC_ - this.twoN_ * Math.sin(phiRad)) * this.oneOverN_;
        double theta = this.termN_ * lambdaRad;
        double x = rho * Math.sin(theta);
        double y = this.rho0_ - rho * Math.cos(theta);
        return new Point2D.Double(x * this.radius_ + this.falseEasting_, y * this.radius_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xOverR = (x - this.falseEasting_) * this.oneOverR_;
        double yOverR = (y - this.falseNorthing_) * this.oneOverR_;
        double rho0MinusYOverR = this.rho0_ - yOverR;
        double rho = Math.hypot(xOverR, rho0MinusYOverR);
        double nRho = this.termN_ * rho;
        double phiRad = Math.asin(0.5 * (this.termC_ - nRho * nRho) * this.oneOverN_);
        if (Double.isNaN(phiRad) || Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double theta = this.termN_ < 0.0 ? Math.atan2(-xOverR, -rho0MinusYOverR) : Math.atan2(xOverR, rho0MinusYOverR);
        double lambdaRad = theta * this.oneOverN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

