/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array;

import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcAxisException;
import gov.nasa.giss.netcdf.NcAxisType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcTimeAxis;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.netcdf.gridder.NcTimeLatGridder;
import gov.nasa.giss.text.PrintfFormat;
import ucar.nc2.dataset.CoordinateAxis;

public class NcArrayTimeLat
extends NcArray2D {
    public NcArrayTimeLat(NcDataset dataset, String varname) throws NcException {
        super(dataset, varname);
    }

    public NcArrayTimeLat(NcVariable ncvar) throws NcException {
        super(ncvar);
    }

    @Override
    protected void setAxes() {
        CoordinateAxis x = this.getCoordinateAxis(NcAxisType.TIME);
        CoordinateAxis y = this.getCoordinateAxis(NcAxisType.LATITUDE);
        if (x == null) {
            throw new NcAxisException("Got null for time axis coordinate variable");
        }
        if (y == null) {
            throw new NcAxisException("Got null for latitude axis coordinate variable");
        }
        this.xAxis_ = new NcTimeAxis(this.getDataset(), x);
        this.yAxis_ = new NcAxis(this.getDataset(), y);
        this.xDimIndex_ = this.findDimensionIndex(x);
        this.yDimIndex_ = this.findDimensionIndex(y);
        if (this.xDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of x axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of y axis");
        }
        CoordinateAxis a = this.getCoordinateAxis(NcAxisType.LONGITUDE);
        if (a != null) {
            this.aveDimIndex_ = this.findDimensionIndex(a);
        }
    }

    @Override
    public void describeCell(int col, int row, StringBuilder sb, PrintfFormat valFormat) {
    }

    @Override
    public NcGridder getGridder() {
        return new NcTimeLatGridder();
    }
}

