/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array;

import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcAxisException;
import gov.nasa.giss.netcdf.NcAxisType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.text.PrintfFormat;
import ucar.nc2.dataset.CoordinateAxis;

public class NcArrayLonVert
extends NcArray2D {
    private static final PrintfFormat PFORMAT_D3 = new PrintfFormat("%.3f\u00b0");

    public NcArrayLonVert(NcDataset dataset, String varname) throws NcException {
        super(dataset, varname);
    }

    public NcArrayLonVert(NcVariable ncvar) throws NcException {
        super(ncvar);
    }

    @Override
    protected void setAxes() {
        CoordinateAxis x = this.getCoordinateAxis(NcAxisType.LONGITUDE);
        CoordinateAxis y = this.getCoordinateAxis(NcAxisType.VERTICAL);
        if (x == null) {
            throw new NcAxisException("Got null for longitude axis coordinate variable");
        }
        if (y == null) {
            throw new NcAxisException("Got null for vertical axis coordinate variable");
        }
        this.xAxis_ = new NcAxis(this.getDataset(), x);
        this.yAxis_ = new NcAxis(this.getDataset(), y);
        this.xDimIndex_ = this.findDimensionIndex(x);
        this.yDimIndex_ = this.findDimensionIndex(y);
        if (this.xDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of x axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of y axis");
        }
    }

    @Override
    public void describeCell(int col, int row, StringBuilder sb, PrintfFormat valFormat) {
        if (row < 0 || col < 0) {
            sb.append("Outside Array Bounds\n");
            return;
        }
        int colDisplay = this.xAxis_.isFlipped() ? this.xAxis_.getSize() - col : col + 1;
        int rowDisplay = this.yAxis_.isFlipped() ? this.yAxis_.getSize() - row : row + 1;
        sb.append("Cell [").append(colDisplay).append(", ").append(rowDisplay).append("] at [");
        double lon = this.xAxis_.valueAt(col);
        if (lon < 0.0) {
            sb.append(PFORMAT_D3.sprintf(-lon)).append("W");
        } else {
            sb.append(PFORMAT_D3.sprintf(lon)).append("E");
        }
        double cellVert = this.yAxis_.valueAt(row);
        sb.append(", ").append(valFormat.sprintf(cellVert));
        if (this.yAxis_.getUnits() != null) {
            sb.append(" ").append(this.getYAxis().getUnits());
        }
        sb.append("], value = ");
        double value = this.valueAt(col, row);
        sb.append(valFormat.sprintf(value));
        if (this.getUnits() != null && !Double.isNaN(value)) {
            sb.append(" ").append(this.getUnits());
        }
    }

    @Override
    public NcGridder getGridder() {
        return null;
    }
}

