/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArrayGridException;
import gov.nasa.giss.netcdf.NcAxisException;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.netcdf.gridder.NcLonLatScatterGridder;
import gov.nasa.giss.text.PrintfFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatScatterNodes
extends NcArray {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayLonLatScatterNodes.class);
    private int nodeDimIndex_ = -1;
    private int numNodes_ = -1;
    private VariableDS lonVar_;
    private VariableDS latVar_;
    private Array lonArray_;
    private Array latArray_;
    private Index lonIndex_;
    private Index latIndex_;
    private double minLon_ = Double.POSITIVE_INFINITY;
    private double maxLon_ = Double.NEGATIVE_INFINITY;
    private double minLat_ = Double.POSITIVE_INFINITY;
    private double maxLat_ = Double.NEGATIVE_INFINITY;
    private int[][] closeNodes_;

    public NcArrayLonLatScatterNodes(NcDataset dataset, String varname) throws NcException {
        super(dataset, varname);
        this.initMe();
    }

    public NcArrayLonLatScatterNodes(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.initMe();
    }

    private void initMe() throws NcException {
        int j;
        int i;
        double lat;
        double lon;
        int latsize;
        List<CoordinateSystem> l = this.varDS_.getCoordinateSystems();
        if (l.size() < 1) {
            throw new NcArrayGridException("No coordinate systems found.");
        }
        CoordinateSystem cs = l.get(0);
        this.lonVar_ = cs.getLonAxis();
        this.latVar_ = cs.getLatAxis();
        if (this.lonVar_ == null) {
            throw new NcAxisException("Variable has no longitude coordinate axis");
        }
        if (this.latVar_ == null) {
            throw new NcAxisException("Variable has no latitude coordinate axis");
        }
        if (!(this.lonVar_ instanceof CoordinateAxis1D)) {
            throw new NcAxisException("Longitude coordinate axis is not 1D");
        }
        if (!(this.latVar_ instanceof CoordinateAxis1D)) {
            throw new NcAxisException("Latitude coordinate axis is not 1D");
        }
        int lonsize = this.lonVar_.getShape()[0];
        if (lonsize != (latsize = this.latVar_.getShape()[0])) {
            throw new NcAxisException("Lon and lat coordinate axes are of different lengths");
        }
        Dimension nodeDimension = this.lonVar_.getDimension(0);
        String nodeDimName = nodeDimension.getName();
        this.nodeDimIndex_ = this.varDS_.findDimensionIndex(nodeDimName);
        int[] shape = this.varDS_.getShape();
        this.numNodes_ = shape[this.nodeDimIndex_];
        try {
            this.lonArray_ = this.lonVar_.read();
            this.lonIndex_ = this.lonArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcAxisException("Could not read lon axis array");
        }
        try {
            this.latArray_ = this.latVar_.read();
            this.latIndex_ = this.latArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcAxisException("Could not read lat axis array");
        }
        for (int i2 = 0; i2 < this.numNodes_; ++i2) {
            lon = this.getLongitudeAt(i2);
            lat = this.getLatitudeAt(i2);
            if (lon > this.maxLon_) {
                this.maxLon_ = lon;
            }
            if (lon < this.minLon_) {
                this.minLon_ = lon;
            }
            if (lat > this.maxLat_) {
                this.maxLat_ = lat;
            }
            if (!(lat < this.minLat_)) continue;
            this.minLat_ = lat;
        }
        int numClose = 7;
        this.closeNodes_ = new int[this.numNodes_][7];
        double[][] distances = new double[this.numNodes_][7];
        for (i = 0; i < this.numNodes_; ++i) {
            for (j = 0; j < 7; ++j) {
                this.closeNodes_[i][j] = -1;
            }
        }
        for (i = 0; i < this.numNodes_; ++i) {
            lon = this.getLongitudeAt(i);
            lat = this.getLatitudeAt(i);
            double cosLatA = Math.cos(Math.toRadians(lat));
            double sinLatA = Math.sin(Math.toRadians(lat));
            block8: for (j = i + 1; j < this.numNodes_; ++j) {
                int kk;
                int k;
                double lonB = this.getLongitudeAt(j);
                double latBRad = Math.toRadians(this.getLatitudeAt(j));
                double dlon = lonB - lon;
                double cosLatB = Math.cos(latBRad);
                double sinLatB = Math.sin(latBRad);
                double cosdist = cosLatA * cosLatB * Math.cos(dlon) + sinLatA * sinLatB;
                double distance = 1.0 - cosdist;
                for (k = 0; k < 7; ++k) {
                    if (this.closeNodes_[i][k] < 0) {
                        this.closeNodes_[i][k] = j;
                        distances[i][k] = distance;
                        break;
                    }
                    if (!(distance < distances[i][k])) continue;
                    for (kk = 6; kk > k; --kk) {
                        this.closeNodes_[i][kk] = this.closeNodes_[i][kk - 1];
                        distances[i][kk] = distances[i][kk - 1];
                    }
                    this.closeNodes_[i][k] = j;
                    distances[i][k] = distance;
                    break;
                }
                for (k = 0; k < 7; ++k) {
                    if (this.closeNodes_[j][k] < 0) {
                        this.closeNodes_[j][k] = i;
                        distances[j][k] = distance;
                        continue block8;
                    }
                    if (!(distance < distances[j][k])) continue;
                    for (kk = 6; kk > k; --kk) {
                        this.closeNodes_[j][kk] = this.closeNodes_[j][kk - 1];
                        distances[j][kk] = distances[j][kk - 1];
                    }
                    this.closeNodes_[j][k] = i;
                    distances[j][k] = distance;
                    continue block8;
                }
            }
        }
    }

    @Override
    protected void createDimensions() {
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.nodeDimIndex_ ? null : this.ncvar_.getDimension(i);
        }
    }

    public double getMinimumLon() {
        return this.minLon_;
    }

    public double getMaximumLon() {
        return this.maxLon_;
    }

    public double getMinimumLat() {
        return this.minLat_;
    }

    public double getMaximumLat() {
        return this.maxLat_;
    }

    public void describeNode(int node, StringBuilder sb, PrintfFormat valFormat, PrintfFormat degFormat) {
        if (node < 0) {
            sb.append("Point outside data bounds");
            return;
        }
        sb.append("Node ").append("[").append(node).append("]");
        sb.append(" at [");
        double lon = this.getLongitudeAt(node);
        double lat = this.getLatitudeAt(node);
        if (lon < 0.0) {
            sb.append(degFormat.sprintf(-lon)).append("W ");
        } else {
            sb.append(degFormat.sprintf(lon)).append("E ");
        }
        if (lat < 0.0) {
            sb.append(degFormat.sprintf(-lat)).append("S");
        } else {
            sb.append(degFormat.sprintf(lat)).append("N");
        }
        sb.append("]");
        double value = this.valueAt(node);
        sb.append(valFormat.sprintf(value));
        if (this.getUnits() != null && !Double.isNaN(value)) {
            sb.append(" ").append(this.getUnits());
        }
    }

    public double getLongitudeAt(int node) {
        return this.lonArray_.getDouble(this.lonIndex_.set(node));
    }

    public double getLatitudeAt(int node) {
        return this.latArray_.getDouble(this.latIndex_.set(node));
    }

    public PointLL getLonLatAt(int node) {
        return new PointLL(this.getLongitudeAt(node), this.getLatitudeAt(node));
    }

    public double valueAt(int node) {
        if (node < 0 || node >= this.numNodes_) {
            throw new IllegalArgumentException("Node index out of range: " + node + " : " + this.numNodes_);
        }
        try {
            if (this.needsSlice_) {
                this.doSlice();
            }
        }
        catch (NcException exc) {
            throw exc;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new NcException("NcArrayScatterNodes.valueAt -- " + exc.toString());
        }
        try {
            return this.slice_.getDouble(this.slice_.getIndex().set(node));
        }
        catch (Exception exc) {
            logger_.error("node = " + node);
            logger_.error("rank " + this.slice_.getRank());
            exc.printStackTrace();
            throw new NcException("NcArrayScatterNodes.valueAt -- " + exc.toString());
        }
    }

    public int getNodeCount() {
        return this.numNodes_;
    }

    private synchronized void doSlice() throws NcException {
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        try {
            int i;
            this.needsSlice_ = true;
            for (i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.nodeDimIndex_] = 0;
            sShape[this.nodeDimIndex_] = this.numNodes_;
            this.slice_ = this.varDS_.read(sOrigin, sShape);
            for (i = this.rank_ - 1; i >= 0; --i) {
                if (i == this.nodeDimIndex_) continue;
                this.slice_ = this.slice_.reduce(i);
            }
            this.needsSlice_ = false;
            this.findExtrema();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new NcException("NcArrayScatterNodes.doSlice -- " + exc.toString());
        }
    }

    @Override
    protected void findExtrema() {
        int imax = this.numNodes_;
        this.minimum_ = Double.POSITIVE_INFINITY;
        this.maximum_ = Double.NEGATIVE_INFINITY;
        try {
            for (int i = 0; i < this.numNodes_; ++i) {
                double value = this.valueAt(i);
                if (Double.isNaN(value) || this.isMissingOrInvalid(value)) continue;
                if (this.maximum_ < this.minimum_) {
                    this.minimum_ = value;
                    this.maximum_ = value;
                    continue;
                }
                if (value < this.minimum_) {
                    this.minimum_ = value;
                    continue;
                }
                if (!(value > this.maximum_)) continue;
                this.maximum_ = value;
            }
        }
        catch (Exception exc) {
            logger_.error(exc.toString());
        }
    }

    public int[] getClosestNodes(int node) {
        return this.closeNodes_[node];
    }

    public int findClosestNode(double lon, double lat) {
        double cosLatA = Math.cos(Math.toRadians(lat));
        double sinLatA = Math.sin(Math.toRadians(lat));
        double mindist = Double.POSITIVE_INFINITY;
        int node = -1;
        for (int i = 0; i < this.numNodes_; ++i) {
            double lonB = this.getLongitudeAt(i);
            double latBRad = Math.toRadians(this.getLatitudeAt(i));
            double dlon = lonB - lon;
            double cosLatB = Math.cos(latBRad);
            double sinLatB = Math.sin(latBRad);
            double cosdist = cosLatA * cosLatB * Math.cos(dlon) + sinLatA * sinLatB;
            double distance = 1.0 - cosdist;
            if (distance == 0.0) {
                return i;
            }
            if (!(distance < mindist)) continue;
            mindist = distance;
            node = i;
        }
        return node;
    }

    @Override
    public NcGridder getGridder() {
        return new NcLonLatScatterGridder();
    }
}

