/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.math.Geometry2D;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcAxisException;
import gov.nasa.giss.netcdf.NcAxisType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.netcdf.gridder.NcLonLatReducedType2Gridder;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Point;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayShort;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatReducedType2
extends NcArray {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayLonLatReducedType2.class);
    private static final PrintfFormat PFORMAT_D3 = new PrintfFormat("%.3f\u00b0");
    private static final double RAD_PER_DEG = Math.PI / 180;
    private static final double DEG_PER_RAD = 57.29577951308232;
    private static final double TINY_VALUE = 0.001;
    private VariableDS dimVar_;
    private CoordinateAxis lonVar_;
    private CoordinateAxis latVar_;
    protected NcAxis xAxis_;
    protected NcAxis yAxis_;
    private Array lonArray_;
    private Array latArray_;
    private Index lonIndex_;
    private Index latIndex_;
    private boolean hasBounds_;
    private VariableDS lonBoundsVar_;
    private VariableDS latBoundsVar_;
    private Array lonBoundsArray_;
    private Array latBoundsArray_;
    private Index lonBoundsIndex_;
    private Index latBoundsIndex_;
    private int bdsCornerDimNum_ = -1;
    private int numReducePts_ = -1;
    private int numXs_;
    private int numYs_;
    private int reduceDimIndex_ = -1;
    private int[][] expandIndices_;
    private boolean rankMismatch_;

    public NcArrayLonLatReducedType2(NcDataset dataset, String varname) throws NcException {
        super(dataset, varname);
        this.initMe();
    }

    public NcArrayLonLatReducedType2(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.initMe();
    }

    private void initMe() {
        List<CoordinateSystem> l = this.varDS_.getCoordinateSystems();
        if (l == null || l.size() < 1) {
            throw new RuntimeException("No coordinate systems");
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            throw new RuntimeException("No coordinate system");
        }
        this.lonVar_ = cs.getLonAxis();
        this.latVar_ = cs.getLatAxis();
        if (this.lonVar_ == null || this.latVar_ == null) {
            throw new RuntimeException("No coordinate system");
        }
        if (!(this.lonVar_ instanceof CoordinateAxis2D)) {
            throw new NcAxisException("Lon axis not 2D");
        }
        if (!(this.latVar_ instanceof CoordinateAxis2D)) {
            throw new NcAxisException("Lat axis not 2D");
        }
        int[] lonshape = this.lonVar_.getShape();
        int[] latshape = this.latVar_.getShape();
        if (lonshape.length != 2) {
            throw new NcAxisException("Bad lon axis shape");
        }
        if (latshape.length != 2) {
            throw new NcAxisException("Bad lat axis shape");
        }
        Dimension dim11 = this.lonVar_.getDimension(0);
        Dimension dim12 = this.lonVar_.getDimension(1);
        Dimension dim21 = this.latVar_.getDimension(0);
        Dimension dim22 = this.latVar_.getDimension(1);
        if (!dim11.equals(dim21)) {
            throw new NcAxisException("Dimension mismatch");
        }
        if (!dim12.equals(dim22)) {
            throw new NcAxisException("Dimension mismatch");
        }
        int rank = this.varDS_.getRank();
        boolean found = false;
        for (int i = 0; i < rank; ++i) {
            String compress;
            String[] tokens;
            Dimension d = this.varDS_.getDimension(i);
            String dname = d.getFullName();
            if (dname == null) continue;
            this.dimVar_ = this.dataset_.findVariable(dname);
            Attribute compressA = this.dimVar_.findAttribute("compress");
            if (compressA == null || (tokens = (compress = compressA.getStringValue()).split(" ")).length != 2) continue;
            Dimension dd1 = this.dataset_.findDimension(tokens[0]);
            Dimension dd2 = this.dataset_.findDimension(tokens[1]);
            if (!dim11.equals(dd1) || !dim12.equals(dd2)) continue;
            this.reduceDimIndex_ = i;
            break;
        }
        if (this.reduceDimIndex_ < 0) {
            throw new RuntimeException("Could not find reduction dimensions");
        }
        try {
            this.lonArray_ = this.lonVar_.read();
            this.lonIndex_ = this.lonArray_.getIndex();
            int vrank = this.lonVar_.getRank();
            int arank = this.lonArray_.getRank();
            int irank = this.lonIndex_.getRank();
            if (vrank != arank && arank == vrank + 1 && arank == irank) {
                this.rankMismatch_ = true;
            }
        }
        catch (Exception exc) {
            throw new NcAxisException("Could not read lon axis array");
        }
        try {
            this.latArray_ = this.latVar_.read();
            this.latIndex_ = this.latArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcAxisException("Could not read lat axis array");
        }
        int[] shape = this.lonArray_.getShape();
        this.numXs_ = shape[0];
        this.numYs_ = shape[1];
        this.xAxis_ = new NcAxis(NcAxisType.GEOX, dim11.getName(), this.numXs_);
        this.yAxis_ = new NcAxis(NcAxisType.GEOY, dim12.getName(), this.numYs_);
        this.expandIndices_ = new int[this.numXs_][this.numYs_];
        for (int jj = 0; jj < this.numYs_; ++jj) {
            for (int ii = 0; ii < this.numXs_; ++ii) {
                this.expandIndices_[ii][jj] = -1;
            }
        }
        try {
            Array dimArray = this.dimVar_.read();
            this.numReducePts_ = (int)dimArray.getSize();
            int i = 0;
            while (i < this.numReducePts_) {
                int index = dimArray.getInt(i);
                int x = index / this.numYs_;
                int y = index - x * this.numYs_;
                this.expandIndices_[x][y] = i++;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new NcException("Could not prepare expansion array");
        }
        String lonBoundsName_ = null;
        String latBoundsName_ = null;
        try {
            lonBoundsName_ = this.lonVar_.findAttribute("bounds").getStringValue();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            latBoundsName_ = this.latVar_.findAttribute("bounds").getStringValue();
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (lonBoundsName_ == null || latBoundsName_ == null) {
            logger_.warn("Bounds name is null");
            return;
        }
        NcDataset dataset = this.getDataset();
        this.lonBoundsVar_ = dataset.findVariable(lonBoundsName_);
        this.latBoundsVar_ = dataset.findVariable(latBoundsName_);
        if (this.lonBoundsVar_ == null || this.latBoundsVar_ == null) {
            logger_.warn("Auxiliary coordinates have bounds names but no bounds vars");
            return;
        }
        if (this.lonBoundsVar_.getRank() != 3) {
            logger_.warn("Lon bounds var does not have rank 3");
            return;
        }
        if (this.latBoundsVar_.getRank() != 3) {
            logger_.warn("Lat bounds var does not have rank 3");
            return;
        }
        int[] bShape = this.lonBoundsVar_.getShape();
        if (bShape[0] == 4) {
            this.bdsCornerDimNum_ = 0;
            if (bShape[1] != shape[0] || bShape[2] != shape[1]) {
                logger_.warn("Lon bounds var has wrong shape (C).");
                return;
            }
        } else if (bShape[2] == 4) {
            this.bdsCornerDimNum_ = 2;
            if (bShape[0] != shape[0] || bShape[1] != shape[1]) {
                logger_.warn("Lon bounds var has wrong shape (D).");
                return;
            }
        } else {
            logger_.warn("bdsCornerDimNum_ == 1?");
        }
        bShape = this.latBoundsVar_.getShape();
        if (this.bdsCornerDimNum_ == 0) {
            if (bShape[1] != shape[0] || bShape[2] != shape[1]) {
                logger_.warn("Lat bounds var has wrong shape (E).");
                return;
            }
        } else if (bShape[0] != shape[0] || bShape[1] != shape[1]) {
            logger_.warn("Lat bounds var has wrong shape (F).");
            return;
        }
        try {
            this.lonBoundsArray_ = this.lonBoundsVar_.read();
            this.lonBoundsIndex_ = this.lonBoundsArray_.getIndex();
        }
        catch (Exception exc) {
            logger_.warn("Could not read lon axis bounds array");
            return;
        }
        try {
            this.latBoundsArray_ = this.latBoundsVar_.read();
            this.latBoundsIndex_ = this.latBoundsArray_.getIndex();
        }
        catch (Exception exc) {
            logger_.warn("Could not read lat axis bounds array");
            return;
        }
        this.hasBounds_ = true;
    }

    public NcAxis getXAxis() {
        return this.xAxis_;
    }

    public NcAxis getYAxis() {
        return this.yAxis_;
    }

    @Override
    protected void createDimensions() {
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.reduceDimIndex_ ? null : this.ncvar_.getDimension(i);
        }
    }

    @Override
    protected void findExtrema() {
        double[] range = this.getActualRange();
        if (range != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        this.minimum_ = Double.POSITIVE_INFINITY;
        this.maximum_ = Double.NEGATIVE_INFINITY;
        try {
            for (int i = 0; i < this.numReducePts_; ++i) {
                double value = this.valueAt(i);
                if (Double.isNaN(value) || this.isMissingOrInvalid(value)) continue;
                if (this.maximum_ < this.minimum_) {
                    this.minimum_ = value;
                    this.maximum_ = value;
                    continue;
                }
                if (value < this.minimum_) {
                    this.minimum_ = value;
                    continue;
                }
                if (!(value > this.maximum_)) continue;
                this.maximum_ = value;
            }
        }
        catch (Exception exc) {
            logger_.error(exc.toString());
        }
        if (Double.isInfinite(this.minimum_)) {
            this.minimum_ = Double.NaN;
            this.maximum_ = Double.NaN;
        }
        this.needsExtrema_ = false;
    }

    public double valueAt(int index) {
        if (index < 0 || index >= this.numReducePts_) {
            throw new IllegalArgumentException("Index out of range: " + index + ", " + this.numReducePts_);
        }
        try {
            return this.getDoubleFromSlice(index);
        }
        catch (Exception exc) {
            logger_.error("Slice getDouble failed -  index = {}.{}", (Object)index);
            exc.printStackTrace();
            throw new NcException(exc.toString());
        }
    }

    public double valueAt(int col, int row) {
        try {
            if (this.expandIndices_[col][row] < 0) {
                return Double.NaN;
            }
            return this.getDoubleFromSlice(this.expandIndices_[col][row]);
        }
        catch (Exception exc) {
            return -1.0;
        }
    }

    private double getDoubleFromSlice(int index) {
        if (this.needsSlice_) {
            this.doSlice();
        }
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.reduceDimIndex_] = index;
        this.sliceIdx_.set(ss);
        if (!this.hasScaleOffset_) {
            if (this.slice_ instanceof ArrayByte) {
                long v = this.slice_.getByte(this.sliceIdx_);
                if (this.isUnsigned_ && v < 0L) {
                    v += 256L;
                }
                return v;
            }
            if (this.slice_ instanceof ArrayShort) {
                long v = this.slice_.getShort(this.sliceIdx_);
                if (this.isUnsigned_ && v < 0L) {
                    v += 65536L;
                }
                return v;
            }
            if (this.slice_ instanceof ArrayInt) {
                long v = this.slice_.getInt(this.sliceIdx_);
                if (this.isUnsigned_ && v < 0L) {
                    v += 0x100000000L;
                }
                return v;
            }
        }
        return this.slice_.getDouble(this.sliceIdx_);
    }

    private synchronized void doSlice() throws NcException {
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        try {
            this.needsSlice_ = true;
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.reduceDimIndex_] = 0;
            sShape[this.reduceDimIndex_] = this.numReducePts_;
            this.slice_ = this.varDS_.read(sOrigin, sShape);
            this.sliceIdx_ = this.slice_.getIndex();
            this.needsSlice_ = false;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new NcException("Do Slice - " + exc.toString());
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcLonLatReducedType2Gridder();
    }

    public double getLongitudeAt(int col, int row) {
        if (this.rankMismatch_) {
            return this.lonArray_.getDouble(this.lonIndex_.set(0, col, row));
        }
        return this.lonArray_.getDouble(this.lonIndex_.set(col, row));
    }

    public double getLatitudeAt(int col, int row) {
        double d = this.rankMismatch_ ? this.latArray_.getDouble(this.latIndex_.set(0, col, row)) : this.latArray_.getDouble(this.latIndex_.set(col, row));
        if (Math.abs(d) > 90.0) {
            return Double.NaN;
        }
        return d;
    }

    public PointLL getLonLatAt(int col, int row) {
        if (col < 0 || row < 0 || col >= this.numXs_ || row >= this.numYs_) {
            return null;
        }
        return new PointLL(this.getLongitudeAt(col, row), this.getLatitudeAt(col, row));
    }

    public boolean doCellsShareSide(int col1, int row1, int col2, int row2) {
        double[][] cx1 = this.getCellCornerLonLats(col1, row1);
        double[][] cx2 = this.getCellCornerLonLats(col2, row2);
        if (cx1 == null) {
            return false;
        }
        if (cx2 == null) {
            return false;
        }
        double lon11 = cx1[0][0];
        double lon12 = cx1[1][0];
        double lon13 = cx1[2][0];
        double lon14 = cx1[3][0];
        double lon21 = cx2[0][0];
        double lon22 = cx2[1][0];
        double lon23 = cx2[2][0];
        double lon24 = cx2[3][0];
        if (lon21 - 90.0 > lon11) {
            lon21 -= 360.0;
            lon22 -= 360.0;
            lon23 -= 360.0;
            lon24 -= 360.0;
        } else if (lon11 - 90.0 > lon21) {
            lon21 += 360.0;
            lon22 += 360.0;
            lon23 += 360.0;
            lon24 += 360.0;
        }
        if (Math.abs(lon11 - lon21) > 30.0) {
            return false;
        }
        double lat11 = cx1[0][1];
        double lat12 = cx1[1][1];
        double lat13 = cx1[2][1];
        double lat14 = cx1[3][1];
        double lat21 = cx2[0][1];
        double lat22 = cx2[1][1];
        double lat23 = cx2[2][1];
        double lat24 = cx2[3][1];
        double eps = 0.001 * Math.max(Math.abs(lon11 - 0.25 * (lon11 + lon12 + lon13 + lon14)), Math.abs(lat11 - 0.25 * (lat11 + lat12 + lat13 + lat14)));
        if (this.dequals(lon11, lon22, eps) && this.dequals(lat11, lat22, eps) && this.dequals(lon14, lon23, eps) && this.dequals(lat14, lat23, eps)) {
            return true;
        }
        if (this.dequals(lon11, lon24, eps) && this.dequals(lat11, lat24, eps) && this.dequals(lon12, lon23, eps) && this.dequals(lat12, lat23, eps)) {
            return true;
        }
        if (this.dequals(lon13, lon22, eps) && this.dequals(lat13, lat22, eps) && this.dequals(lon14, lon21, eps) && this.dequals(lat14, lat21, eps)) {
            return true;
        }
        return this.dequals(lon13, lon24, eps) && this.dequals(lat13, lat24, eps) && this.dequals(lon12, lon21, eps) && this.dequals(lat12, lat21, eps);
    }

    private boolean dequals(double a, double b, double eps) {
        return Math.abs(a - b) < eps;
    }

    public boolean doCellShareCorner(int col1, int row1, int col2, int row2) {
        double[][] b1 = this.getCellCornerLonLats(col1, row1);
        double[][] b2 = this.getCellCornerLonLats(col2, row2);
        if (b1 == null || b2 == null) {
            return false;
        }
        double tolerance = 0.25 * Math.max(Math.max(Math.abs(b1[0][0] - b1[2][0]), Math.abs(b1[0][1] - b1[2][1])), Math.max(Math.abs(b1[1][0] - b1[2][0]), Math.abs(b1[1][1] - b1[2][1])));
        int match1 = -1;
        int match2 = -1;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double absDiff = Math.abs(b1[i][0] - b2[j][0]);
                if (!(absDiff < tolerance) && !(Math.abs(absDiff - 360.0) < tolerance) || !(Math.abs(b1[i][1] - b2[j][1]) < tolerance)) continue;
                return true;
            }
        }
        return false;
    }

    public double[][] getCellCornerLonLats(int col, int row) {
        if (this.hasBounds_) {
            return this.getCellCornersFromBounds(col, row);
        }
        return this.estimateCellCornersFor(col, row);
    }

    private double[][] getCellCornersFromBounds(int col, int row) {
        double lon0 = this.getLongitudeAt(col, row);
        double lat0 = this.getLatitudeAt(col, row);
        if (lon0 > 180.0) {
            lon0 -= 360.0;
        } else if (lon0 < -180.0) {
            lon0 += 360.0;
        }
        if (this.lonVar_.isMissing(lon0) || this.latVar_.isMissing(lat0)) {
            return null;
        }
        double lon1 = this.cornerLonAt(col, row, 0);
        double lon2 = this.cornerLonAt(col, row, 1);
        double lon3 = this.cornerLonAt(col, row, 2);
        double lon4 = this.cornerLonAt(col, row, 3);
        if (this.lonBoundsVar_.isMissing(lon1) && this.lonBoundsVar_.isMissing(lon2) && this.lonBoundsVar_.isMissing(lon3) && this.lonBoundsVar_.isMissing(lon4)) {
            return null;
        }
        if (this.lonVar_.isMissing(lon1)) {
            lon1 = lon0;
        }
        if (this.lonVar_.isMissing(lon2)) {
            lon2 = lon0;
        }
        if (this.lonVar_.isMissing(lon3)) {
            lon3 = lon0;
        }
        if (this.lonVar_.isMissing(lon4)) {
            lon4 = lon0;
        }
        while (lon0 - lon1 > 45.0) {
            lon1 += 360.0;
        }
        while (lon0 - lon2 > 45.0) {
            lon2 += 360.0;
        }
        while (lon0 - lon3 > 45.0) {
            lon3 += 360.0;
        }
        while (lon0 - lon4 > 45.0) {
            lon4 += 360.0;
        }
        while (lon1 - lon0 > 45.0) {
            lon1 -= 360.0;
        }
        while (lon2 - lon0 > 45.0) {
            lon2 -= 360.0;
        }
        while (lon3 - lon0 > 45.0) {
            lon3 -= 360.0;
        }
        while (lon4 - lon0 > 45.0) {
            lon4 -= 360.0;
        }
        double lat1 = this.cornerLatAt(col, row, 0);
        double lat2 = this.cornerLatAt(col, row, 1);
        double lat3 = this.cornerLatAt(col, row, 2);
        double lat4 = this.cornerLatAt(col, row, 3);
        if (this.latBoundsVar_.isMissing(lat1)) {
            lat1 = lat0;
        }
        if (this.latBoundsVar_.isMissing(lat2)) {
            lat2 = lat0;
        }
        if (this.latBoundsVar_.isMissing(lat3)) {
            lat3 = lat0;
        }
        if (this.latBoundsVar_.isMissing(lat4)) {
            lat4 = lat0;
        }
        return new double[][]{{lon1, lat1}, {lon2, lat2}, {lon3, lat3}, {lon4, lat4}};
    }

    private double cornerLonAt(int col, int row, int corner) {
        if (this.bdsCornerDimNum_ == 0) {
            return this.lonBoundsArray_.getDouble(this.lonBoundsIndex_.set(corner, col, row));
        }
        if (this.bdsCornerDimNum_ == 2) {
            return this.lonBoundsArray_.getDouble(this.lonBoundsIndex_.set(col, row, corner));
        }
        throw new RuntimeException("ERROR: cornerLonAt failed");
    }

    private double cornerLatAt(int col, int row, int corner) {
        if (this.bdsCornerDimNum_ == 0) {
            return this.latBoundsArray_.getDouble(this.latBoundsIndex_.set(corner, col, row));
        }
        if (this.bdsCornerDimNum_ == 2) {
            return this.latBoundsArray_.getDouble(this.latBoundsIndex_.set(col, row, corner));
        }
        throw new RuntimeException("ERROR: cornerLatAt failed");
    }

    private double[][] estimateCellCornersFor(int col, int row) {
        int i = col;
        int j = row;
        double lon00 = this.getLongitudeAt(col, row);
        double lat00 = this.getLatitudeAt(col, row);
        if (lon00 > 180.0) {
            lon00 -= 360.0;
        } else if (lon00 < -180.0) {
            lon00 += 360.0;
        }
        int im1 = Math.max(i - 1, 0);
        int ip1 = Math.min(i + 1, this.numXs_ - 1);
        int jm1 = Math.max(j - 1, 0);
        int jp1 = Math.min(j + 1, this.numYs_ - 1);
        double lonMM = this.getLongitudeAt(im1, jm1);
        double lon0M = this.getLongitudeAt(i, jm1);
        double lonPM = this.getLongitudeAt(ip1, jm1);
        double lonP0 = this.getLongitudeAt(ip1, j);
        double lonPP = this.getLongitudeAt(ip1, jp1);
        double lon0P = this.getLongitudeAt(i, jp1);
        double lonMP = this.getLongitudeAt(im1, jp1);
        double lonM0 = this.getLongitudeAt(im1, j);
        double latMM = this.getLatitudeAt(im1, jm1);
        double lat0M = this.getLatitudeAt(i, jm1);
        double latPM = this.getLatitudeAt(ip1, jm1);
        double latP0 = this.getLatitudeAt(ip1, j);
        double latPP = this.getLatitudeAt(ip1, jp1);
        double lat0P = this.getLatitudeAt(i, jp1);
        double latMP = this.getLatitudeAt(im1, jp1);
        double latM0 = this.getLatitudeAt(im1, j);
        while (lon00 - lonMM > 45.0) {
            lonMM += 360.0;
        }
        while (lon00 - lon0M > 45.0) {
            lon0M += 360.0;
        }
        while (lon00 - lonPM > 45.0) {
            lonPM += 360.0;
        }
        while (lon00 - lonP0 > 45.0) {
            lonP0 += 360.0;
        }
        while (lon00 - lonPP > 45.0) {
            lonPP += 360.0;
        }
        while (lon00 - lon0P > 45.0) {
            lon0P += 360.0;
        }
        while (lon00 - lonMP > 45.0) {
            lonMP += 360.0;
        }
        while (lon00 - lonM0 > 45.0) {
            lonM0 += 360.0;
        }
        while (lonMM - lon00 > 45.0) {
            lonMM -= 360.0;
        }
        while (lon0M - lon00 > 45.0) {
            lon0M -= 360.0;
        }
        while (lonPM - lon00 > 45.0) {
            lonPM -= 360.0;
        }
        while (lonP0 - lon00 > 45.0) {
            lonP0 -= 360.0;
        }
        while (lonPP - lon00 > 45.0) {
            lonPP -= 360.0;
        }
        while (lon0P - lon00 > 45.0) {
            lon0P -= 360.0;
        }
        while (lonMP - lon00 > 45.0) {
            lonMP -= 360.0;
        }
        while (lonM0 - lon00 > 45.0) {
            lonM0 -= 360.0;
        }
        if (lonM0 == lon00 && latM0 == lat00) {
            lonMM = lon0M - (lonPM - lon0M);
            latMM = lat0M - (latPM - lat0M);
            lonM0 = lon00 - (lonP0 - lon00);
            latM0 = lat00 - (latP0 - lat00);
            lonMP = lon0P - (lonPP - lon0P);
            latMP = lat0P - (latPP - lat0P);
        } else if (lonP0 == lon00 && latP0 == lat00) {
            lonPM = lon0M + (lon0M - lonMM);
            latPM = lat0M + (lat0M - latMM);
            lonP0 = lon00 + (lon00 - lonM0);
            latP0 = lat00 + (lat00 - latM0);
            lonPP = lon0P + (lon0P - lonMP);
            latPP = lat0P + (lat0P - latMP);
        }
        if (lon0M == lon00 && lat0M == lat00) {
            lonMM = lonM0 - (lonMP - lonM0);
            latMM = latM0 - (latMP - latM0);
            lon0M = lon00 - (lon0P - lon00);
            lat0M = lat00 - (lat0P - lat00);
            lonPM = lonP0 - (lonPP - lonP0);
            latPM = latP0 - (latPP - latP0);
        } else if (lon0P == lon00 && lat0P == lat00) {
            lonMP = lonM0 + (lonM0 - lonMM);
            latMP = latM0 + (latM0 - latMM);
            lon0P = lon00 + (lon00 - lon0M);
            lat0P = lat00 + (lat00 - lat0M);
            lonPP = lonP0 + (lonP0 - lonPM);
            latPP = latP0 + (latP0 - latPM);
        }
        double[] cornerMM = this.aveFour(lon00, lat00, lon0M, lat0M, lonMM, latMM, lonM0, latM0);
        double[] cornerPM = this.aveFour(lon00, lat00, lon0M, lat0M, lonPM, latPM, lonP0, latP0);
        double[] cornerPP = this.aveFour(lon00, lat00, lon0P, lat0P, lonPP, latPP, lonP0, latP0);
        double[] cornerMP = this.aveFour(lon00, lat00, lon0P, lat0P, lonMP, latMP, lonM0, latM0);
        return new double[][]{cornerMM, cornerPM, cornerPP, cornerMP};
    }

    private double[] aveFour(double lon1, double lat1, double lon2, double lat2, double lon3, double lat3, double lon4, double lat4) {
        boolean good4;
        boolean good2 = !Double.isNaN(lat2) && !this.latVar_.isMissing(lat2);
        boolean good3 = !Double.isNaN(lat3) && !this.latVar_.isMissing(lat3);
        boolean bl = good4 = !Double.isNaN(lat4) && !this.latVar_.isMissing(lat4);
        if (good2 && good3 && good4) {
            return new double[]{0.25 * (lon1 + lon2 + lon3 + lon4), 0.25 * (lat1 + lat2 + lat3 + lat4)};
        }
        if (good2 && good3) {
            return new double[]{0.5 * (lon1 + lon3), 0.5 * (lat1 + lat3)};
        }
        if (good3 && good4) {
            return new double[]{0.5 * (lon1 + lon3), 0.5 * (lat1 + lat3)};
        }
        if (good2 && good4) {
            return new double[]{0.5 * (lon2 + lon4), 0.5 * (lat2 + lat4)};
        }
        if (good2) {
            return new double[]{0.5 * (lon1 + lon2), 0.5 * (lat1 + lat2)};
        }
        if (good4) {
            return new double[]{0.5 * (lon1 + lon4), 0.5 * (lat1 + lat4)};
        }
        if (good3) {
            return new double[]{lon1, lat1};
        }
        return new double[]{lon1, lat1};
    }

    public Point findClosestPoint(double lon, double lat) {
        double latD;
        double lonD;
        double latC;
        double lonC;
        double latB;
        double lonB;
        double latA;
        double lonA;
        double mindist = Double.POSITIVE_INFINITY;
        double cosLat = Math.cos(lat * (Math.PI / 180));
        double sinLat = Math.sin(lat * (Math.PI / 180));
        int col = -1;
        int row = -1;
        for (int i = 0; i < this.numXs_; ++i) {
            for (int j = 0; j < this.numYs_; ++j) {
                double lat1;
                double lon1;
                try {
                    lon1 = this.getLongitudeAt(i, j);
                    lat1 = this.getLatitudeAt(i, j);
                }
                catch (Exception exc) {
                    continue;
                }
                if (Double.isNaN(lon1) || Double.isNaN(lat1)) continue;
                double dlon = lon1 - lon;
                double cosLat1 = Math.cos(lat1 * (Math.PI / 180));
                double sinLat1 = Math.sin(lat1 * (Math.PI / 180));
                double cosAngle = cosLat * cosLat1 * Math.cos(dlon * (Math.PI / 180)) + sinLat * sinLat1;
                double angle = Math.acos(cosAngle);
                if (angle == 0.0) {
                    return new Point(i, j);
                }
                if (!(angle < mindist)) continue;
                mindist = angle;
                col = i;
                row = j;
            }
        }
        if (col < 0) {
            return null;
        }
        double lon0 = this.getLongitudeAt(col, row);
        double lat0 = this.getLatitudeAt(col, row);
        try {
            lonA = this.getLongitudeAt(col - 1, row);
            latA = this.getLatitudeAt(col - 1, row);
        }
        catch (Exception exc) {
            lonA = lon0;
            latA = lon0;
        }
        try {
            lonB = this.getLongitudeAt(col, row - 1);
            latB = this.getLatitudeAt(col, row - 1);
        }
        catch (Exception exc) {
            lonB = lon0;
            latB = lon0;
        }
        try {
            lonC = this.getLongitudeAt(col + 1, row);
            latC = this.getLatitudeAt(col + 1, row);
        }
        catch (Exception exc) {
            lonC = lon0;
            latC = lon0;
        }
        try {
            lonD = this.getLongitudeAt(col, row + 1);
            latD = this.getLatitudeAt(col, row + 1);
        }
        catch (Exception exc) {
            lonD = lon0;
            latD = lon0;
        }
        if (Geometry2D.isPointInQuadrilateral(lon0, lat0, lonA, latA, lonB, latB, lonC, latC, lonD, latD)) {
            return new Point(col, row);
        }
        return null;
    }

    public void describeCell(int col, int row, StringBuilder sb, PrintfFormat valFormat) {
        if (col < 0 || row < 0) {
            sb.append("Point outside data bounds");
            return;
        }
        PointLL ll = this.getLonLatAt(col, row);
        double lon = ll.getLon();
        double lat = ll.getLat();
        sb.append("Cell ").append("[").append(col + 1).append(",").append(row + 1).append("]");
        sb.append(" at [");
        if (lon < 0.0) {
            sb.append(PFORMAT_D3.sprintf(-lon)).append("W ");
        } else {
            sb.append(PFORMAT_D3.sprintf(lon)).append("E ");
        }
        if (lat < 0.0) {
            sb.append(PFORMAT_D3.sprintf(-lat)).append("S");
        } else {
            sb.append(PFORMAT_D3.sprintf(lat)).append("N");
        }
        sb.append("] (alt-[").append(col).append(",").append(row);
        sb.append("]), value = ");
        double gv = this.valueAt(col, row);
        sb.append(valFormat.sprintf(gv));
        if (this.getUnits() != null && !Double.isNaN(gv)) {
            sb.append(" ").append(this.getUnits());
        }
    }
}

