/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcAxisException;
import gov.nasa.giss.netcdf.NcAxisType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.netcdf.gridder.NcLonLatReducedType1Gridder;
import gov.nasa.giss.text.PrintfFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayShort;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatReducedType1
extends NcArray {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayLonLatReducedType1.class);
    private static final PrintfFormat PFORMAT_D3 = new PrintfFormat("%.3f\u00b0");
    private VariableDS lonVar_;
    private VariableDS latVar_;
    private Array lonArray_;
    private Array latArray_;
    private Index lonIndex_;
    private Index latIndex_;
    private double[] latValues_;
    private int[] latOffsets_;
    private int[] colsInRow_;
    protected NcAxis yAxis_;
    private int numPts_ = -1;
    private int reduceDimIndex_ = -1;
    private int numRows_ = -1;
    private int maxCols_ = -1;

    public NcArrayLonLatReducedType1(NcDataset dataset, String varname) throws NcException {
        super(dataset, varname);
    }

    public NcArrayLonLatReducedType1(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.initMe();
    }

    private void initMe() {
        int i;
        Dimension latDim;
        List<CoordinateSystem> l = this.varDS_.getCoordinateSystems();
        if (l == null || l.size() < 1) {
            throw new RuntimeException("No coordinate systems");
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            throw new RuntimeException("No coordinate system");
        }
        this.lonVar_ = cs.getLonAxis();
        this.latVar_ = cs.getLatAxis();
        if (this.lonVar_ == null || this.latVar_ == null) {
            throw new RuntimeException("No coordinate system");
        }
        int[] lonshape = this.lonVar_.getShape();
        int[] latshape = this.latVar_.getShape();
        if (!(this.lonVar_ instanceof CoordinateAxis1D)) {
            throw new RuntimeException("Bad lonax");
        }
        if (!(this.latVar_ instanceof CoordinateAxis1D)) {
            throw new RuntimeException("Bad latax");
        }
        if (lonshape.length != 1 || lonshape[0] < 2) {
            throw new RuntimeException("Bad lon shape");
        }
        if (latshape.length != 1 || latshape[0] < 2) {
            throw new RuntimeException("Bad lat shape");
        }
        Dimension lonDim = this.lonVar_.getDimension(0);
        if (!lonDim.equals(latDim = this.latVar_.getDimension(0))) {
            throw new RuntimeException("Dimension mismatch");
        }
        int rank = this.varDS_.getRank();
        for (int i2 = 0; i2 < rank; ++i2) {
            Dimension d = this.varDS_.getDimension(i2);
            if (!d.equals(lonDim)) continue;
            this.reduceDimIndex_ = i2;
            break;
        }
        if (this.reduceDimIndex_ < 0) {
            throw new RuntimeException("Dimension mismatch");
        }
        String dname = lonDim.getFullName();
        if (dname == null) {
            throw new RuntimeException("No dim name");
        }
        VariableDS dimvar = this.dataset_.findVariable(dname);
        Attribute reduceA = dimvar.findAttribute("compress");
        if (reduceA == null) {
            throw new RuntimeException("No reduceion name");
        }
        String reduce = reduceA.getStringValue();
        String[] tokens = reduce.split(" ");
        if (tokens.length != 2) {
            throw new RuntimeException("Wrong reduceion size");
        }
        Dimension dd1 = this.dataset_.findDimension(tokens[0]);
        Dimension dd2 = this.dataset_.findDimension(tokens[1]);
        if (dd1 == null || dd2 == null) {
            throw new RuntimeException("Could not find reduceion dimensions");
        }
        try {
            this.lonArray_ = this.lonVar_.read();
            this.lonIndex_ = this.lonArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcAxisException("Could not read lon axis array");
        }
        try {
            this.latArray_ = this.latVar_.read();
            this.latIndex_ = this.latArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcAxisException("Could not read lat axis array");
        }
        this.numPts_ = (int)this.lonArray_.getSize();
        ArrayList<Double> latValuesAL = new ArrayList<Double>((int)Math.sqrt(this.numPts_));
        ArrayList<Integer> latOffsetsAL = new ArrayList<Integer>(latValuesAL.size());
        double lastLat = -9999.0;
        for (i = 0; i < this.numPts_; ++i) {
            double lat = this.latArray_.getDouble(i);
            if (lat == lastLat) continue;
            lastLat = lat;
            latValuesAL.add(lat);
            latOffsetsAL.add(i);
        }
        this.numRows_ = latValuesAL.size();
        this.latValues_ = new double[this.numRows_];
        this.latOffsets_ = new int[this.numRows_];
        this.colsInRow_ = new int[this.numRows_];
        for (i = 0; i < this.numRows_; ++i) {
            this.latValues_[i] = (Double)latValuesAL.get(i);
            this.latOffsets_[i] = (Integer)latOffsetsAL.get(i);
        }
        for (i = 0; i < this.numRows_; ++i) {
            this.colsInRow_[i] = i < this.numRows_ - 1 ? this.latOffsets_[i + 1] - this.latOffsets_[i] : this.numPts_ - this.latOffsets_[i];
            if (this.colsInRow_[i] <= this.maxCols_) continue;
            this.maxCols_ = this.colsInRow_[i];
        }
        this.yAxis_ = new NcAxis(NcAxisType.LATITUDE, "Latitude", this.latValues_);
    }

    @Override
    protected void createDimensions() {
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.reduceDimIndex_ ? null : this.ncvar_.getDimension(i);
        }
    }

    public int getMaxCols() {
        return this.maxCols_;
    }

    public NcAxis getXAxis(int row) {
        int cols = this.colsInRow_[row];
        double[] vals = new double[cols];
        for (int i = 0; i < cols; ++i) {
            vals[i] = this.lonArray_.getDouble(this.latOffsets_[row] + i);
            if (i <= 0 || !(vals[i] < vals[i - 1])) continue;
            int n = i;
            vals[n] = vals[n] + 360.0;
        }
        return new NcAxis(NcAxisType.LONGITUDE, "Longitude", vals);
    }

    public NcAxis getYAxis() {
        return this.yAxis_;
    }

    public double getLongitudeAt(int col, int row) {
        return this.lonArray_.getDouble(this.latOffsets_[row] + col);
    }

    public double getLatitudeAt(int row) {
        return this.latValues_[row];
    }

    @Override
    protected void findExtrema() {
        double[] range = this.getActualRange();
        if (range != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        this.minimum_ = Double.POSITIVE_INFINITY;
        this.maximum_ = Double.NEGATIVE_INFINITY;
        try {
            for (int i = 0; i < this.numPts_; ++i) {
                double value = this.valueAt(i);
                if (Double.isNaN(value) || this.isMissingOrInvalid(value)) continue;
                if (this.maximum_ < this.minimum_) {
                    this.minimum_ = value;
                    this.maximum_ = value;
                    continue;
                }
                if (value < this.minimum_) {
                    this.minimum_ = value;
                    continue;
                }
                if (!(value > this.maximum_)) continue;
                this.maximum_ = value;
            }
        }
        catch (Exception exc) {
            logger_.error(exc.toString());
        }
        if (Double.isInfinite(this.minimum_)) {
            this.minimum_ = Double.NaN;
            this.maximum_ = Double.NaN;
        }
        this.needsExtrema_ = false;
    }

    public void describeCell(int col, int row, StringBuilder sb, PrintfFormat valFormat) {
        sb.append("Point outside data bounds");
    }

    public double valueAt(int index) {
        if (index < 0 || index >= this.numPts_) {
            throw new IllegalArgumentException("Index out of range: " + index + ", " + this.numPts_);
        }
        if (this.needsSlice_) {
            this.doSlice();
        }
        try {
            return this.getDoubleFromSlice(index);
        }
        catch (Exception exc) {
            logger_.error("Slice getDouble failed -  index = {}.{}", (Object)index);
            exc.printStackTrace();
            throw new NcException(exc.toString());
        }
    }

    public double valueAt(int col, int row) {
        if (row < 0 || row >= this.numRows_) {
            throw new IllegalArgumentException("Row index out of range: " + row + ", " + this.numRows_);
        }
        if (col < 0 || col >= this.colsInRow_[row]) {
            throw new IllegalArgumentException("Col index out of range: " + col + ", " + this.colsInRow_[row]);
        }
        if (this.needsSlice_) {
            this.doSlice();
        }
        try {
            int index = this.latOffsets_[row] + col;
            return this.getDoubleFromSlice(index);
        }
        catch (Exception exc) {
            logger_.error("Slice getDouble failed -  row,col = {}.{}", (Object)row, (Object)col);
            exc.printStackTrace();
            throw new NcException(exc.toString());
        }
    }

    private double getDoubleFromSlice(int index) {
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.reduceDimIndex_] = index;
        this.sliceIdx_.set(ss);
        if (!this.hasScaleOffset_) {
            if (this.slice_ instanceof ArrayByte) {
                long v = this.slice_.getByte(this.sliceIdx_);
                if (this.isUnsigned_ && v < 0L) {
                    v += 256L;
                }
                return v;
            }
            if (this.slice_ instanceof ArrayShort) {
                long v = this.slice_.getShort(this.sliceIdx_);
                if (this.isUnsigned_ && v < 0L) {
                    v += 65536L;
                }
                return v;
            }
            if (this.slice_ instanceof ArrayInt) {
                long v = this.slice_.getInt(this.sliceIdx_);
                if (this.isUnsigned_ && v < 0L) {
                    v += 0x100000000L;
                }
                return v;
            }
        }
        return this.slice_.getDouble(this.sliceIdx_);
    }

    private synchronized void doSlice() throws NcException {
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        try {
            this.needsSlice_ = true;
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.reduceDimIndex_] = 0;
            sShape[this.reduceDimIndex_] = this.numPts_;
            this.slice_ = this.varDS_.read(sOrigin, sShape);
            this.sliceIdx_ = this.slice_.getIndex();
            this.needsSlice_ = false;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new NcException("Do Slice - " + exc.toString());
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcLonLatReducedType1Gridder();
    }
}

