/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcArrayGridException;
import gov.nasa.giss.netcdf.NcArrayType;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcAxisException;
import gov.nasa.giss.netcdf.NcAxisType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVarUtilities;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.netcdf.gridder.NcLonLatProjectedGridder;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Point;
import java.awt.geom.Point2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.units.Unit;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;

public abstract class NcArrayLonLatProjectedGrid
extends NcArray2D {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayLonLatProjectedGrid.class);
    private static final PrintfFormat PFORMAT_4G = new PrintfFormat("%.4g");
    private static final PrintfFormat PFORMAT_D3 = new PrintfFormat("%.3f\u00b0");
    protected static final double PI = Math.PI;
    protected static final double PI_OVER_2 = 1.5707963267948966;
    protected static final double RAD_PER_DEG = Math.PI / 180;
    protected static final double DEG_PER_RAD = 57.29577951308232;
    private static final double DEFAULT_RADIUS = 6371.229;
    private static final String DEFAULT_RADIUS_UNITS = "km";
    protected VariableDS mappingVarDS_;
    protected String mappingName_;
    protected double radius_ = 6371.229;
    protected String radiusUnits_ = "km";
    protected double oneOverR_ = 1.0 / this.radius_;
    protected double lambdaC_ = 0.0;
    protected double phiC_ = 0.0;
    protected double falseEasting_ = 0.0;
    protected double falseNorthing_ = 0.0;

    public NcArrayLonLatProjectedGrid(NcArrayType type, NcDataset dataset, String varname) throws NcException {
        super(dataset, varname);
    }

    public NcArrayLonLatProjectedGrid(NcArrayType type, NcVariable ncvar) throws NcException {
        super(ncvar);
    }

    protected String initCoordinateTransform(CoordinateSystem cs) {
        this.mappingVarDS_ = NcVarUtilities.findGridMappingVariable(this.getDataset(), this.varDS_);
        if (this.mappingVarDS_ == null) {
            throw new NcArrayGridException("Mapping variable was not found");
        }
        this.mappingName_ = NcVarUtilities.findGridMappingName(this.mappingVarDS_);
        if (this.mappingName_ == null) {
            throw new NcArrayGridException("Grid mapping variable has no projection attribute");
        }
        return this.mappingName_;
    }

    protected void initCenter() {
        Attribute lonA = this.mappingVarDS_.findAttribute("longitude_of_projection_origin");
        Attribute latA = this.mappingVarDS_.findAttribute("latitude_of_projection_origin");
        if (lonA == null) {
            lonA = this.mappingVarDS_.findAttribute("straight_vertical_longitude_from_pole");
        }
        if (lonA == null) {
            lonA = this.mappingVarDS_.findAttribute("longitude_of_central_meridian");
        }
        if (lonA != null) {
            this.lambdaC_ = NcArrayLonLatProjectedGrid.normalizeLon(lonA.getNumericValue().doubleValue());
        }
        if (latA != null) {
            this.phiC_ = latA.getNumericValue().doubleValue();
        }
    }

    protected void initRadiusEastingAndNorthing() {
        Attribute radiusA;
        double d;
        Attribute eastingA = this.mappingVarDS_.findAttribute("false_easting");
        Attribute northingA = this.mappingVarDS_.findAttribute("false_northing");
        if (eastingA != null && !Double.isNaN(d = eastingA.getNumericValue().doubleValue())) {
            this.falseEasting_ = d;
        }
        if (northingA != null && !Double.isNaN(d = northingA.getNumericValue().doubleValue())) {
            this.falseNorthing_ = d;
        }
        if ((radiusA = this.mappingVarDS_.findAttribute("earth_radius")) != null) {
            this.radius_ = radiusA.getNumericValue().doubleValue();
            this.radiusUnits_ = this.radius_ < 10000.0 ? DEFAULT_RADIUS_UNITS : "m";
        }
        String eastingUnits = this.getCoordinateAxis(NcAxisType.GEOX).getUnitsString();
        UnitFormat unitFormat = UnitFormatManager.instance();
        try {
            Unit drUnit = unitFormat.parse(this.radiusUnits_);
            Unit feUnit = unitFormat.parse(eastingUnits);
            this.radius_ = drUnit.convertTo(this.radius_, feUnit);
            this.radiusUnits_ = eastingUnits;
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.oneOverR_ = 1.0 / this.radius_;
    }

    @Override
    protected void setAxes() {
        CoordinateAxis x = this.getCoordinateAxis(NcAxisType.GEOX);
        CoordinateAxis y = this.getCoordinateAxis(NcAxisType.GEOY);
        if (x == null) {
            throw new NcAxisException("Got null for x-axis coordinate variable");
        }
        if (y == null) {
            throw new NcAxisException("Got null for y-axis coordinate variable");
        }
        this.xAxis_ = new NcAxis(this.getDataset(), x);
        this.yAxis_ = new NcAxis(this.getDataset(), y);
        this.xDimIndex_ = this.findDimensionIndex(x);
        this.yDimIndex_ = this.findDimensionIndex(y);
        if (this.xDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of x axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of y axis");
        }
    }

    public abstract Point2D.Double transformLL2XY(double var1, double var3);

    public abstract PointLL transformXY2LL(double var1, double var3);

    public double[] getBounds() {
        double[][] xBounds = this.getXAxis().getBounds();
        double[][] yBounds = this.getYAxis().getBounds();
        double left = xBounds[0][0];
        double top = yBounds[0][0];
        double right = xBounds[xBounds.length - 1][1];
        double bottom = yBounds[yBounds.length - 1][1];
        return new double[]{left, top, right, bottom};
    }

    protected static double normalizeLon(double lon) {
        while (lon < -180.0) {
            lon += 360.0;
        }
        while (lon > 180.0) {
            lon -= 360.0;
        }
        return lon;
    }

    public Point findClosestPoint(double lon, double lat) {
        double halfdiff2;
        double diff2;
        double diff1;
        Point2D.Double altXY = this.transformLL2XY(lon, lat);
        double x = altXY.x;
        double y = altXY.y;
        double[] xValues = this.getXAxis().getValues();
        double[] yValues = this.getYAxis().getValues();
        int imax = xValues.length - 1;
        int jmax = yValues.length - 1;
        int col = -1;
        int row = -1;
        if (NcArrayLonLatProjectedGrid.isBetween(x, xValues[0], xValues[imax])) {
            for (int i = 0; i < imax; ++i) {
                if (!NcArrayLonLatProjectedGrid.isBetween(x, xValues[i], xValues[i + 1])) continue;
                diff1 = Math.abs(x - xValues[i]);
                col = diff1 <= (diff2 = Math.abs(x - xValues[i + 1])) ? i : i + 1;
                break;
            }
        } else {
            double halfdiff1 = 0.5 * (xValues[1] - xValues[0]);
            halfdiff2 = 0.5 * (xValues[imax] - xValues[imax - 1]);
            if (NcArrayLonLatProjectedGrid.isBetween(x, xValues[0], xValues[0] - halfdiff1)) {
                col = 0;
            }
            if (NcArrayLonLatProjectedGrid.isBetween(x, xValues[imax], xValues[imax] + halfdiff2)) {
                col = imax;
            }
        }
        if (NcArrayLonLatProjectedGrid.isBetween(y, yValues[0], yValues[jmax])) {
            for (int j = 0; j < jmax; ++j) {
                if (!NcArrayLonLatProjectedGrid.isBetween(y, yValues[j], yValues[j + 1])) continue;
                diff1 = Math.abs(y - yValues[j]);
                row = diff1 <= (diff2 = Math.abs(y - yValues[j + 1])) ? j : j + 1;
                break;
            }
        } else {
            double halfdiff1 = 0.5 * (yValues[1] - yValues[0]);
            halfdiff2 = 0.5 * (yValues[jmax] - yValues[jmax - 1]);
            if (NcArrayLonLatProjectedGrid.isBetween(y, yValues[0], yValues[0] - halfdiff1)) {
                row = 0;
            }
            if (NcArrayLonLatProjectedGrid.isBetween(y, yValues[jmax], yValues[jmax] + halfdiff2)) {
                row = jmax;
            }
        }
        if (col == -1 || row == -1) {
            return null;
        }
        return new Point(col, row);
    }

    private static boolean isBetween(double value, double range1, double range2) {
        return value >= range1 && value <= range2 || value <= range1 && value >= range2;
    }

    @Override
    public void describeCell(int col, int row, StringBuilder sb, PrintfFormat valFormat) {
        if (col < 0 || row < 0) {
            sb.append("Point outside data bounds");
            return;
        }
        double x = this.getXAxis().valueAt(col);
        double y = this.getYAxis().valueAt(row);
        PointLL ll2 = this.transformXY2LL(x, y);
        double lon = ll2.getLon();
        double lat = ll2.getLat();
        sb.append("Cell ").append("[").append(col + 1).append(",").append(row + 1).append("]");
        sb.append(" at [");
        if (lon < 0.0) {
            sb.append(PFORMAT_D3.sprintf(-lon)).append("W ");
        } else {
            sb.append(PFORMAT_D3.sprintf(lon)).append("E ");
        }
        if (lat < 0.0) {
            sb.append(PFORMAT_D3.sprintf(-lat)).append("S");
        } else {
            sb.append(PFORMAT_D3.sprintf(lat)).append("N");
        }
        sb.append("] (alt-[");
        sb.append(PFORMAT_4G.sprintf(this.getXAxis().valueAt(col)));
        if (this.getXAxis().getUnits() != null) {
            sb.append(" ").append(this.getXAxis().getUnits());
        }
        sb.append(",");
        sb.append(PFORMAT_4G.sprintf(this.getYAxis().valueAt(row)));
        if (this.getYAxis().getUnits() != null) {
            sb.append(" ").append(this.getYAxis().getUnits());
        }
        sb.append("]), value = ");
        double gv = this.valueAt(col, row);
        sb.append(valFormat.sprintf(gv));
        if (this.getUnits() != null && !Double.isNaN(gv)) {
            sb.append(" ").append(this.getUnits());
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcLonLatProjectedGridder();
    }
}

