/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArrayGridException;
import gov.nasa.giss.netcdf.NcAxisException;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.netcdf.gridder.NcLonLatFvcomGridder;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.geom.GeneralPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatFvcomNodes
extends NcArray {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayLonLatFvcomNodes.class);
    private int nodeDimIndex_ = -1;
    private int numNodes_ = -1;
    private VariableDS elementsVar_;
    private Array elementsArray_;
    private Index elementsIndex_;
    private int numElements_;
    private VariableDS lonVar_;
    private VariableDS latVar_;
    private Array lonArray_;
    private Array latArray_;
    private Index lonIndex_;
    private Index latIndex_;
    private double minLon_ = Double.POSITIVE_INFINITY;
    private double maxLon_ = Double.NEGATIVE_INFINITY;
    private double minLat_ = Double.POSITIVE_INFINITY;
    private double maxLat_ = Double.NEGATIVE_INFINITY;
    private int fortranOffset_ = -1;

    public NcArrayLonLatFvcomNodes(NcDataset dataset, String varname) throws NcException {
        super(dataset, varname);
        this.initMe();
    }

    public NcArrayLonLatFvcomNodes(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.initMe();
    }

    protected void initMe() throws NcException {
        Attribute gr = this.varDS_.findAttributeIgnoreCase("grid");
        if (gr == null || !gr.getStringValue().equalsIgnoreCase("fvcom_grid")) {
            throw new NcArrayGridException("Variable does not have fvcom_grid values attribute.");
        }
        this.nodeDimIndex_ = this.varDS_.findDimensionIndex("node");
        int[] shape = this.varDS_.getShape();
        this.numNodes_ = shape[this.nodeDimIndex_];
        this.lonVar_ = this.getDataset().findVariable("lon");
        this.latVar_ = this.getDataset().findVariable("lat");
        try {
            this.lonArray_ = this.lonVar_.read();
            this.lonIndex_ = this.lonArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcAxisException("Could not read lon axis array");
        }
        try {
            this.latArray_ = this.latVar_.read();
            this.latIndex_ = this.latArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcAxisException("Could not read lat axis array");
        }
        for (int i = 0; i < this.numNodes_; ++i) {
            double lon = this.getLongitudeAt(i);
            double lat = this.getLatitudeAt(i);
            if (lon > this.maxLon_) {
                this.maxLon_ = lon;
            }
            if (lon < this.minLon_) {
                this.minLon_ = lon;
            }
            if (lat > this.maxLat_) {
                this.maxLat_ = lat;
            }
            if (!(lat < this.minLat_)) continue;
            this.minLat_ = lat;
        }
        this.elementsVar_ = this.getDataset().findVariable("nv");
        int[] eshape = this.elementsVar_.getShape();
        int elementShape = eshape[0];
        this.numElements_ = eshape[1];
        try {
            this.elementsArray_ = this.elementsVar_.read();
        }
        catch (Exception exc) {
            throw new NcException("Could not read elements array");
        }
        this.elementsIndex_ = this.elementsArray_.getIndex();
        for (int i = 0; i < this.numElements_; ++i) {
            int node0 = (int)this.elementsArray_.getFloat(this.elementsIndex_.set(0, i));
            int node1 = (int)this.elementsArray_.getFloat(this.elementsIndex_.set(1, i));
            int node2 = (int)this.elementsArray_.getFloat(this.elementsIndex_.set(2, i));
            if (node0 != 0 && node1 != 0 && node2 != 0) continue;
            this.fortranOffset_ = 0;
            break;
        }
        if (this.fortranOffset_ == -1) {
            this.fortranOffset_ = 1;
        }
    }

    @Override
    protected void createDimensions() {
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.nodeDimIndex_ ? null : this.ncvar_.getDimension(i);
        }
    }

    public double getMinimumLon() {
        return this.minLon_;
    }

    public double getMaximumLon() {
        return this.maxLon_;
    }

    public double getMinimumLat() {
        return this.minLat_;
    }

    public double getMaximumLat() {
        return this.maxLat_;
    }

    public void describeNode(int node, StringBuilder sb, PrintfFormat valFormat, PrintfFormat degFormat) {
        if (node < 0) {
            sb.append("Point outside data bounds");
            return;
        }
        sb.append("FV Node ").append("[").append(node).append("]");
        sb.append(" at [");
        double lon = this.getLongitudeAt(node);
        double lat = this.getLatitudeAt(node);
        if (lon < 0.0) {
            sb.append(degFormat.sprintf(-lon)).append("W ");
        } else {
            sb.append(degFormat.sprintf(lon)).append("E ");
        }
        if (lat < 0.0) {
            sb.append(degFormat.sprintf(-lat)).append("S");
        } else {
            sb.append(degFormat.sprintf(lat)).append("N");
        }
        sb.append("]");
        double value = this.valueAt(node);
        sb.append(valFormat.sprintf(value));
        if (this.getUnits() != null && !Double.isNaN(value)) {
            sb.append(" ").append(this.getUnits());
        }
    }

    public double getLongitudeAt(int node) {
        return this.lonArray_.getDouble(this.lonIndex_.set(node));
    }

    public double getLatitudeAt(int node) {
        return this.latArray_.getDouble(this.latIndex_.set(node));
    }

    public PointLL getLonLatAt(int node) {
        return new PointLL(this.lonArray_.getDouble(this.lonIndex_.set(node)), this.latArray_.getDouble(this.latIndex_.set(node)));
    }

    public double valueAt(int node) {
        if (node < 0 || node >= this.numNodes_) {
            throw new IllegalArgumentException("Node index out of range: " + node + " : " + this.numNodes_);
        }
        try {
            if (!this.needsSlice_) {
                this.doSlice();
            }
        }
        catch (NcException exc) {
            throw exc;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new NcException("NcArrayFvcomNodes.valueAt -- " + exc.toString());
        }
        try {
            return this.slice_.getDouble(this.slice_.getIndex().set(node));
        }
        catch (Exception exc) {
            logger_.error("node {}", (Object)node);
            logger_.error("rank {}", (Object)this.slice_.getRank());
            exc.printStackTrace();
            throw new NcException("NcArrayFvcomNodes.valueAt -- " + exc.toString());
        }
    }

    public int getElementCount() {
        return this.numElements_;
    }

    public int[] getElementNodes(int element) {
        int node0 = (int)this.elementsArray_.getFloat(this.elementsIndex_.set(0, element)) - this.fortranOffset_;
        int node1 = (int)this.elementsArray_.getFloat(this.elementsIndex_.set(1, element)) - this.fortranOffset_;
        int node2 = (int)this.elementsArray_.getFloat(this.elementsIndex_.set(2, element)) - this.fortranOffset_;
        return new int[]{node0, node1, node2};
    }

    private synchronized void doSlice() throws NcException {
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        try {
            int i;
            this.needsSlice_ = true;
            for (i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.nodeDimIndex_] = 0;
            sShape[this.nodeDimIndex_] = this.numNodes_;
            this.slice_ = this.varDS_.read(sOrigin, sShape);
            for (i = this.rank_ - 1; i >= 0; --i) {
                if (i == this.nodeDimIndex_) continue;
                this.slice_ = this.slice_.reduce(i);
            }
            this.needsSlice_ = false;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new NcException("NcArrayFvcomNodes.doSlice -- " + exc.toString());
        }
    }

    @Override
    protected void findExtrema() {
        int imax = this.numNodes_;
        this.minimum_ = Double.POSITIVE_INFINITY;
        this.maximum_ = Double.NEGATIVE_INFINITY;
        try {
            for (int i = 0; i < this.numNodes_; ++i) {
                double value = this.valueAt(i);
                if (Double.isNaN(value) || this.isMissingOrInvalid(value)) continue;
                if (this.maximum_ < this.minimum_) {
                    this.minimum_ = value;
                    this.maximum_ = value;
                    continue;
                }
                if (value < this.minimum_) {
                    this.minimum_ = value;
                    continue;
                }
                if (!(value > this.maximum_)) continue;
                this.maximum_ = value;
            }
        }
        catch (Exception exc) {
            logger_.error(exc.toString());
        }
    }

    public int findClosestNode(double lon, double lat) {
        GeneralPath element = new GeneralPath();
        int[] nodes = null;
        double[] nodelon = new double[3];
        double[] nodelat = new double[3];
        for (int i = 0; i < this.numElements_; ++i) {
            nodes = this.getElementNodes(i);
            nodelon[0] = this.getLongitudeAt(nodes[0]);
            nodelat[0] = this.getLatitudeAt(nodes[0]);
            nodelon[1] = this.getLongitudeAt(nodes[1]);
            nodelat[1] = this.getLatitudeAt(nodes[1]);
            nodelon[2] = this.getLongitudeAt(nodes[2]);
            nodelat[2] = this.getLatitudeAt(nodes[2]);
            element.reset();
            element.moveTo((float)nodelon[0], (float)nodelat[0]);
            element.lineTo((float)nodelon[1], (float)nodelat[1]);
            element.lineTo((float)nodelon[2], (float)nodelat[2]);
            element.closePath();
            if (!element.contains(lon, lat)) continue;
            double mindist = Double.POSITIVE_INFINITY;
            double cosLatA = Math.cos(Math.toRadians(lat));
            double sinLatA = Math.sin(Math.toRadians(lat));
            int node = -1;
            for (int j = 0; j < 3; ++j) {
                double dlon = nodelon[j] - lon;
                double cosLatB = Math.cos(Math.toRadians(nodelat[j]));
                double sinLatB = Math.sin(Math.toRadians(nodelat[j]));
                double value = cosLatA * cosLatB * Math.cos(dlon) + sinLatA * sinLatB;
                double angle = Math.acos(value);
                if (angle == 0.0) {
                    return nodes[j];
                }
                if (!(angle < mindist)) continue;
                mindist = angle;
                node = nodes[j];
            }
            return node;
        }
        return -1;
    }

    @Override
    public NcGridder getGridder() {
        return new NcLonLatFvcomGridder();
    }
}

