/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array;

import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcAxisException;
import gov.nasa.giss.netcdf.NcAxisType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.netcdf.gridder.NcLonLatRegularGridder;
import gov.nasa.giss.text.PrintfFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateAxis;

public class NcArrayLonLat
extends NcArray2D {
    private static Logger logger_ = LoggerFactory.getLogger(NcArrayLonLat.class);
    private static final PrintfFormat PFORMAT_D3 = new PrintfFormat("%.3f\u00b0");

    public NcArrayLonLat(NcDataset dataset, String varname) throws NcException {
        super(dataset, varname);
    }

    public NcArrayLonLat(NcVariable ncvar) throws NcException {
        super(ncvar);
    }

    @Override
    protected void setAxes() {
        CoordinateAxis x = this.getCoordinateAxis(NcAxisType.LONGITUDE);
        CoordinateAxis y = this.getCoordinateAxis(NcAxisType.LATITUDE);
        if (x == null) {
            throw new NcAxisException("Got null for longitude axis coordinate variable");
        }
        if (y == null) {
            throw new NcAxisException("Got null for latitude axis coordinate variable");
        }
        NcDataset d = this.getDataset();
        this.xAxis_ = new NcAxis(d, x);
        this.yAxis_ = new NcAxis(d, y);
        this.xDimIndex_ = this.findDimensionIndex(x);
        this.yDimIndex_ = this.findDimensionIndex(y);
        if (this.xDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of x axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of y axis");
        }
    }

    @Override
    public void describeCell(int col, int row, StringBuilder sb, PrintfFormat valFormat) {
        if (col < 0 || row < 0) {
            sb.append("Point outside data bounds");
            return;
        }
        int colDisplay = this.xAxis_.isFlipped() ? this.xAxis_.getSize() - col : col + 1;
        int rowDisplay = this.yAxis_.isFlipped() ? this.yAxis_.getSize() - row : row + 1;
        sb.append("Cell ").append("[").append(colDisplay).append(",").append(rowDisplay).append("]");
        sb.append(" at [");
        double lon = this.xAxis_.valueAt(col);
        double lat = this.yAxis_.valueAt(row);
        if (lon < 0.0) {
            sb.append(PFORMAT_D3.sprintf(-lon)).append("W ");
        } else {
            sb.append(PFORMAT_D3.sprintf(lon)).append("E ");
        }
        if (lat < 0.0) {
            sb.append(PFORMAT_D3.sprintf(-lat)).append("S");
        } else {
            sb.append(PFORMAT_D3.sprintf(lat)).append("N");
        }
        sb.append("], value = ");
        double gv = this.valueAt(col, row);
        sb.append(valFormat.sprintf(gv));
        if (this.getUnits() != null && !Double.isNaN(gv)) {
            sb.append(" ").append(this.getUnits());
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcLonLatRegularGridder();
    }
}

