/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf.array;

import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcAxisException;
import gov.nasa.giss.netcdf.NcAxisType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.text.PrintfFormat;
import ucar.nc2.dataset.CoordinateAxis;

public class NcArrayLatVert
extends NcArray2D {
    private static final PrintfFormat PFORMAT_4G = new PrintfFormat("%.4g");
    private static final PrintfFormat PFORMAT_D3 = new PrintfFormat("%.3f\u00b0");

    public NcArrayLatVert(NcDataset dataset, String varname) throws NcException {
        super(dataset, varname);
    }

    public NcArrayLatVert(NcVariable ncvar) throws NcException {
        super(ncvar);
    }

    @Override
    protected void setAxes() {
        CoordinateAxis x = this.getCoordinateAxis(NcAxisType.LATITUDE);
        CoordinateAxis y = this.getCoordinateAxis(NcAxisType.VERTICAL);
        if (x == null) {
            throw new NcAxisException("Got null for latitude axis coordinate variable");
        }
        if (y == null) {
            throw new NcAxisException("Got null for vertical axis coordinate variable");
        }
        this.xAxis_ = new NcAxis(this.getDataset(), x);
        this.yAxis_ = new NcAxis(this.getDataset(), y);
        this.xDimIndex_ = this.findDimensionIndex(x);
        this.yDimIndex_ = this.findDimensionIndex(y);
        if (this.xDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of x axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcAxisException("Unable to determine length of y axis");
        }
        CoordinateAxis a = this.getCoordinateAxis(NcAxisType.LONGITUDE);
        if (a != null) {
            this.aveDimIndex_ = this.findDimensionIndex(a);
        }
    }

    @Override
    public void describeCell(int col, int row, StringBuilder sb, PrintfFormat valFormat) {
        if (row < 0 || col < 0) {
            sb.append("Outside Array Bounds\n");
            return;
        }
        int colDisplay = this.xAxis_.isFlipped() ? this.xAxis_.getSize() - col : col + 1;
        int rowDisplay = this.yAxis_.isFlipped() ? this.yAxis_.getSize() - row : row + 1;
        sb.append("Cell [").append(colDisplay).append(", ").append(rowDisplay).append("] at [");
        double lat = this.getXAxis().valueAt(col);
        if (lat < 0.0) {
            sb.append(PFORMAT_D3.sprintf(-lat)).append("S");
        } else {
            sb.append(PFORMAT_D3.sprintf(lat)).append("N");
        }
        sb.append(", ").append(PFORMAT_4G.sprintf(this.getYAxis().valueAt(row)));
        if (this.getYAxis().getUnits() != null) {
            sb.append(" ").append(this.getYAxis().getUnits());
        }
        sb.append("], value = ");
        double value = this.valueAt(col, row);
        sb.append(valFormat.sprintf(value));
        if (this.getUnits() != null && !Double.isNaN(value)) {
            sb.append(" ").append(this.getUnits());
        }
    }

    @Override
    public NcGridder getGridder() {
        return null;
    }
}

