/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.netcdf.NcVarType;
import gov.nasa.giss.netcdf.NcVarUtilities;
import gov.nasa.giss.netcdf.array.NcArrayLatVert;
import gov.nasa.giss.netcdf.array.NcArrayLonLat;
import gov.nasa.giss.netcdf.array.NcArrayLonLatAuxiliary;
import gov.nasa.giss.netcdf.array.NcArrayLonLatFvcomNodes;
import gov.nasa.giss.netcdf.array.NcArrayLonLatReducedType1;
import gov.nasa.giss.netcdf.array.NcArrayLonLatReducedType2;
import gov.nasa.giss.netcdf.array.NcArrayLonLatScatterNodes;
import gov.nasa.giss.netcdf.array.NcArrayLonVert;
import gov.nasa.giss.netcdf.array.NcArrayTimeLat;
import gov.nasa.giss.netcdf.array.projected.NcArrayAlbersEqualAreaConic;
import gov.nasa.giss.netcdf.array.projected.NcArrayAzimuthalEqualArea;
import gov.nasa.giss.netcdf.array.projected.NcArrayLambertConformalConic;
import gov.nasa.giss.netcdf.array.projected.NcArrayMercator;
import gov.nasa.giss.netcdf.array.projected.NcArrayRotatedPole;
import gov.nasa.giss.netcdf.array.projected.NcArraySinusoidal;
import gov.nasa.giss.netcdf.array.projected.NcArrayStereographic;
import gov.nasa.giss.netcdf.array.projected.NcArrayTransverseMercator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class NcVariable
extends NcNode {
    private static Logger logger_ = LoggerFactory.getLogger(NcVariable.class);
    private static String SYSTEM_EOL = System.getProperty("line.separator");
    private VariableDS varDS_;
    private NcVarType varType_;
    NcDimension[] dimensions_;

    public NcVariable(NcDataset d, String varname) {
        this(d, d.findVariable(varname));
    }

    public NcVariable(NcDataset d, VariableDS v) {
        this.setParent(d);
        this.dataset_ = d;
        this.varDS_ = v;
        this.varType_ = NcVarUtilities.getVarType(d, v);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof NcVariable)) {
            return false;
        }
        return this.varDS_.equals(((NcVariable)o).getObject());
    }

    public NcVarType getVarType() {
        return this.varType_;
    }

    public NcDataset getDataset() {
        return this.dataset_;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Object getObject() {
        return this.varDS_;
    }

    @Override
    public String getName() {
        return this.varDS_.getShortName();
    }

    @Override
    public String getLongName() {
        return NcVarUtilities.getLongName(this.varDS_);
    }

    @Override
    public String getNcType() {
        switch (this.varType_) {
            case LON_LAT_VERT_TIME: {
                return "[lon][lat][vert][time]";
            }
            case LON_LAT_VERT: {
                return "[lon][lat][vert]";
            }
            case LON_LAT_TIME: {
                return "[lon][lat][time]";
            }
            case LAT_VERT_TIME: {
                return "[lat][vert][time]";
            }
            case LON_VERT_TIME: {
                return "[lon][vert][time]";
            }
            case LON_LAT: {
                return "[lon][lat]";
            }
            case LL_ALBERS_CONIC: 
            case LL_AZIM_EQUAL_AREA: 
            case LL_LAMBERT_CONFORMAL: 
            case LL_MERCATOR: 
            case LL_POLAR_STEREOGRAPHIC: 
            case LL_ROTATED_POLE: 
            case LL_SINUSOIDAL: 
            case LL_STEREOGRAPHIC: 
            case LL_TRANSVERSE_MERCATOR: {
                return "[lon][lat]";
            }
            case LL_AUXILIARY: 
            case LL_REDUCED_TYPE1: {
                return "[lon][lat]";
            }
            case LL_REDUCED_TYPE2: {
                return "[lon][lat]";
            }
            case LAT_VERT: {
                return "[lat][vert]";
            }
            case LON_VERT: {
                return "[lon][vert]";
            }
            case LAT_TIME: {
                return "[lat][time]";
            }
        }
        return "\u2014";
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public TreeTableNode[] getChildren() {
        return null;
    }

    @Override
    public String toString() {
        return this.varDS_.getFullName();
    }

    @Override
    public String getDetail() {
        StringBuffer sb = new StringBuffer("");
        sb.append("<html>");
        sb.append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<h2>Variable \"").append(this.getName()).append("\"</h2>\n");
        sb.append("<hr>");
        sb.append("<pre>");
        sb.append(StringEscapeUtils.escapeHtml4(this.varDS_.toString()));
        sb.append(SYSTEM_EOL);
        sb.append("</pre>");
        sb.append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    public boolean isPlottable() {
        return this.hasLonLat() || this.hasLatVert() || this.hasTimeLat() || this.hasLonVert();
    }

    public boolean hasLonLat() {
        switch (this.varType_) {
            case LON_LAT_VERT_TIME: 
            case LON_LAT_VERT: 
            case LON_LAT_TIME: 
            case LON_LAT: {
                return true;
            }
            case LL_ALBERS_CONIC: 
            case LL_AZIM_EQUAL_AREA: 
            case LL_LAMBERT_CONFORMAL: 
            case LL_MERCATOR: 
            case LL_POLAR_STEREOGRAPHIC: 
            case LL_ROTATED_POLE: 
            case LL_SINUSOIDAL: 
            case LL_STEREOGRAPHIC: 
            case LL_TRANSVERSE_MERCATOR: {
                return true;
            }
            case LL_AUXILIARY: 
            case LL_REDUCED_TYPE1: {
                return true;
            }
            case LL_REDUCED_TYPE2: {
                return true;
            }
        }
        return false;
    }

    public boolean hasLatVert() {
        switch (this.varType_) {
            case LON_LAT_VERT_TIME: 
            case LON_LAT_VERT: 
            case LAT_VERT_TIME: 
            case LAT_VERT: {
                return true;
            }
        }
        return false;
    }

    public boolean hasLonVert() {
        switch (this.varType_) {
            case LON_LAT_VERT_TIME: 
            case LON_LAT_VERT: 
            case LON_VERT_TIME: 
            case LON_VERT: {
                return true;
            }
        }
        return false;
    }

    public boolean hasTimeLat() {
        switch (this.varType_) {
            case LON_LAT_VERT_TIME: 
            case LON_LAT_TIME: 
            case LAT_VERT_TIME: 
            case LAT_TIME: {
                return true;
            }
        }
        return false;
    }

    public NcArray getArray(Axes axes) {
        if (axes == Axes.LON_LAT) {
            if (!this.hasLonLat()) {
                throw new IllegalArgumentException("Variable does not seem to include lon and lat dimensions.");
            }
            switch (this.varType_) {
                case LON_LAT_VERT_TIME: 
                case LON_LAT_VERT: 
                case LON_LAT_TIME: 
                case LON_LAT: {
                    return new NcArrayLonLat(this);
                }
                case LL_ALBERS_CONIC: {
                    return new NcArrayAlbersEqualAreaConic(this);
                }
                case LL_AZIM_EQUAL_AREA: {
                    return new NcArrayAzimuthalEqualArea(this);
                }
                case LL_LAMBERT_CONFORMAL: {
                    return new NcArrayLambertConformalConic(this);
                }
                case LL_MERCATOR: {
                    return new NcArrayMercator(this);
                }
                case LL_ROTATED_POLE: {
                    return new NcArrayRotatedPole(this);
                }
                case LL_SINUSOIDAL: {
                    return new NcArraySinusoidal(this);
                }
                case LL_STEREOGRAPHIC: {
                    return new NcArrayStereographic(this);
                }
                case LL_TRANSVERSE_MERCATOR: {
                    return new NcArrayTransverseMercator(this);
                }
                case LL_AUXILIARY: {
                    return new NcArrayLonLatAuxiliary(this);
                }
                case LL_REDUCED_TYPE1: {
                    return new NcArrayLonLatReducedType1(this);
                }
                case LL_REDUCED_TYPE2: {
                    return new NcArrayLonLatReducedType2(this);
                }
                case LL_FVCOM_NODES: {
                    return new NcArrayLonLatFvcomNodes(this);
                }
                case LL_SCATTER_NODES: {
                    return new NcArrayLonLatScatterNodes(this);
                }
            }
        } else {
            if (axes == Axes.LAT_VERT) {
                if (!this.hasLatVert()) {
                    throw new IllegalArgumentException("Variable does not seem to include lat and vert dimensions.");
                }
                return new NcArrayLatVert(this);
            }
            if (axes == Axes.LON_VERT) {
                if (!this.hasLonVert()) {
                    throw new IllegalArgumentException("Variable does not seem to include lon and vert dimensions.");
                }
                return new NcArrayLonVert(this);
            }
            if (axes == Axes.TIME_LAT) {
                if (!this.hasTimeLat()) {
                    throw new IllegalArgumentException("Variable does not seem to include time andlat dimensions.");
                }
                return new NcArrayTimeLat(this);
            }
        }
        throw new IllegalArgumentException("Unknown array type request");
    }

    public void printCdl(File f) throws IOException {
        PrintWriter writer = new PrintWriter(f);
        NetcdfDataset ncf = this.getDataset().getDataset();
        NCdumpW.print(ncf, (Writer)writer, false, false, false, true, this.getName(), null);
        writer.close();
    }

    public void printCsv(File f) throws IOException {
        PrintWriter writer = new PrintWriter(f);
        int rank = this.varDS_.getRank();
        int[] shape = this.varDS_.getShape();
        int rankM1 = rank - 1;
        int rankM2 = rank - 2;
        int rows = 1;
        int cols = shape[rankM1];
        for (int i = 0; i < rankM1; ++i) {
            rows *= shape[i];
        }
        int[] sOrigin = new int[rank];
        int[] sShape = new int[rank];
        for (int i = 0; i < rank - 1; ++i) {
            sOrigin[i] = 0;
            sShape[i] = 1;
        }
        sOrigin[rankM1] = 0;
        sShape[rankM1] = cols;
        try {
            for (int i = 0; i < rows; ++i) {
                for (int ii = rankM2; ii > 0; --ii) {
                    if (sOrigin[ii] < shape[ii]) continue;
                    int n = ii - 1;
                    sOrigin[n] = sOrigin[n] + 1;
                    sOrigin[ii] = 0;
                }
                if (sOrigin[rank - 2] == 0 && i > 0) {
                    writer.write(SYSTEM_EOL);
                }
                Array slice = this.varDS_.read(sOrigin, sShape).reduce();
                Index index = slice.getIndex();
                for (int j = 0; j < cols; ++j) {
                    Object o = slice.getObject(index.set(j));
                    writer.write(o.toString());
                    if (j >= cols - 1) continue;
                    writer.write(",");
                }
                writer.write(SYSTEM_EOL);
                if (rankM2 < 0) continue;
                int n = rankM2;
                sOrigin[n] = sOrigin[n] + 1;
            }
        }
        catch (Exception exc) {
            logger_.error("Failed to write complete CSV file");
            logger_.error(exc.toString());
            exc.printStackTrace();
        }
        writer.close();
    }

    public void printLabeledText(File f) throws IOException {
        PrintWriter writer = new PrintWriter(f);
        int rank = this.varDS_.getRank();
        int[] shape = this.varDS_.getShape();
        int rankM1 = rank - 1;
        int rankM2 = rank - 2;
        int cols = shape[rankM1];
        int rows = 1;
        for (int i = 0; i < rankM1; ++i) {
            rows *= shape[i];
        }
        int[] sOrigin = new int[rank];
        int[] sShape = new int[rank];
        for (int i = 0; i < rankM1; ++i) {
            sOrigin[i] = 0;
            sShape[i] = 1;
        }
        sOrigin[rankM1] = 0;
        sShape[rankM1] = shape[rankM1];
        try {
            int i;
            if (this.dimensions_ == null) {
                this.extractDimensions();
            }
            Object[][] dimvals = new Object[rank][];
            for (i = 0; i < rank; ++i) {
                Dimension d = this.varDS_.getDimension(i);
                writer.write("" + d.getName() + "\t");
                dimvals[i] = this.dimensions_[i].getValues();
            }
            writer.write(this.varDS_.getFullName());
            writer.write(SYSTEM_EOL);
            for (i = 0; i < rows; ++i) {
                for (int ii = rankM2; ii > 0; --ii) {
                    if (sOrigin[ii] < shape[ii]) continue;
                    int n = ii - 1;
                    sOrigin[n] = sOrigin[n] + 1;
                    sOrigin[ii] = 0;
                }
                Array slice = this.varDS_.read(sOrigin, sShape).reduce();
                Index index = slice.getIndex();
                for (int j = 0; j < shape[rankM1]; ++j) {
                    Object o = slice.getObject(index.set(j));
                    for (int ii = 0; ii < rankM1; ++ii) {
                        this.printObject(writer, dimvals[ii][sOrigin[ii]]);
                        writer.write("\t");
                    }
                    this.printObject(writer, dimvals[rankM1][j]);
                    writer.write("\t");
                    this.printObject(writer, o);
                    writer.write(SYSTEM_EOL);
                }
                if (rankM2 < 0) continue;
                int n = rankM2;
                sOrigin[n] = sOrigin[n] + 1;
            }
        }
        catch (Exception exc) {
            logger_.error("Failed to write complete file");
            logger_.error(exc.toString());
            exc.printStackTrace();
        }
        writer.close();
    }

    private void printObject(Writer writer, Object o) throws IOException {
        if (!(o instanceof Number)) {
            writer.write("\"");
        }
        writer.write(o.toString());
        if (!(o instanceof Number)) {
            writer.write("\"");
        }
    }

    public NcDimension getDimension(int index) {
        if (this.dimensions_ == null) {
            this.extractDimensions();
        }
        return this.dimensions_[index];
    }

    public NcDimension[] getDimensions() {
        if (this.dimensions_ == null) {
            this.extractDimensions();
        }
        return this.dimensions_;
    }

    private void extractDimensions() {
        int rank = this.varDS_.getRank();
        this.dimensions_ = new NcDimension[rank];
        for (int i = 0; i < rank; ++i) {
            Dimension d = this.varDS_.getDimension(i);
            this.dimensions_[i] = new NcDimension(this.dataset_, this.varDS_, d);
        }
    }

    public static enum Axes {
        LON_LAT,
        LAT_VERT,
        LON_VERT,
        TIME_LAT;

    }
}

