/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcGeometryType;
import gov.nasa.giss.netcdf.NcVarType;
import gov.nasa.giss.netcdf.time.NcAbsoluteTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.VariableDS;

public class NcVarUtilities {
    private static Logger logger_ = LoggerFactory.getLogger(NcVarUtilities.class);

    private NcVarUtilities() {
    }

    public static String getLongName(Variable var) {
        if (var == null) {
            throw new IllegalArgumentException("Null variable passed.");
        }
        Attribute a = var.findAttributeIgnoreCase("long_name");
        if (a == null) {
            a = var.findAttributeIgnoreCase("standard_name");
        }
        if (a == null) {
            a = var.findAttributeIgnoreCase("title");
        }
        if (a == null) {
            return var.getShortName();
        }
        return a.getStringValue().replaceAll("\\s*$", "").replace('_', ' ');
    }

    public static String getUnits(Variable var) {
        if (var == null) {
            throw new IllegalArgumentException("Null variable passed.");
        }
        Attribute a = var.findAttributeIgnoreCase("units");
        if (a == null) {
            a = var.findAttributeIgnoreCase("unit");
        }
        if (a == null) {
            return "";
        }
        return a.getStringValue().replaceAll("\\s*$", "");
    }

    public static NcVarType getVarType(NcDataset ncd, String varname) {
        return NcVarUtilities.getVarType(ncd, ncd.findVariable(varname));
    }

    public static NcVarType getVarType(NcDataset ncd, VariableDS varDS) {
        NcGeometryType geometry = ncd.getGeometry();
        if (geometry == NcGeometryType.TRAJECTORY) {
            return NcVarUtilities.getDiscreteVarType(ncd, varDS);
        }
        return NcVarUtilities.getGriddedVarType(ncd, varDS);
    }

    public static NcVarType getDiscreteVarType(NcDataset ncd, VariableDS varDS) {
        if (true & NcVarUtilities.isScatterLonLat(varDS)) {
            return NcVarType.LL_SCATTER_NODES;
        }
        return NcVarType.OTHER;
    }

    public static NcVarType getGriddedVarType(NcDataset ncd, VariableDS varDS) {
        CoordinateAxis tAxis;
        boolean hasTime;
        boolean hasVert;
        CoordinateAxis latAxis;
        List<CoordinateSystem> csList = varDS.getCoordinateSystems();
        if (csList.size() < 1) {
            return NcVarType.OTHER;
        }
        CoordinateSystem cs = csList.get(0);
        if (logger_.isDebugEnabled()) {
            List<CoordinateAxis> axesList = cs.getCoordinateAxes();
        }
        Attribute gr = varDS.findAttributeIgnoreCase("grid");
        boolean hasLon = false;
        boolean hasLat = false;
        CoordinateAxis lonAxis = cs.getLonAxis();
        if (lonAxis != null) {
            int[] shape = lonAxis.getShape();
            if (shape == null || shape.length < 1 || shape[0] < 2) {
                lonAxis = null;
            }
            boolean bl = hasLon = lonAxis != null;
        }
        if ((latAxis = cs.getLatAxis()) != null) {
            int[] shape = latAxis.getShape();
            if (shape == null || shape.length < 1 || shape[0] < 2) {
                latAxis = null;
            }
            boolean bl = hasLat = latAxis != null;
        }
        if (cs.isLatLon() && hasLon && hasLat) {
            boolean altLonLat;
            NcVarType pgtype = NcVarUtilities.sniffProjectedVarType1(ncd, varDS);
            if (pgtype != null && pgtype != NcVarType.LON_LAT) {
                return pgtype;
            }
            boolean bl = altLonLat = NcVarUtilities.findDimensionIndex(varDS, lonAxis.getFullName()) < 0 && NcVarUtilities.findDimensionIndex(varDS, latAxis.getFullName()) < 0;
            if (altLonLat) {
                if (NcVarUtilities.is2DAuxiliaryLonLat(varDS)) {
                    return NcVarType.LL_AUXILIARY;
                }
                if (NcVarUtilities.hasRotLonLatDimensions(ncd, varDS)) {
                    return NcVarType.LL_ROTATED_POLE;
                }
                if (NcVarUtilities.isTiledAuxiliaryLonLat(varDS)) {
                    return NcVarType.LL_AUXILIARY;
                }
                if (NcVarUtilities.isReducedLonLatType1(ncd, varDS)) {
                    return NcVarType.LL_REDUCED_TYPE1;
                }
                if (NcVarUtilities.isReducedLonLatType2(ncd, varDS)) {
                    return NcVarType.LL_REDUCED_TYPE2;
                }
                if (NcVarUtilities.is1DAuxiliaryLonLat(varDS)) {
                    hasLon = true;
                    hasLat = true;
                } else {
                    hasLon = false;
                    hasLat = false;
                }
            }
            Attribute cc = varDS.findAttributeIgnoreCase("coordinates");
        } else if (cs.isGeoXY() || cs.getXaxis() != null && cs.getYaxis() != null) {
            NcVarType pgvt;
            List<CoordinateTransform> ctList = cs.getCoordinateTransforms();
            if ((ctList == null || ctList.size() < 1) && (pgvt = NcVarUtilities.sniffProjectedVarType1(ncd, varDS)) != null) {
                return pgvt;
            }
            if (ctList != null && ctList.size() > 0) {
                CoordinateTransform ct = ctList.get(0);
                String ctname = ct.getName();
                VariableDS ctv = ncd.findVariable(ctname);
                if (ctv == null) {
                    NcVarType pgvt2 = NcVarUtilities.sniffProjectedVarType1(ncd, varDS);
                    if (pgvt2 != null) {
                        return pgvt2;
                    }
                } else {
                    NcVarType pgvt3 = NcVarUtilities.sniffProjectedVarType2(ncd, varDS, ctv);
                    if (pgvt3 != null) {
                        return pgvt3;
                    }
                }
            }
            if (NcVarUtilities.is2DAuxiliaryLonLat(varDS) || NcVarUtilities.isTiledAuxiliaryLonLat(varDS)) {
                return NcVarType.LL_AUXILIARY;
            }
        }
        if (NcVarUtilities.hasRotLonLatDimensions(ncd, varDS)) {
            return NcVarType.LL_ROTATED_POLE;
        }
        if (!hasLon && !hasLat && NcVarUtilities.hasMessyLonLatDimensions(ncd, varDS)) {
            hasLon = true;
            hasLat = true;
        }
        if (hasVert = cs.hasVerticalAxis()) {
            CoordinateAxis zAxis = cs.getPressureAxis();
            if (zAxis == null) {
                zAxis = cs.getHeightAxis();
            }
            if (zAxis == null) {
                zAxis = cs.getZaxis();
            }
            boolean bl = hasVert = zAxis != null && zAxis.getShape().length == 1 && zAxis.getShape()[0] >= 2;
        }
        if (hasTime = (hasTime = cs.hasTimeAxis()) ? (tAxis = cs.getTaxis()) != null && tAxis.getShape().length >= 1 && tAxis.getShape()[0] >= 2 : NcVarUtilities.hasAbsoluteTimeDimension(ncd, varDS)) {
            if (hasLon && hasLat && hasVert) {
                return NcVarType.LON_LAT_VERT_TIME;
            }
            if (hasLon && hasLat) {
                return NcVarType.LON_LAT_TIME;
            }
            if (hasLat && hasVert) {
                return NcVarType.LAT_VERT_TIME;
            }
            if (hasLon && hasVert) {
                return NcVarType.LON_VERT_TIME;
            }
            if (hasLat) {
                return NcVarType.LAT_TIME;
            }
        }
        if (hasLon && hasLat && hasVert) {
            return NcVarType.LON_LAT_VERT;
        }
        if (hasLon && hasLat) {
            return NcVarType.LON_LAT;
        }
        if (hasLat && hasVert) {
            return NcVarType.LAT_VERT;
        }
        if (hasLon && hasVert) {
            return NcVarType.LON_VERT;
        }
        return NcVarType.OTHER;
    }

    private static int findDimensionIndex(VariableDS var, String dimName) {
        int index = var.findDimensionIndex(dimName);
        if (index > -1) {
            return index;
        }
        List<Dimension> dimensions = var.getDimensions();
        int isize = dimensions.size();
        for (int i = 0; i < isize; ++i) {
            Dimension d = dimensions.get(i);
            if (!dimName.equals(d.makeFullName())) continue;
            return i;
        }
        return -1;
    }

    private static NcVarType sniffFvcom(NcDataset ncd, VariableDS varDS) {
        VariableDS evar = ncd.findVariable("nv");
        int nodeDim = NcVarUtilities.findDimensionIndex(varDS, "node");
        int neleDim = NcVarUtilities.findDimensionIndex(varDS, "nele");
        int[] shape = varDS.getShape();
        VariableDS lonDim = ncd.findVariable("lon");
        VariableDS latDim = ncd.findVariable("lat");
        if (evar != null && lonDim != null && latDim != null) {
            if (nodeDim > -1) {
                int numNodes = shape[nodeDim];
                if (lonDim.getSize() == (long)numNodes && latDim.getSize() == (long)numNodes) {
                    return NcVarType.LL_FVCOM_NODES;
                }
            } else if (neleDim > -1) {
                int numElems = shape[neleDim];
                int eneleDim = NcVarUtilities.findDimensionIndex(evar, "nele");
                int[] eshape = evar.getShape();
                if (eshape[eneleDim] == numElems) {
                    return NcVarType.LL_FVCOM_ELEMENTS;
                }
            }
        }
        return null;
    }

    private static NcVarType sniffProjectedVarType1(NcDataset ncd, VariableDS varDS) {
        VariableDS tvarDS = NcVarUtilities.findGridMappingVariable(ncd, varDS);
        if (tvarDS == null) {
            return null;
        }
        return NcVarUtilities.sniffProjectedVarType2(ncd, varDS, tvarDS);
    }

    private static NcVarType sniffProjectedVarType2(NcDataset ncd, VariableDS varDS, VariableDS tvarDS) {
        String gname = NcVarUtilities.findGridMappingName(tvarDS);
        if (gname == null) {
            return null;
        }
        NcVarType result = NcVarUtilities.getVarTypeForGridMapping(gname);
        if (result == null) {
            return null;
        }
        List<CoordinateSystem> l = varDS.getCoordinateSystems();
        if (l == null || l.size() < 1) {
            return null;
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            return null;
        }
        CoordinateAxis geox = cs.getXaxis();
        CoordinateAxis geoy = cs.getYaxis();
        if (geox == null || geoy == null) {
            result = null;
        }
        return result;
    }

    public static VariableDS findGridMappingVariable(NcDataset ncd, VariableDS varDS) {
        List<CoordinateTransform> ctList;
        String tvarName = null;
        List<CoordinateSystem> csList = varDS.getCoordinateSystems();
        if (csList.size() < 1) {
            return null;
        }
        CoordinateSystem cs = csList.get(0);
        if (cs != null && (ctList = cs.getCoordinateTransforms()).size() > 0) {
            CoordinateTransform ct = ctList.get(0);
            tvarName = ct.getName();
        }
        if (tvarName == null) {
            Attribute a = varDS.findAttributeIgnoreCase("grid_mapping");
            if (a == null) {
                a = varDS.findAttributeIgnoreCase("_CoordinateSystems");
                if (a == null) {
                    return null;
                }
                VariableDS pcsDS = ncd.findVariable(a.getStringValue());
                if (pcsDS == null) {
                    return null;
                }
                a = pcsDS.findAttributeIgnoreCase("_CoordinateTransforms");
            }
            if (a != null) {
                tvarName = a.getStringValue();
            }
        }
        if (tvarName == null) {
            return null;
        }
        VariableDS mappingVarDS = ncd.findVariable(tvarName);
        return mappingVarDS;
    }

    public static String findGridMappingName(VariableDS tvarDS) {
        Attribute a = tvarDS.findAttributeIgnoreCase("grid_mapping_name");
        if (a == null) {
            a = tvarDS.findAttributeIgnoreCase("Projection_Name");
        }
        if (a == null) {
            a = tvarDS.findAttributeIgnoreCase("transform_name");
        }
        if (a == null) {
            return null;
        }
        return a.getStringValue();
    }

    public static NcVarType getVarTypeForGridMapping(String tname) {
        Object result = null;
        if (tname.equals("latitude_longitude")) {
            return NcVarType.LON_LAT;
        }
        if (tname.equalsIgnoreCase("albers_equal_area_conic") || tname.equalsIgnoreCase("albers_conical_equal_area")) {
            return NcVarType.LL_ALBERS_CONIC;
        }
        if (tname.equalsIgnoreCase("lambert_azimuthal_equal_area")) {
            return NcVarType.LL_AZIM_EQUAL_AREA;
        }
        if (tname.equalsIgnoreCase("lambert_conformal_conic")) {
            return NcVarType.LL_LAMBERT_CONFORMAL;
        }
        if (tname.equalsIgnoreCase("mercator")) {
            return NcVarType.LL_MERCATOR;
        }
        if (tname.equalsIgnoreCase("rotated_pole") || tname.equalsIgnoreCase("rotated_latitude_longitude")) {
            return NcVarType.LL_ROTATED_POLE;
        }
        if (tname.equalsIgnoreCase("sinusoidal")) {
            return NcVarType.LL_SINUSOIDAL;
        }
        if (tname.equalsIgnoreCase("polar_stereographic") || tname.equalsIgnoreCase("stereographic")) {
            return NcVarType.LL_STEREOGRAPHIC;
        }
        if (tname.equalsIgnoreCase("transverse_mercator")) {
            return NcVarType.LL_TRANSVERSE_MERCATOR;
        }
        if (tname.equals("")) {
            // empty if block
        }
        return null;
    }

    private static boolean hasRotLonLatDimensions(NcDataset ncd, Variable varDS) {
        int rank = varDS.getRank();
        String lonName = null;
        String latName = null;
        for (int i = 0; i < rank; ++i) {
            Dimension d = varDS.getDimension(i);
            String dname = d.getShortName();
            if (dname == null) continue;
            String lcname = dname.toLowerCase();
            if (lcname.contains("lon")) {
                lonName = dname;
                continue;
            }
            if (!lcname.contains("lat")) continue;
            latName = dname;
        }
        if (lonName != null && latName != null) {
            VariableDS lonV = ncd.findVariable(lonName);
            VariableDS latV = ncd.findVariable(latName);
            if (lonV == null || latV == null) {
                return false;
            }
            Attribute lonA = ncd.findVariable(lonName).findAttribute("long_name");
            Attribute latA = ncd.findVariable(latName).findAttribute("long_name");
            if (lonA != null && latA != null && lonA.getStringValue().contains("rotated") && latA.getStringValue().contains("rotated")) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasMessyLonLatDimensions(NcDataset ncd, VariableDS varDS) {
        boolean hasLon = false;
        boolean hasLat = false;
        int rank = varDS.getRank();
        for (int i = 0; i < rank; ++i) {
            Dimension d = varDS.getDimension(i);
            String name = d.getName();
            if (name == null) continue;
            VariableDS v = ncd.findVariable(name);
            if (NcVarUtilities.isLongitudeVar(v)) {
                hasLon = true;
                continue;
            }
            if (!NcVarUtilities.isLatitudeVar(v)) continue;
            hasLat = true;
        }
        return hasLon && hasLat;
    }

    public static boolean isLongitudeVar(Variable v) {
        if (v == null) {
            return false;
        }
        String name = v.getFullName();
        String units = NcVarUtilities.getUnits(v);
        int rank = v.getRank();
        return rank == 1 && units.equalsIgnoreCase("degrees_east");
    }

    public static boolean isLatitudeVar(Variable v) {
        if (v == null) {
            return false;
        }
        String name = v.getFullName();
        String units = NcVarUtilities.getUnits(v);
        int rank = v.getRank();
        return rank == 1 && units.equalsIgnoreCase("degrees_north");
    }

    private static boolean is1DAuxiliaryLonLat(VariableDS varDS) {
        List<CoordinateSystem> l = varDS.getCoordinateSystems();
        if (l == null || l.size() < 1) {
            return false;
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            return false;
        }
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        if (lonax == null || latax == null) {
            return false;
        }
        int[] lonshape = lonax.getShape();
        int[] latshape = latax.getShape();
        if (!(lonax instanceof CoordinateAxis1D)) {
            return false;
        }
        if (!(latax instanceof CoordinateAxis1D)) {
            return false;
        }
        if (lonshape.length != 1 || lonshape[0] < 2) {
            return false;
        }
        return latshape.length == 1 && latshape[0] >= 2;
    }

    private static boolean isReducedLonLatType1(NcDataset ncd, VariableDS varDS) {
        Dimension d2;
        List<CoordinateSystem> l = varDS.getCoordinateSystems();
        if (l == null || l.size() < 1) {
            return false;
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            return false;
        }
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        if (lonax == null || latax == null) {
            return false;
        }
        int[] lonshape = lonax.getShape();
        int[] latshape = latax.getShape();
        if (!(lonax instanceof CoordinateAxis1D)) {
            return false;
        }
        if (!(latax instanceof CoordinateAxis1D)) {
            return false;
        }
        if (lonshape.length != 1 || lonshape[0] < 2) {
            return false;
        }
        if (latshape.length != 1 || latshape[0] < 2) {
            return false;
        }
        Dimension d1 = lonax.getDimension(0);
        if (!d1.equals(d2 = latax.getDimension(0))) {
            return false;
        }
        int rank = varDS.getRank();
        boolean found = false;
        for (int i = 0; i < rank; ++i) {
            Dimension d = varDS.getDimension(i);
            if (!d.equals(d1)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        String dname = d1.getFullName();
        if (dname == null) {
            return false;
        }
        VariableDS dimvar = ncd.findVariable(dname);
        Attribute compressA = dimvar.findAttribute("compress");
        if (compressA == null) {
            return false;
        }
        String compress = compressA.getStringValue();
        String[] tokens = compress.split(" ");
        if (tokens.length != 2) {
            return false;
        }
        Dimension dd1 = ncd.findDimension(tokens[0]);
        Dimension dd2 = ncd.findDimension(tokens[1]);
        return dd1 != null && dd2 != null;
    }

    private static boolean isReducedLonLatType2(NcDataset ncd, VariableDS varDS) {
        List<CoordinateSystem> l = varDS.getCoordinateSystems();
        if (l == null || l.size() < 1) {
            return false;
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            return false;
        }
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        if (lonax == null || latax == null) {
            return false;
        }
        int[] lonshape = lonax.getShape();
        int[] latshape = latax.getShape();
        if (!(lonax instanceof CoordinateAxis2D)) {
            return false;
        }
        if (!(latax instanceof CoordinateAxis2D)) {
            return false;
        }
        if (lonshape.length != 2) {
            return false;
        }
        if (latshape.length != 2) {
            return false;
        }
        Dimension d11 = lonax.getDimension(0);
        Dimension d12 = lonax.getDimension(1);
        Dimension d21 = latax.getDimension(0);
        Dimension d22 = latax.getDimension(1);
        if (!d11.equals(d21)) {
            return false;
        }
        if (!d12.equals(d22)) {
            return false;
        }
        int rank = varDS.getRank();
        boolean found = false;
        for (int i = 0; i < rank; ++i) {
            String compress;
            String[] tokens;
            VariableDS dimvar;
            Attribute compressA;
            Dimension d = varDS.getDimension(i);
            String dname = d.getFullName();
            if (dname == null || (compressA = (dimvar = ncd.findVariable(dname)).findAttribute("compress")) == null || (tokens = (compress = compressA.getStringValue()).split(" ")).length != 2) continue;
            Dimension dd1 = ncd.findDimension(tokens[0]);
            Dimension dd2 = ncd.findDimension(tokens[1]);
            if (!d11.equals(dd1) || !d12.equals(dd2)) continue;
            return true;
        }
        return false;
    }

    private static boolean is2DAuxiliaryLonLat(VariableDS varDS) {
        List<CoordinateSystem> l = varDS.getCoordinateSystems();
        if (l == null || l.size() < 1) {
            return false;
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            return false;
        }
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        if (lonax == null || latax == null) {
            return false;
        }
        int[] lonshape = lonax.getShape();
        int[] latshape = latax.getShape();
        if (lonshape.length != 2 || lonshape[0] < 2 || lonshape[1] < 2) {
            return false;
        }
        if (latshape.length != 2 || latshape[0] < 2 || latshape[1] < 2) {
            return false;
        }
        if (lonshape[0] != latshape[0] || lonshape[1] != latshape[1]) {
            return false;
        }
        if (!(lonax instanceof CoordinateAxis2D)) {
            return false;
        }
        if (!(latax instanceof CoordinateAxis2D)) {
            return false;
        }
        Dimension d11 = lonax.getDimension(0);
        Dimension d12 = lonax.getDimension(1);
        Dimension d21 = latax.getDimension(0);
        Dimension d22 = latax.getDimension(1);
        if (!d11.equals(d21) || !d12.equals(d22)) {
            return false;
        }
        int rank = varDS.getRank();
        boolean found1 = false;
        boolean found2 = false;
        for (int i = 0; i < rank; ++i) {
            Dimension d = varDS.getDimension(i);
            if (d.equals(d11)) {
                found1 = true;
                continue;
            }
            if (!d.equals(d12)) continue;
            found2 = true;
        }
        return found1 && found2;
    }

    private static boolean isTiledAuxiliaryLonLat(VariableDS varDS) {
        List<CoordinateSystem> l = varDS.getCoordinateSystems();
        if (l == null || l.size() < 1) {
            return false;
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            return false;
        }
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        if (lonax == null || latax == null) {
            return false;
        }
        int[] lonshape = lonax.getShape();
        int[] latshape = latax.getShape();
        if (lonshape.length != 3 || lonshape[0] < 2 || lonshape[1] < 2 || lonshape[2] < 2) {
            return false;
        }
        if (latshape.length != 3 || latshape[0] < 2 || latshape[1] < 2 || latshape[2] < 2) {
            return false;
        }
        return lonshape[0] == latshape[0] && lonshape[1] == latshape[1] && lonshape[2] == latshape[2];
    }

    private static boolean isScatterLonLat(VariableDS varDS) {
        List<CoordinateSystem> l = varDS.getCoordinateSystems();
        if (l == null || l.size() < 1) {
            return false;
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            return false;
        }
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        if (lonax == null || latax == null) {
            return false;
        }
        return lonax instanceof CoordinateAxis1D && latax instanceof CoordinateAxis1D;
    }

    public static boolean hasAbsoluteTimeDimension(NcDataset ncd, VariableDS varDS) {
        int rank = varDS.getRank();
        for (int i = 0; i < rank; ++i) {
            VariableDS v;
            Dimension d = varDS.getDimension(i);
            String name = d.getName();
            if (name == null || !NcVarUtilities.isAbsoluteTimeVar(v = ncd.findVariable(name))) continue;
            return true;
        }
        return false;
    }

    public static boolean isAbsoluteTimeVar(Variable v) {
        if (v == null) {
            return false;
        }
        int rank = v.getRank();
        if (rank > 1) {
            return false;
        }
        Attribute unitsA = v.findAttribute("units");
        if (unitsA == null) {
            return false;
        }
        String units = unitsA.getStringValue();
        return NcAbsoluteTime.isAbsoluteTime(units);
    }
}

