/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.util.FileUtilities;
import java.io.File;
import java.util.Date;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.net.HttpClientManager;

public class NcUtilities {
    private static Logger logger_ = LoggerFactory.getLogger(NcUtilities.class);
    private static File cacheDir_;

    private NcUtilities() {
    }

    public static void initHttpClient(String agent, CredentialsProvider cprov) {
        HttpClientManager.init(cprov, agent + " ");
    }

    public static void initCache(String appname, String qAppname) {
        if (cacheDir_ != null) {
            return;
        }
        cacheDir_ = FileUtilities.getApplicationCacheDir(appname, qAppname);
        if (cacheDir_ == null) {
            logger_.warn("Got null creating cache directory object {}", (Object)cacheDir_);
            return;
        }
        try {
            if (!cacheDir_.exists()) {
                cacheDir_.mkdirs();
            }
        }
        catch (Exception exc) {
            logger_.warn("Could not create cache directory: {}", (Object)cacheDir_);
            logger_.warn(exc.toString());
            return;
        }
        DiskCache.setRootDirectory(cacheDir_.getAbsolutePath());
        DiskCache.setCachePolicy(true);
    }

    public static void clearCache() {
        DiskCache.cleanCache(new Date(), new StringBuilder());
        try {
            FileUtilities.deleteContents(cacheDir_);
        }
        catch (Exception exc) {
            logger_.warn("Error clearing cache directory {}", (Object)cacheDir_);
        }
    }
}

