/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.time.NcAbsoluteTime;
import gov.nasa.giss.netcdf.time.NcDataTime;
import gov.nasa.giss.netcdf.time.NcJulianTime;
import gov.nasa.giss.netcdf.time.NcRelativeTime;
import gov.nasa.giss.time.JulianType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateAxis;

public class NcTimeAxis
extends NcAxis {
    private static Logger logger_ = LoggerFactory.getLogger(NcTimeAxis.class);
    private NcDataTime timeParser_;

    public NcTimeAxis(NcDataset dataset, CoordinateAxis axis) {
        super(dataset, axis);
        String units = this.getUnits();
        if (units == null) {
            return;
        }
        if (units.indexOf(" since ") > 0) {
            try {
                this.timeParser_ = new NcRelativeTime(dataset, axis);
            }
            catch (Exception exc) {
                this.timeParser_ = null;
            }
        } else if (units.indexOf(" as ") > 0) {
            try {
                this.timeParser_ = new NcAbsoluteTime(axis);
            }
            catch (Exception exc) {
                this.timeParser_ = null;
                exc.printStackTrace();
            }
        } else if (units.equalsIgnoreCase("Julian Date") || units.equalsIgnoreCase("Julian Day") || units.equalsIgnoreCase("True Julian Date") || units.equalsIgnoreCase("True Julian Day")) {
            try {
                this.timeParser_ = new NcJulianTime();
            }
            catch (Exception exc) {
                this.timeParser_ = null;
                exc.printStackTrace();
            }
        } else if (units.equalsIgnoreCase("Modified Julian Date") || units.equalsIgnoreCase("Modified Julian Day")) {
            try {
                this.timeParser_ = new NcJulianTime(JulianType.MODIFIED);
            }
            catch (Exception exc) {
                this.timeParser_ = null;
                exc.printStackTrace();
            }
        }
    }

    public NcDataTime getFormatter() {
        return this.timeParser_;
    }

    public boolean isFormattedTime() {
        return this.timeParser_ != null;
    }

    @Override
    public String getUnits() {
        if (this.timeParser_ != null) {
            return "Date/Time";
        }
        return super.getUnits();
    }

    public String formattedValueAt(int index) {
        if (this.timeParser_ == null) {
            return null;
        }
        return this.timeParser_.format(this.valueAt(index));
    }

    public String[] formattedBoundsAt(int index) {
        if (this.timeParser_ == null) {
            return new String[]{null, null};
        }
        double[] bounds = this.boundsAt(index);
        return new String[]{this.timeParser_.format(bounds[0]), this.timeParser_.format(bounds[1])};
    }

    public String formattedBoundsAt(int index1, int index2) {
        if (this.timeParser_ == null) {
            return null;
        }
        return this.timeParser_.format(this.boundsAt(index1, index2));
    }
}

