/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.netcdf.NcStructureVar;
import java.io.IOException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Variable;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;

public class NcStructure
extends NcNode {
    private static Logger logger_ = LoggerFactory.getLogger(NcStructure.class);
    private StructureDS structDS_;
    private NcDataset dataset_;
    private String name_ = "STRUCT";

    public NcStructure(NcDataset d, StructureDS s) throws IOException {
        this.setParent(d);
        this.dataset_ = d;
        this.structDS_ = s;
        this.initChildren();
    }

    public VariableDS findVariable(String name) {
        return (VariableDS)this.structDS_.findVariable(name);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getName() {
        return this.structDS_.getFullName();
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    @Override
    public String getNcType() {
        return "\u2014";
    }

    @Override
    public String getDetail() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<h2>Structure \"").append(this.getName()).append("\"</h2>\n");
        sb.append("<hr>");
        sb.append("<pre>");
        sb.append(StringEscapeUtils.escapeHtml4(this.structDS_.toString()));
        sb.append("\n");
        sb.append("</pre>");
        sb.append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    private void initChildren() {
        this.clear();
        for (Variable var : this.structDS_.getVariables()) {
            try {
                this.addAlphabetically(new NcStructureVar(var));
            }
            catch (Exception exc) {
                logger_.warn("NcStructure initChildren");
                exc.printStackTrace();
            }
        }
    }
}

