/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcGroup;
import gov.nasa.giss.netcdf.NcHdfPalette;
import gov.nasa.giss.netcdf.NcStructure;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.gui.NcTreeTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;

public abstract class NcNode
extends TreeTableNode {
    private static Logger logger_ = LoggerFactory.getLogger(NcNode.class);
    protected NcDataset dataset_;
    protected Group group_;
    protected boolean showOnlyPlottables_ = false;

    public abstract String getLongName();

    public abstract String getDetail();

    protected void appendDetailStyle(StringBuffer sb) {
        sb.append("<style type=\"text/css\"><!-- ");
        sb.append("body {padding:8px;margin:8px}");
        sb.append("body h2 {font-family:sans-serif;font-size:12px;margin-bottom:0;padding-bottom:0} ");
        sb.append("body p  {font-size:10px;font-family:sans-serif } ");
        sb.append("body pre {font-size:10px } ");
        sb.append("body hr  {border:none;background-color:#999;color:#999;height:1px} ");
        sb.append("// --></style>");
    }

    public abstract String getDetailType();

    public abstract String getNcType();

    protected static void initChildrenFromGroup(NcDataset dataset, NcNode node, Group group, boolean onlyPlottables) {
        if (!(node instanceof NcDataset) && !(node instanceof NcGroup)) {
            return;
        }
        if (dataset == null) {
            throw new IllegalArgumentException("NcDataset has not been specified");
        }
        if (group == null) {
            throw new IllegalArgumentException("Group has not been specified");
        }
        node.clear();
        for (Group group2 : group.getGroups()) {
            try {
                node.addAlphabetically(new NcGroup(dataset, group2));
            }
            catch (Exception exc) {
                logger_.error("Could not create NCGroup");
                exc.printStackTrace();
            }
        }
        for (Variable variable : group.getVariables()) {
            try {
                if (variable instanceof VariableDS) {
                    VariableDS vds = (VariableDS)variable;
                    Attribute classAttr = vds.findAttribute("CLASS");
                    if (classAttr != null && classAttr.getStringValue().equals("PALETTE")) {
                        if (onlyPlottables) continue;
                        node.addAlphabetically(new NcHdfPalette(dataset, vds));
                        continue;
                    }
                    NcVariable ncv = new NcVariable(dataset, vds);
                    if (!ncv.isPlottable() && onlyPlottables) continue;
                    node.addAlphabetically(ncv);
                    continue;
                }
                if (variable instanceof StructureDS) {
                    node.addAlphabetically(new NcStructure(dataset, (StructureDS)variable));
                    continue;
                }
                logger_.warn("Unrecognized Variable class {}", (Object)variable.getClass());
            }
            catch (Exception exc) {
                logger_.error("(Variables)");
                exc.printStackTrace();
            }
        }
    }

    public int addAlphabetically(NcNode node) {
        if (!this.getAllowsChildren()) {
            throw new NcException("Node does not allow children");
        }
        int isize = this.getChildCount();
        String name = node.getName();
        for (int i = 0; i < isize; ++i) {
            NcNode inode = (NcNode)this.getChildAt(i);
            if (node.equals(inode)) {
                throw new NcException("Child node already added");
            }
            String iname = inode.getName();
            int compare = name.compareToIgnoreCase(iname);
            if (compare >= 0) continue;
            super.add(i, node);
            node.setParent(this);
            return i;
        }
        super.add(node);
        return isize;
    }

    public void setShowOnlyPlottables(NcTreeTableModel model, boolean onlyPlottables) {
        NcNode node;
        int i;
        if (onlyPlottables == this.showOnlyPlottables_) {
            return;
        }
        this.showOnlyPlottables_ = onlyPlottables;
        TreeTableNode[] children = this.getChildren();
        if (children != null) {
            for (i = children.length - 1; i >= 0; --i) {
                node = (NcNode)children[i];
                node.setShowOnlyPlottables(model, onlyPlottables);
            }
        }
        if (onlyPlottables) {
            if (children == null) {
                return;
            }
            for (i = children.length - 1; i >= 0; --i) {
                node = (NcNode)children[i];
                if (node instanceof NcVariable) {
                    NcVariable ncv = (NcVariable)node;
                    if (ncv.isPlottable()) continue;
                    this.remove(node);
                    if (model == null) continue;
                    model.nodeRemoved(this, i, node);
                    continue;
                }
                if (!(node instanceof NcHdfPalette)) continue;
                this.remove(node);
                if (model == null) continue;
                model.nodeRemoved(this, i, node);
            }
        } else {
            if (this.group_ == null) {
                return;
            }
            for (Variable o : this.group_.getVariables()) {
                try {
                    int index;
                    NcNode node2;
                    if (!(o instanceof VariableDS)) continue;
                    VariableDS vds = (VariableDS)o;
                    Attribute classAttr = vds.findAttribute("CLASS");
                    if (classAttr != null && classAttr.getStringValue().equals("PALETTE")) {
                        node2 = new NcHdfPalette(this.dataset_, vds);
                        if (this.isChild(node2)) continue;
                        index = this.addAlphabetically(node2);
                        model.nodeInserted(this, index, node2);
                        continue;
                    }
                    node2 = new NcVariable(this.dataset_, vds);
                    if (this.isChild(node2)) continue;
                    index = this.addAlphabetically(node2);
                    model.nodeInserted(this, index, node2);
                }
                catch (Exception exc) {
                    logger_.error(exc.toString());
                    exc.printStackTrace();
                }
            }
        }
    }

    private boolean isChild(NcNode node) {
        TreeTableNode[] children = this.getChildren();
        if (children == null) {
            return false;
        }
        String name = node.getName();
        for (int i = 0; i < children.length; ++i) {
            NcNode onode = (NcNode)children[i];
            if (!name.equals(onode.getName())) continue;
            return true;
        }
        return false;
    }
}

